/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.spi.define;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;

public class MServiceParameterParser {
    private static final ParameterNameDiscoverer NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private static final Log log = LogFactory.getLog(MServiceParameterParser.class);
    private static int customLevle = Integer.getInteger("mservice.parameter.parser.level", 3);
    private static final Set<Class<?>> BASE_TYPES = new HashSet<Class>(Arrays.asList(String.class, Set.class, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Short.class, Short.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Boolean.class, Boolean.TYPE, Object.class));

    public static String[] getParameterNames(Method method) {
        return NAME_DISCOVERER.getParameterNames(method);
    }

    public static MServiceDefineMeta.ParamDefine parseParam(Type type) {
        return MServiceParameterParser.getPostParam(MServiceParameterParser.getTypeName(type, false), 0, type, 0);
    }

    public static MServiceDefineMeta.ParamDefine parseParam(String paramName, Parameter parameter) {
        return MServiceParameterParser.parseParam(paramName, parameter, "post");
    }

    public static MServiceDefineMeta.ParamDefine parseParam(String paramName, Parameter parameter, String httpMethod) {
        Type type = parameter.getParameterizedType();
        MServiceDefineMeta.ParamDefine paramDefine = "get".equals(httpMethod) ? new MServiceDefineMeta.ParamDefine(parameter.getType().getSimpleName(), MServiceParameterParser.getTypeName(type)) : MServiceParameterParser.getPostParam(paramName, 0, type, 0);
        return paramDefine;
    }

    private static MServiceDefineMeta.ParamDefine getPostParam(String varName, int level, Type type, int arrLevel) {
        if (type instanceof ParameterizedType) {
            MServiceDefineMeta.ParamDefine param;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (MServiceParameterParser.isCollection(parameterizedType)) {
                if (MServiceParameterParser.isPostBasicCollection(parameterizedType)) {
                    return MServiceParameterParser.getParamDefine(varName, level, type);
                }
                if (typeArguments.length > 1) {
                    log.error("Collection-> Generic parameters with the name: " + varName + " and type: " + type.getTypeName() + " are not supported");
                    throw new IllegalArgumentException("Collection-> Generic parameters with the name: " + varName + " and type: " + type.getTypeName() + " are not supported");
                }
                if (typeArguments.length == 0) {
                    return MServiceParameterParser.getParamDefine(varName, level, type);
                }
                Type typeArgument = typeArguments[0];
                if (typeArgument instanceof WildcardType) {
                    return MServiceParameterParser.getParamDefine(varName, level, type);
                }
                if (typeArgument instanceof Class) {
                    Class cls = (Class)typeArgument;
                    if (MServiceParameterParser.isArray(typeArgument)) {
                        MServiceDefineMeta.ParamDefine param2 = MServiceParameterParser.getParamDefineByClass(varName, level, cls, ++arrLevel);
                        return MServiceParameterParser.getParamDefineByType(param2, type);
                    }
                    MServiceDefineMeta.ParamDefine param3 = MServiceParameterParser.getParamDefine(varName, level, type);
                    MServiceParameterParser.parseClassParam(param3, (Class)typeArgument, level + 1);
                    param3.setArrayLevel(++arrLevel);
                    return param3;
                }
                if (typeArgument instanceof ParameterizedType) {
                    MServiceDefineMeta.ParamDefine param4 = MServiceParameterParser.getPostParam(varName, level, typeArgument, ++arrLevel);
                    return MServiceParameterParser.getParamDefineByType(param4, type);
                }
                if (typeArgument instanceof GenericArrayType) {
                    MServiceDefineMeta.ParamDefine param5 = MServiceParameterParser.getPostParam(varName, level, typeArgument, ++arrLevel);
                    return MServiceParameterParser.getParamDefineByType(param5, type);
                }
            }
            if (MServiceParameterParser.isMapOrMapArray(parameterizedType)) {
                param = MServiceParameterParser.getParamDefineByMap(varName, level, type, typeArguments);
                param.setArrayLevel(arrLevel);
                return param;
            }
            if (Class.class.equals((Object)parameterizedType.getRawType())) {
                param = MServiceParameterParser.getParamDefine(varName, level, parameterizedType.getRawType());
                return MServiceParameterParser.getParamDefineByType(param, type);
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            if (MServiceParameterParser.isPostBasicArray(genericArrayType)) {
                return MServiceParameterParser.getParamDefine(varName, level, genericArrayType);
            }
            if (MServiceParameterParser.isMapOrMapArray(genericArrayType)) {
                Type typeMapArray = genericArrayType.getGenericComponentType();
                MServiceDefineMeta.ParamDefine param = MServiceParameterParser.getPostParam(varName, level, typeMapArray, ++arrLevel);
                return MServiceParameterParser.getParamDefineByType(param, genericArrayType);
            }
            if (MServiceParameterParser.isArray(genericArrayType)) {
                Type typeMapArray = genericArrayType.getGenericComponentType();
                MServiceDefineMeta.ParamDefine param = MServiceParameterParser.getPostParam(varName, level, typeMapArray, ++arrLevel);
                return MServiceParameterParser.getParamDefineByType(param, genericArrayType);
            }
        } else {
            if (type instanceof Class) {
                return MServiceParameterParser.getParamDefineByClass(varName, level, (Class)type, arrLevel);
            }
            if (type instanceof WildcardType) {
                return MServiceParameterParser.getParamDefine(varName, level, type);
            }
            if (type instanceof TypeVariable) {
                log.error("TypeVariable-> Generic parameters with the name: " + varName + " and type: " + type.getTypeName() + " are not supported");
                throw new IllegalArgumentException("TypeVariable-> Generic parameters with the name: " + varName + " and type: " + type.getTypeName() + " are not supported");
            }
        }
        log.error("Generic parameters with the name: " + varName + " and type: " + type.getTypeName() + " are not supported");
        throw new IllegalArgumentException("Generic parameters with the name: " + varName + " and type: " + type.getTypeName() + " are not supported");
    }

    private static MServiceDefineMeta.ParamDefine getParamDefine(String varName, int level, Type type) {
        MServiceDefineMeta.ParamDefine paramDefine = new MServiceDefineMeta.ParamDefine();
        paramDefine.setName(varName);
        paramDefine.setLevel(level);
        paramDefine.setDescribe(MServiceParameterParser.getDesc(varName, type));
        paramDefine.setExample(MServiceParameterParser.getExample(type));
        paramDefine.setTypeStr(MServiceParameterParser.getTypeName(type, true));
        paramDefine.setSimpleTypeStr(MServiceParameterParser.getTypeName(type, false));
        paramDefine.setMulValue(MServiceParameterParser.isMulValueType(type));
        return paramDefine;
    }

    private static Object getExample(Type type) {
        if (type instanceof Class) {
            return MServiceParameterParser.getExampleByClass((Class)type);
        }
        if (type instanceof ParameterizedType) {
            Object it;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] arguments = parameterizedType.getActualTypeArguments();
            if (MServiceParameterParser.isPostBasicCollection(type) && !MServiceParameterParser.isExampleEmpty(it = MServiceParameterParser.getExample(arguments[0]))) {
                return Collections.singletonList(it);
            }
        } else if (type instanceof GenericArrayType) {
            Object it;
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            if (MServiceParameterParser.isPostBasicArray(type) && !MServiceParameterParser.isExampleEmpty(it = MServiceParameterParser.getExample(componentType))) {
                return Collections.singletonList(it);
            }
        }
        return null;
    }

    private static Object getExampleByClass(Class<?> cls) {
        if (String.class.isAssignableFrom(cls)) {
            return RandomStringUtils.randomAlphanumeric((int)5);
        }
        if (Date.class.isAssignableFrom(cls)) {
            return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());
        }
        if (!Boolean.TYPE.isAssignableFrom(cls) && !Boolean.class.isAssignableFrom(cls)) {
            if (!Byte.TYPE.isAssignableFrom(cls) && !Byte.class.isAssignableFrom(cls)) {
                if (!Character.TYPE.isAssignableFrom(cls) && !Character.class.isAssignableFrom(cls)) {
                    if (!Short.TYPE.isAssignableFrom(cls) && !Short.class.isAssignableFrom(cls)) {
                        if (!Integer.TYPE.isAssignableFrom(cls) && !Integer.class.isAssignableFrom(cls)) {
                            if (!Long.TYPE.isAssignableFrom(cls) && !Long.class.isAssignableFrom(cls)) {
                                if (!Double.TYPE.isAssignableFrom(cls) && !Double.class.isAssignableFrom(cls)) {
                                    if (!Float.TYPE.isAssignableFrom(cls) && !Float.class.isAssignableFrom(cls)) {
                                        Object it;
                                        if (BigDecimal.class.isAssignableFrom(cls)) {
                                            return NumberUtils.toScaledBigDecimal((Double)RandomUtils.nextDouble((double)1.0, (double)100.0), (int)4, (RoundingMode)RoundingMode.HALF_UP);
                                        }
                                        if (cls.isArray() && !MServiceParameterParser.isExampleEmpty(it = MServiceParameterParser.getExample(cls.getComponentType()))) {
                                            return Collections.singletonList(it);
                                        }
                                        return null;
                                    }
                                    return NumberUtils.toScaledBigDecimal((Float)Float.valueOf(RandomUtils.nextFloat((float)1.0f, (float)100.0f)), (int)2, (RoundingMode)RoundingMode.HALF_UP);
                                }
                                return NumberUtils.toScaledBigDecimal((Double)RandomUtils.nextDouble((double)1.0, (double)100.0), (int)3, (RoundingMode)RoundingMode.HALF_UP);
                            }
                            return System.currentTimeMillis() + (long)RandomUtils.nextInt((int)1, (int)100);
                        }
                        return RandomUtils.nextInt((int)1, (int)256);
                    }
                    return RandomUtils.nextInt((int)1, (int)Short.MAX_VALUE);
                }
                return RandomStringUtils.randomAlphabetic((int)1);
            }
            return RandomUtils.nextInt((int)1, (int)127);
        }
        return Boolean.FALSE;
    }

    private static boolean isExampleEmpty(Object example) {
        return example == null || example instanceof String && StringUtils.isEmpty((String)example.toString());
    }

    private static MServiceDefineMeta.ParamDefine getParamDefineByClass(String varName, int level, Class<?> cls, int arrLevel) {
        if (Map.class.isAssignableFrom(cls)) {
            Type superType = cls.getGenericSuperclass();
            if (superType != null && !(superType instanceof Class)) {
                MServiceDefineMeta.ParamDefine param = MServiceParameterParser.getPostParam(varName, level, superType, arrLevel);
                return MServiceParameterParser.getParamDefineByType(param, cls);
            }
            MServiceDefineMeta.ParamDefine param = MServiceParameterParser.getParamDefine(varName, level, cls);
            param.getChildParamDefines().add(MServiceParameterParser.getParamDefine("$key$", level + 1, Object.class));
            param.getChildParamDefines().add(MServiceParameterParser.getParamDefine("$value$", level + 1, Object.class));
            param.setMap(true);
            return param;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            Type superType = cls.getGenericSuperclass();
            if (superType != null && !(superType instanceof Class)) {
                MServiceDefineMeta.ParamDefine param = MServiceParameterParser.getPostParam(varName, level, superType, ++arrLevel);
                param.setArrayLevel(arrLevel);
                return MServiceParameterParser.getParamDefineByType(param, cls);
            }
            return MServiceParameterParser.getParamDefine(varName, level, cls);
        }
        if (!Void.class.equals(cls) && !Void.TYPE.equals(cls)) {
            if (!MServiceParameterParser.isBasicType(cls) && !MServiceParameterParser.isGetBasicArray(cls)) {
                if (MServiceParameterParser.isArray(cls)) {
                    if (MServiceParameterParser.isMapOrMapArray(cls)) {
                        Class<?> classArray = cls.getComponentType();
                        MServiceDefineMeta.ParamDefine param = MServiceParameterParser.getParamDefineByClass(varName, level, classArray, ++arrLevel);
                        return MServiceParameterParser.getParamDefineByType(param, cls);
                    }
                    Class<?> classArray = cls.getComponentType();
                    MServiceDefineMeta.ParamDefine param = MServiceParameterParser.getPostParam(varName, level, classArray, ++arrLevel);
                    return MServiceParameterParser.getParamDefineByType(param, cls);
                }
                MServiceDefineMeta.ParamDefine param = MServiceParameterParser.getParamDefine(varName, level, cls);
                MServiceParameterParser.parseClassParam(param, cls, level + 1);
                param.setArrayLevel(arrLevel);
                return param;
            }
            if (cls.isPrimitive()) {
                MServiceDefineMeta.ParamDefine paramDefine = MServiceParameterParser.getParamDefine(varName, level, cls);
                paramDefine.setPrimitive(true);
                return paramDefine;
            }
            return MServiceParameterParser.getParamDefine(varName, level, cls);
        }
        return MServiceParameterParser.getParamDefine(varName, level, cls);
    }

    private static MServiceDefineMeta.ParamDefine getParamDefineByType(MServiceDefineMeta.ParamDefine param, Type type) {
        param.setTypeStr(MServiceParameterParser.getTypeName(type));
        param.setMulValue(MServiceParameterParser.isMulValueType(type));
        return param;
    }

    private static MServiceDefineMeta.ParamDefine getParamDefineByMap(String varName, int level, Type type, Type[] typeArguments) {
        MServiceDefineMeta.ParamDefine param = MServiceParameterParser.getParamDefine(varName, level, type);
        if (typeArguments.length != 2) {
            return param;
        }
        Type keyType = typeArguments[0];
        MServiceDefineMeta.ParamDefine key = MServiceParameterParser.getPostParam("$key$", level + 1, keyType, 0);
        key.setDescribe(MServiceParameterParser.getDesc("$key$", keyType));
        param.getChildParamDefines().add(key);
        Type valueType = typeArguments[1];
        MServiceDefineMeta.ParamDefine value = MServiceParameterParser.getPostParam("$value$", level + 1, valueType, 0);
        value.setDescribe(MServiceParameterParser.getDesc("$value$", valueType));
        param.getChildParamDefines().add(value);
        param.setMap(true);
        return param;
    }

    private static void parseClassParam(MServiceDefineMeta.ParamDefine parent, Class<?> cls, int level) {
        if (Map.class.isAssignableFrom(cls)) {
            parent.getChildParamDefines().add(MServiceParameterParser.getParamDefine("$key$", level, Object.class));
            parent.getChildParamDefines().add(MServiceParameterParser.getParamDefine("$value$", level, Object.class));
            parent.setMap(true);
        } else {
            if (BASE_TYPES.contains(cls)) {
                return;
            }
            if (level > customLevle) {
                return;
            }
            Set<Field> fields = MServiceParameterParser.getFields(cls);
            for (Field field : fields) {
                MServiceDefineMeta.ParamDefine childParam = MServiceParameterParser.getPostParam(field.getName(), level, field.getGenericType(), 0);
                parent.getChildParamDefines().add(childParam);
            }
        }
    }

    private static Set<Field> getFields(Class<?> cls) {
        Field[] fields = cls.getDeclaredFields();
        LinkedHashSet<Field> set = new LinkedHashSet<Field>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if ("serialVersionUID".equals(field.getName())) continue;
            set.add(field);
        }
        if (cls.getSuperclass() != null && !Object.class.equals(cls.getSuperclass())) {
            Set<Field> superFields = MServiceParameterParser.getFields(cls.getSuperclass());
            for (Field field : superFields) {
                if ("serialVersionUID".equals(field.getName())) continue;
                set.add(field);
            }
        }
        return set;
    }

    private static String getDesc(String varName, Type type) {
        return varName;
    }

    private static boolean isMulValueType(Type type) {
        return MServiceParameterParser.isArray(type) || MServiceParameterParser.isCollection(type);
    }

    private static boolean isMapOrMapArray(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type componentType = parameterizedType.getRawType();
            return MServiceParameterParser.isMapOrMapArray(componentType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            return MServiceParameterParser.isMapOrMapArray(componentType);
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls.isArray() ? MServiceParameterParser.isMapOrMapArray(cls.getComponentType()) : Map.class.isAssignableFrom(cls);
        }
        return false;
    }

    private static boolean isPostBasicArray(Type type) {
        if (MServiceParameterParser.isGetBasicArray(type)) {
            return true;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            if (MServiceParameterParser.isBasicType(componentType)) {
                return true;
            }
            if (MServiceParameterParser.isPostBasicArray(componentType)) {
                return true;
            }
            return MServiceParameterParser.isPostBasicCollection(componentType);
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            return MServiceParameterParser.isPostBasicArray(cls.getComponentType());
        }
        return false;
    }

    private static MServiceDefineMeta.ParamDefine parseParameterizedType(ParameterizedType parameterizedType) {
        Type[] typeArguments;
        MServiceDefineMeta.ParamDefine fieldInfo = new MServiceDefineMeta.ParamDefine(null, MServiceParameterParser.getTypeName(parameterizedType.getRawType()));
        for (Type typeArgument : typeArguments = parameterizedType.getActualTypeArguments()) {
            if (typeArgument instanceof Class) {
                fieldInfo.getChildParamDefines().add(new MServiceDefineMeta.ParamDefine(null, MServiceParameterParser.getTypeName(typeArgument)));
                continue;
            }
            if (!(typeArgument instanceof ParameterizedType)) continue;
            fieldInfo.getChildParamDefines().add(MServiceParameterParser.parseParameterizedType((ParameterizedType)typeArgument));
        }
        return fieldInfo;
    }

    private static String getTypeName(Type type) {
        return MServiceParameterParser.getTypeName(type, false);
    }

    private static String getTypeName(Type type, boolean isFullName) {
        if (isFullName) {
            return MServiceParameterParser.getFullTypeName(type);
        }
        return MServiceParameterParser.getSimpleTypeName(type);
    }

    private static String getSimpleTypeName(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls.getSimpleName();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return MServiceParameterParser.getSimpleTypeName(genericArrayType.getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                Class cls = (Class)rawType;
                Type[] arguments = parameterizedType.getActualTypeArguments();
                if (MServiceParameterParser.isMap(cls)) {
                    return cls.getSimpleName() + "<" + MServiceParameterParser.getSimpleTypeName(arguments[0]) + ", " + MServiceParameterParser.getSimpleTypeName(arguments[1]) + ">";
                }
                if (MServiceParameterParser.isCollection(type)) {
                    return cls.getSimpleName() + "<" + MServiceParameterParser.getSimpleTypeName(arguments[0]) + ">";
                }
            }
            return MServiceParameterParser.getSimpleTypeName(rawType);
        }
        return type.getTypeName();
    }

    private static String getFullTypeName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return MServiceParameterParser.getFullTypeName(genericArrayType.getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                Class cls = (Class)rawType;
                Type[] arguments = parameterizedType.getActualTypeArguments();
                if (MServiceParameterParser.isMap(cls)) {
                    return cls.getName() + "<" + MServiceParameterParser.getFullTypeName(arguments[0]) + ", " + MServiceParameterParser.getFullTypeName(arguments[1]) + ">";
                }
                if (MServiceParameterParser.isCollection(type)) {
                    return cls.getName() + "<" + MServiceParameterParser.getFullTypeName(arguments[0]) + ">";
                }
            }
            return MServiceParameterParser.getFullTypeName(rawType);
        }
        return type.getTypeName();
    }

    private static boolean isCollection(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                return Collection.class.isAssignableFrom((Class)rawType);
            }
        } else if (type instanceof Class) {
            Class cls = (Class)type;
            return Collection.class.isAssignableFrom(cls);
        }
        return false;
    }

    private static boolean isPostBasicCollection(Type type) {
        if (MServiceParameterParser.isGetBasicCollection(type)) {
            return true;
        }
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments != null && typeArguments.length == 1) {
            Type typeArgument = typeArguments[0];
            if (!(typeArgument instanceof Class)) {
                return false;
            }
            Class cls = (Class)typeArgument;
            return MServiceParameterParser.isGetBasicArray(cls);
        }
        return false;
    }

    private static boolean isGetBasicArray(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class cls = (Class)type;
        if (!MServiceParameterParser.isArray(cls)) {
            return false;
        }
        if (cls.getName().startsWith("[[")) {
            return false;
        }
        Class<?> componentType = cls.getComponentType();
        return MServiceParameterParser.isBasicType(componentType);
    }

    private static boolean isArray(Type type) {
        if (type instanceof Class) {
            return ((Class)type).isArray();
        }
        return type instanceof GenericArrayType;
    }

    private static boolean isBasicType(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class cls = (Class)type;
        if (!Void.TYPE.equals(cls) && !Void.class.equals((Object)cls)) {
            if (ClassUtils.isPrimitiveOrWrapper((Class)cls)) {
                return true;
            }
            if (String.class.equals((Object)cls)) {
                return true;
            }
            return BigDecimal.class.equals((Object)cls) || BigInteger.class.equals((Object)cls) || Date.class.isAssignableFrom(cls);
        }
        return false;
    }

    public static boolean isGetBasicCollection(Type type) {
        if (!MServiceParameterParser.isCollection(type)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments != null && typeArguments.length == 1) {
            Type typeArgument = typeArguments[0];
            if (!(typeArgument instanceof Class)) {
                return false;
            }
            Class cls = (Class)typeArgument;
            return MServiceParameterParser.isBasicType(cls);
        }
        return false;
    }

    private static boolean isMap(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            return Map.class.isAssignableFrom(cls);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type componentType = parameterizedType.getRawType();
            return MServiceParameterParser.isMap(componentType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            return MServiceParameterParser.isMap(componentType);
        }
        return false;
    }
}

