/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import kd.bos.config.client.ConfigService;
import kd.bos.config.client.configurl.ConfigUrlService;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;
import org.apache.log4j.Logger;

public abstract class AbstractConfigService
implements ConfigService {
    private static final Logger logger = Logger.getLogger(AbstractConfigService.class);
    private String configUrl;

    public String getConfigUrl() {
        if (this.configUrl != null) {
            return this.configUrl;
        }
        this.configUrl = this.getConfigUrlBySPI();
        if (this.configUrl == null) {
            this.configUrl = this.getConfigUrlByConfigFile();
        }
        if (this.configUrl == null) {
            this.configUrl = SystemProperties.getWithEnv((String)"configUrl");
            if (this.configUrl == null) {
                throw new KDException(BosErrorCode.zookeepConfiguration, new Object[]{"Config Url not assigned,configUrl"});
            }
        }
        return this.configUrl;
    }

    private String getConfigUrlBySPI() {
        String configUrl = null;
        ServiceLoader<ConfigUrlService> serviceLoader = ServiceLoader.load(ConfigUrlService.class);
        Iterator<ConfigUrlService> itr = serviceLoader.iterator();
        while (itr.hasNext()) {
            try {
                ConfigUrlService configUrlServices = itr.next();
                if (!(configUrlServices instanceof ConfigUrlService)) continue;
                configUrl = configUrlServices.getConfigUrl();
                logger.info((Object)("ConfigurationFactoryNew getConfigUrlBySPI successfully loaded class: " + configUrlServices.getClass().getName()));
                if (configUrl == null) continue;
                return configUrl;
            }
            catch (Error | Exception e) {
                logger.warn((Object)("Load configUrlServices failed,errorMessage:" + e.getMessage()), e);
            }
        }
        return configUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getConfigUrlByConfigFile() {
        Properties properties = new Properties();
        try (InputStream inputStream = this.getClass().getResourceAsStream("/app.properties");){
            if (inputStream == null) return null;
            properties.load(inputStream);
            String configUrl = properties.getProperty("configUrl");
            if (!StringUtils.isNotEmpty((String)configUrl)) return null;
            System.setProperty("configUrl", configUrl);
            String string = configUrl;
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }
}

