/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.util.ConfigurationChangeListener;

public abstract class Configuration {
    private List<ConfigurationChangeListener> listeners = new CopyOnWriteArrayList<ConfigurationChangeListener>();

    public abstract Iterator<String> keys();

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public abstract String getProperty(String var1, String var2);

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            String key = iter.next();
            map.put(key, this.getProperty(key));
        }
        return map;
    }

    public void addConfigurationChangeListener(ConfigurationChangeListener l) {
        this.listeners.add(l);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public void fireConfigurationChanged(Object key, Object value) {
        for (ConfigurationChangeListener l : this.listeners) {
            l.onChange(key, value);
        }
    }
}

