/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.configcenter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.config.client.configcenter.KConfigCenterSource;
import kd.bos.config.client.configcenter.KConfigCenterSourceSave;
import kd.bos.extension.ExtensionFactory;

public class KConfigCenterFactory {
    private static ExtensionFactory<KConfigCenterSource> kConfigCenterSourceExtensionFactory = ExtensionFactory.getExtensionFacotry(KConfigCenterSource.class);
    private static ExtensionFactory<KConfigCenterSourceSave> kConfigCenterSaveExtensionFactory = ExtensionFactory.getExtensionFacotry(KConfigCenterSourceSave.class);
    private static Map<String, KConfigCenterSource> sourceMap = new ConcurrentHashMap<String, KConfigCenterSource>(1);
    private static Map<String, KConfigCenterSourceSave> sourceForSaveMap = new ConcurrentHashMap<String, KConfigCenterSourceSave>(1);

    public static KConfigCenterSource getSourceForRegister(String commonType, String url, String clusterName, String configAppName, String configType) {
        String key = url + clusterName + configAppName + configType;
        return sourceMap.computeIfAbsent(key, k -> {
            KConfigCenterSource source = (KConfigCenterSource)kConfigCenterSourceExtensionFactory.getExtension(commonType, false);
            source.init(url, clusterName, configAppName, configType);
            return source;
        });
    }

    public static KConfigCenterSourceSave getSourceForSave(String commonType, String url, String clusterName) {
        String key = url + clusterName;
        return sourceForSaveMap.computeIfAbsent(key, k -> {
            KConfigCenterSourceSave source = (KConfigCenterSourceSave)kConfigCenterSaveExtensionFactory.getExtension(commonType, false);
            source.init(url, clusterName);
            return source;
        });
    }
}

