/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.configcenter.zookeeper;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.config.client.configcenter.KConfigCenterConfigurationSource;
import kd.bos.config.client.configcenter.KConfigCenterSource;
import kd.bos.config.client.util.ConfigUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKConfigCenterSource
implements KConfigCenterSource {
    private static final Logger logger = LoggerFactory.getLogger(ZKConfigCenterSource.class);
    private final Charset charset = Charset.forName("UTF-8");
    private CuratorFramework client = null;
    private String configRootPath = null;
    private PathChildrenCache pathChildrenCache = null;
    private AtomicBoolean hasStarted = new AtomicBoolean(false);

    @Override
    public void init(String url, String clusterName, String configAppName, String configType) {
        this.client = ZKFactory.getZKClient((String)url);
        this.configRootPath = ConfigUtils.getConfigPath(clusterName, configAppName, configType);
        this.pathChildrenCache = new PathChildrenCache(this.client, this.configRootPath, true);
    }

    @Override
    public Map<String, Object> getData() {
        try {
            List children = this.pathChildrenCache.getCurrentData();
            HashMap<String, Object> all = new HashMap<String, Object>(children.size());
            for (ChildData child : children) {
                String path = child.getPath();
                String key = this.removeRootPath(path);
                byte[] value = child.getData();
                all.put(key, new String(value, this.charset));
            }
            logger.debug("getCurrentData() retrieved [{}] config elements.", (Object)children.size());
            return all;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.configZookeepConfig, new Object[]{"getCurrentData failed"});
        }
    }

    @Override
    public void registListener(final KConfigCenterConfigurationSource.CallBackEvent callBackEvent) {
        this.pathChildrenCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

            public void childEvent(CuratorFramework aClient, PathChildrenCacheEvent event) {
                PathChildrenCacheEvent.Type eventType = event.getType();
                ChildData data = event.getData();
                String path = null;
                if (data != null) {
                    path = data.getPath();
                    String key = ZKConfigCenterSource.this.removeRootPath(path);
                    byte[] value = data.getData();
                    String stringValue = new String(value, ZKConfigCenterSource.this.charset);
                    logger.debug("received update to pathName [{}], eventType [{}]", (Object)path, (Object)eventType);
                    logger.debug("key [{}], and value [{}]", (Object)key, (Object)stringValue);
                    if (eventType == PathChildrenCacheEvent.Type.CHILD_ADDED) {
                        callBackEvent.fireAddedEvent(key, stringValue);
                    } else if (eventType == PathChildrenCacheEvent.Type.CHILD_UPDATED) {
                        callBackEvent.fireUpdatedEvent(key, stringValue);
                    } else if (eventType == PathChildrenCacheEvent.Type.CHILD_REMOVED) {
                        callBackEvent.fireRemovedEvent(key, stringValue);
                    }
                }
            }
        });
        if (this.hasStarted.compareAndSet(false, true)) {
            try {
                this.pathChildrenCache.start(true);
            }
            catch (Exception e) {
                this.hasStarted.set(false);
                throw new KDException((Throwable)e, BosErrorCode.configZookeepConfig, new Object[]{"start zookeeper failed"});
            }
        }
    }

    @Override
    public void close() {
        try {
            Closeables.close((Closeable)this.pathChildrenCache, (boolean)true);
        }
        catch (IOException exc) {
            logger.error("IOException should not have been thrown.", (Throwable)exc);
        }
    }

    private String removeRootPath(String nodePath) {
        return nodePath.replace(this.configRootPath + "/", "");
    }
}

