/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.nacos;

import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import kd.bos.config.client.ConfigService;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.nacos.NacosConfigService;
import kd.bos.nacos.NacosFactory;
import kd.bos.util.SafeLogUtils;
import kd.bos.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class NacosConfigServiceSpring
implements ConfigService {
    private static final String COMPLEX_DATAIDS = "complex.dataids";
    private static final String COMPLEX_PROPERTIE_SSUFFIX = ".properties";
    private static final String EMPTY_VALUE_NIL = "{nil}";
    private Map<String, String> innerConfigMap = new HashMap<String, String>();
    private Map<String, Listener> complexDataId_listener_map = new HashMap<String, Listener>();
    private String namespace = System.getProperty("spring.cloud.nacos.config.namespace");
    private String group = System.getProperty("spring.cloud.nacos.config.group", "DEFAULT_GROUP");
    private String dataId;
    private String serverAddr = System.getProperty("spring.cloud.nacos.config.server-addr");
    private String fileextendsion = System.getProperty("spring.cloud.nacos.config.file-extension");
    private String username = System.getProperty("spring.cloud.nacos.config.username");
    private String password = System.getProperty("spring.cloud.nacos.config.password");
    private NacosConfigService configService;

    public NacosConfigServiceSpring() {
        StringBuilder nacosConfigUrl = new StringBuilder();
        int pindex = this.serverAddr.indexOf("//");
        if (pindex > 0) {
            nacosConfigUrl.append(this.serverAddr.substring(pindex + 2));
        } else {
            nacosConfigUrl.append(this.serverAddr);
        }
        nacosConfigUrl.append("/");
        if (this.namespace != null) {
            nacosConfigUrl.append(this.namespace);
        } else {
            nacosConfigUrl.append("");
        }
        if (this.username != null) {
            nacosConfigUrl.append("?username=").append(this.username).append("&password=").append(this.password);
        }
        this.configService = NacosFactory.getNacosConfigClient((String)nacosConfigUrl.toString());
        this.namespace = NacosFactory.getNacosNamespace((String)nacosConfigUrl.toString());
    }

    @Override
    public String[] needProperties() {
        return new String[]{"spring.cloud.nacos.config.server-addr"};
    }

    @Override
    public String[] getConfigAppNames() {
        String springapplication = System.getProperty("spring.application.name");
        String configNames = System.getProperty("configAppName");
        configNames = configNames != null ? springapplication + "," + configNames : springapplication;
        return configNames.split(",|;");
    }

    @Override
    public String getVarConfigName() {
        return null;
    }

    @Override
    public Iterator<String> keys() {
        String config = null;
        try {
            config = this.configService.getConfigAndSignListener(this.dataId, this.group, new Listener(){

                public void receiveConfigInfo(String propConfig) {
                    try {
                        NacosConfigServiceSpring.this.loadPropYaml(propConfig);
                    }
                    catch (NacosException nacosException) {
                        // empty catch block
                    }
                }

                public Executor getExecutor() {
                    return null;
                }
            });
            this.loadPropYaml(config);
        }
        catch (NacosException e) {
            throw new KDException(BosErrorCode.nacosConfiguration, new Object[]{"getConfigError,namespace=" + this.getNacosNamespace() + ",group=" + this.getGroup() + ",dataId=" + this.getDataId()});
        }
        Set<String> innerConfigKeySet = this.innerConfigMap.keySet();
        ArrayList<String> tempKeyList = new ArrayList<String>(innerConfigKeySet.size());
        for (String tempConfigKey : innerConfigKeySet) {
            if (!tempConfigKey.endsWith(COMPLEX_PROPERTIE_SSUFFIX)) continue;
            tempKeyList.add(tempConfigKey);
        }
        for (String tempConfigKey : innerConfigKeySet) {
            if (tempKeyList.contains(tempConfigKey)) continue;
            tempKeyList.add(tempConfigKey);
        }
        return tempKeyList.iterator();
    }

    private void loadPropYaml(String propConfig) throws NacosException {
        if (StringUtils.isEmpty((String)propConfig)) {
            this.removeComplexConfigAndListener(null);
            return;
        }
        Map configMap = (Map)new Yaml().load(propConfig);
        HashMap<String, String> res = new HashMap<String, String>(2);
        this.resolveYamlMap(null, configMap, res);
        this.loadSimpleConfig(res);
    }

    private void resolveYamlMap(String parent, Map<String, Object> configMap, Map<String, String> res) {
        configMap.forEach((k, v) -> {
            if (v == null) {
                return;
            }
            if (v instanceof String) {
                String storeKey = parent == null ? k : parent + "." + k;
                if (storeKey.startsWith("ts.")) {
                    storeKey = storeKey.substring(3);
                }
                SafeLogUtils.info(this.getClass(), (String)(storeKey + ":" + v));
                res.put(storeKey, (String)v);
            } else if (v instanceof Map) {
                this.resolveYamlMap((parent == null ? "" : parent + ".") + k, (Map)v, res);
            }
        });
    }

    private void loadSimpleConfig(Map<String, String> configMap) {
        HashMap<String, String> allConfigMap = new HashMap<String, String>(this.innerConfigMap);
        HashMap<String, String> complexConfigMap = new HashMap<String, String>();
        if (this.complexDataId_listener_map.size() > 0) {
            Set<String> complexDataIdSet = this.complexDataId_listener_map.keySet();
            for (String tempComplexDataId : complexDataIdSet) {
                String tempComplexValue = (String)allConfigMap.remove(tempComplexDataId);
                complexConfigMap.put(tempComplexDataId, tempComplexValue);
            }
        }
        HashMap<String, String> simpleConfigMap = allConfigMap;
        Iterator simpleDataIdIt = simpleConfigMap.keySet().iterator();
        while (simpleDataIdIt.hasNext()) {
            String tempSimpleDataId = ((String)simpleDataIdIt.next()).trim();
            if (configMap.containsKey(tempSimpleDataId)) continue;
            this.fireConfigurationChanged(tempSimpleDataId, null);
            simpleDataIdIt.remove();
        }
        for (Map.Entry<String, String> entry : configMap.entrySet()) {
            String key = entry.getKey().trim();
            String value = entry.getValue();
            if (value == null) continue;
            String valueString = value.trim();
            if (valueString.equals(EMPTY_VALUE_NIL)) {
                valueString = "";
            }
            simpleConfigMap.put(key, valueString);
            this.fireConfigurationChanged(key, valueString);
        }
        allConfigMap.putAll(complexConfigMap);
        this.innerConfigMap = allConfigMap;
        this.innerConfigMap.forEach((k, v) -> System.setProperty(k, v));
    }

    private void loadComplexConfig(Map<String, Object> configMap) throws NacosException {
        if (configMap.containsKey(COMPLEX_DATAIDS)) {
            List complexDataIdList = (List)configMap.get(COMPLEX_DATAIDS);
            this.removeComplexConfigAndListener(complexDataIdList);
            this.loadComplexDataIds(complexDataIdList);
        } else {
            this.removeComplexConfigAndListener(null);
        }
    }

    private void removeComplexConfigAndListener(List<String> complexDataIdList) throws NacosException {
        if (complexDataIdList == null || complexDataIdList.size() == 0) {
            if (this.complexDataId_listener_map.size() > 0) {
                for (Map.Entry<String, Listener> tempEntry : this.complexDataId_listener_map.entrySet()) {
                    String string = tempEntry.getKey();
                    Listener listener = tempEntry.getValue();
                    this.configService.removeListener(string, this.group, listener);
                    this.innerConfigMap.remove(string);
                    this.fireConfigurationChanged(string, null);
                }
                this.complexDataId_listener_map.clear();
            }
            return;
        }
        if (this.complexDataId_listener_map.size() > 0) {
            HashMap<String, Listener> complexDataIdListenerMap = new HashMap<String, Listener>(complexDataIdList.size());
            for (final String string : complexDataIdList) {
                Listener complexDataIdListener = this.complexDataId_listener_map.get(string);
                if (complexDataIdListener == null) {
                    complexDataIdListener = new Listener(){

                        public Executor getExecutor() {
                            return null;
                        }

                        public void receiveConfigInfo(String complexConfig) {
                            if (string.endsWith(NacosConfigServiceSpring.COMPLEX_PROPERTIE_SSUFFIX)) {
                                complexConfig = complexConfig.replace(NacosConfigServiceSpring.EMPTY_VALUE_NIL, "");
                            }
                            NacosConfigServiceSpring.this.innerConfigMap.put(string, complexConfig);
                            NacosConfigServiceSpring.this.fireConfigurationChanged(string, complexConfig);
                        }
                    };
                    this.configService.addListener(string, this.group, complexDataIdListener);
                }
                complexDataIdListenerMap.put(string, complexDataIdListener);
            }
            for (Map.Entry entry : this.complexDataId_listener_map.entrySet()) {
                String tempDataId = (String)entry.getKey();
                Listener listener = (Listener)entry.getValue();
                if (complexDataIdList.contains(tempDataId)) continue;
                this.configService.removeListener(tempDataId, this.group, listener);
                this.innerConfigMap.remove(tempDataId);
                this.fireConfigurationChanged(tempDataId, null);
            }
            this.complexDataId_listener_map = complexDataIdListenerMap;
        } else {
            for (final String tempComplexDataId : complexDataIdList) {
                Listener listener = new Listener(){

                    public Executor getExecutor() {
                        return null;
                    }

                    public void receiveConfigInfo(String complexConfig) {
                        if (tempComplexDataId.endsWith(NacosConfigServiceSpring.COMPLEX_PROPERTIE_SSUFFIX)) {
                            complexConfig = complexConfig.replace(NacosConfigServiceSpring.EMPTY_VALUE_NIL, "");
                        }
                        NacosConfigServiceSpring.this.innerConfigMap.put(tempComplexDataId, complexConfig);
                        NacosConfigServiceSpring.this.fireConfigurationChanged(tempComplexDataId, complexConfig);
                    }
                };
                this.configService.addListener(tempComplexDataId, this.group, listener);
                this.complexDataId_listener_map.put(tempComplexDataId, listener);
            }
        }
    }

    private void loadComplexDataIds(List<String> complexDataIdList) throws NacosException {
        if (complexDataIdList == null || complexDataIdList.size() == 0) {
            return;
        }
        for (String tempComplexDataId : complexDataIdList) {
            tempComplexDataId = tempComplexDataId.trim();
            String tempComplexConfig = this.configService.getConfig(tempComplexDataId, this.group);
            if (tempComplexDataId.endsWith(COMPLEX_PROPERTIE_SSUFFIX)) {
                tempComplexConfig = tempComplexConfig.replace(EMPTY_VALUE_NIL, "");
            }
            this.innerConfigMap.put(tempComplexDataId, tempComplexConfig);
            this.fireConfigurationChanged(tempComplexDataId, tempComplexConfig);
        }
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.innerConfigMap.get(key);
        return value == null ? defaultValue : value;
    }

    private String getNacosNamespace() {
        return this.namespace;
    }

    public String getGroup() {
        return this.group;
    }

    public String getDataId() {
        return this.dataId;
    }

    @Override
    public void setConfigAppName(String configAppName) {
        this.dataId = configAppName;
    }

    @Override
    public String getConfigAppName() {
        return this.dataId;
    }

    @Override
    public String spiName() {
        return "nacosspringcloud";
    }
}

