/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.util;

import com.google.common.base.Charsets;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import kd.bos.config.client.util.StringUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class HttpUtils {
    private static Logger logger = Logger.getLogger(HttpUtils.class);
    private static final String CHARSET_UTF8 = "UTF-8";

    public static String request(String url) {
        return HttpUtils.request(url, "GET");
    }

    public static String request(String url, boolean replaceSpace) {
        return HttpUtils.request(url, "GET", null, replaceSpace);
    }

    public static String request(String url, String requestType) {
        return HttpUtils.request(url, requestType, null);
    }

    public static String request(String url, String requestType, Map<String, String> header) {
        return HttpUtils.request(url, requestType, header, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(String url, String requestType, Map<String, String> header, boolean replaceSpace) {
        if (StringUtils.isEmpty(url)) {
            throw new IllegalArgumentException("request url can't be null");
        }
        StringBuilder sb = new StringBuilder();
        InputStream raw = null;
        try {
            URL httpUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
            connection.setRequestMethod(requestType.toUpperCase());
            if (header != null) {
                for (Map.Entry<String, String> item : header.entrySet()) {
                    connection.setRequestProperty(item.getKey(), item.getValue());
                }
            }
            raw = connection.getInputStream();
            BufferedInputStream reader = new BufferedInputStream(raw);
            byte[] buffer = new byte[1024];
            String encoding = connection.getContentEncoding();
            if (StringUtils.isEmpty(encoding)) {
                encoding = CHARSET_UTF8;
            } else {
                boolean support = Charset.isSupported(encoding);
                if (!support) {
                    encoding = CHARSET_UTF8;
                }
            }
            Charset charset = Charset.forName(encoding);
            int size = 0;
            while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
                if (size <= 0) continue;
                sb.append(new String(buffer, 0, size, charset));
            }
            String result = sb.toString();
            String string = replaceSpace && result.indexOf("\n") != -1 ? result.replaceAll("\\s*|\t|\r|\n", StringUtils.getEmpty()) : result;
            IOUtils.closeQuietly((InputStream)raw);
            return string;
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(raw);
        }
        return StringUtils.getEmpty();
    }

    public static String post(String url) {
        return HttpUtils.request(url, "POST");
    }

    public static String post(String url, Map<String, String> header) {
        return HttpUtils.request(url, "POST", header);
    }

    public static String post(String url, Map<String, String> header, String argument) {
        return HttpUtils.post(url, header, argument, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> header, String argument, boolean replaceSpace) {
        if (StringUtils.isEmpty(url)) {
            throw new IllegalArgumentException("post url can't be null");
        }
        StringBuilder sb = new StringBuilder();
        InputStream raw = null;
        try {
            URL httpUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
            connection.setRequestMethod("POST");
            if (header != null) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (StringUtils.isNotEmpty(argument)) {
                connection.setDoOutput(true);
                Throwable throwable = null;
                try (OutputStream write = connection.getOutputStream();){
                    write.write(argument.getBytes(Charsets.UTF_8));
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            raw = connection.getInputStream();
            BufferedInputStream reader = new BufferedInputStream(raw);
            byte[] byArray = new byte[1024];
            String encoding = connection.getContentEncoding();
            if (StringUtils.isEmpty(encoding)) {
                encoding = CHARSET_UTF8;
            } else {
                boolean support = Charset.isSupported(encoding);
                if (!support) {
                    encoding = CHARSET_UTF8;
                }
            }
            Charset charset = Charset.forName(encoding);
            int size = 0;
            while ((size = reader.read(byArray, 0, byArray.length)) != -1) {
                if (size <= 0) continue;
                sb.append(new String(byArray, 0, size, charset));
            }
            String result = sb.toString();
            String string = replaceSpace && result.indexOf("\n") != -1 ? result.replaceAll("\\s*|\t|\r|\n", StringUtils.getEmpty()) : result;
            IOUtils.closeQuietly((InputStream)raw);
            return string;
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(raw);
        }
        return StringUtils.getEmpty();
    }

    public static String getJsonRequest(HttpServletRequest request) throws IOException {
        String charset = request.getCharacterEncoding();
        if (StringUtils.isEmpty(charset)) {
            charset = CHARSET_UTF8;
        }
        ServletInputStream raw = request.getInputStream();
        BufferedInputStream reader = new BufferedInputStream((InputStream)raw);
        StringBuilder sb = new StringBuilder();
        byte[] buffer = new byte[1024];
        int size = 0;
        while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
            if (size <= 0) continue;
            sb.append(new String(buffer, 0, size, charset));
        }
        String result = sb.toString();
        return result;
    }
}

