/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import kd.sdk.annotation.SdkInternal;
import org.apache.log4j.Logger;

@SdkInternal
public class JSONUtils {
    private static Logger logger = Logger.getLogger(JSONUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toString(Object source) throws IOException {
        return JSONUtils.toString(source, false);
    }

    @SdkInternal
    public static String toString(Object source, boolean indent) throws IOException {
        try {
            String result;
            if (indent) {
                mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            }
            String string = result = mapper.writeValueAsString(source);
            return string;
        }
        catch (IOException e) {
            logger.error((Object)"cast source object toString error", (Throwable)e);
            throw e;
        }
        finally {
            if (indent) {
                mapper.configure(SerializationFeature.INDENT_OUTPUT, false);
            }
        }
    }

    @SdkInternal
    public static <T> T cast(String source, Class<T> type) throws IOException {
        return JSONUtils.cast(source, type, false);
    }

    @SdkInternal
    public static <T> T cast(String source, Class<T> type, boolean ignoreUnkownField) throws IOException {
        try {
            Object result;
            if (ignoreUnkownField) {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
            Object object = result = mapper.readValue(source, type);
            return (T)object;
        }
        catch (IOException e) {
            logger.error((Object)"cast object from source error", (Throwable)e);
            throw e;
        }
        finally {
            if (ignoreUnkownField) {
                mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
        }
    }

    @SdkInternal
    public static <T> T cast(String source, Class<?> collectionType, Class<?> ... elementType) throws IOException {
        return JSONUtils.cast(source, true, collectionType, elementType);
    }

    @SdkInternal
    public static <T> T cast(String source, boolean ignoreUnkownField, Class<?> collectionType, Class<?> ... elementType) throws IOException {
        try {
            Object result;
            if (ignoreUnkownField) {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
            JavaType type = JSONUtils.getCollectionType(collectionType, elementType);
            Object object = result = mapper.readValue(source, type);
            return (T)object;
        }
        catch (IOException e) {
            logger.error((Object)"cast object from source error", (Throwable)e);
            throw e;
        }
        finally {
            if (ignoreUnkownField) {
                mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
        }
    }

    @SdkInternal
    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    @SdkInternal
    public static String getEmpty() {
        return "{}";
    }
}

