/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.var;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.config.client.Configuration;
import kd.bos.config.client.var.VarChangeListener;
import kd.bos.config.client.var.VarItem;
import kd.bos.instance.Instance;
import kd.bos.util.ConfigurationChangeListener;

public class VarMap
extends HashMap<String, VarItem> {
    private static final Pattern pattern = Pattern.compile("(?<=\\{\\{)(.+?)(?=\\}\\})");
    private HashMap<String, List<String>> refKey2Var = new HashMap();
    private Configuration conf;
    private VarChangeListener listener;

    public VarMap(Configuration conf, VarChangeListener listener) {
        this.conf = conf;
        this.listener = listener;
        this.initSystemVar();
        Iterator<String> iter = conf.keys();
        while (iter.hasNext()) {
            String key = iter.next();
            String value = conf.getProperty(key);
            this.put(key, new VarItem(key, value));
        }
        this.initListener();
    }

    @Override
    public void clear() {
        this.conf.clearListeners();
    }

    private void initSystemVar() {
        this.put("clusterName", new VarItem("clusterName", Instance.getClusterName()));
        this.put("appName", new VarItem("appName", Instance.getAppName()));
    }

    private void initListener() {
        this.conf.addConfigurationChangeListener(new ConfigurationChangeListener(){

            public void onChange(Object key, Object value) {
                VarMap.this.onVarChange((String)key, (String)value);
            }
        });
    }

    private void onVarChange(String varName, String value) {
        if (value == null) {
            this.remove(varName);
        } else {
            VarItem varItem = (VarItem)this.get(varName);
            if (varItem == null) {
                varItem = new VarItem(varName, value);
                this.put(varName, varItem);
            } else {
                varItem.setVarValue(value);
            }
            for (String refKey : varItem.getRefs()) {
                this.listener.onChange(refKey, varName, value);
            }
        }
    }

    public String transform(String key, String value) {
        List<String> varNames = this.refKey2Var.get(key);
        if (varNames == null) {
            return value;
        }
        for (String varName : varNames) {
            VarItem varItem = (VarItem)this.get(varName);
            if (varItem == null) continue;
            value = varItem.transform(value);
        }
        return value;
    }

    public boolean containsRefKey(String key) {
        return this.refKey2Var.containsKey(key);
    }

    public boolean addRefKeyIfPossible(String key, String value) {
        List<String> varNames = VarMap.extractVars(value);
        if (varNames != null) {
            this.addRef(key, varNames);
            return true;
        }
        return false;
    }

    private static List<String> extractVars(String value) {
        Matcher matcher = pattern.matcher(value);
        ArrayList<String> list = new ArrayList<String>(2);
        while (matcher.find()) {
            String group = matcher.group();
            if (list.contains(group)) continue;
            list.add(matcher.group());
        }
        return list.size() > 0 ? list : null;
    }

    public void addRef(String key, List<String> varNames) {
        this.refKey2Var.put(key, varNames);
        for (String varName : varNames) {
            VarItem varItem = (VarItem)this.get(varName);
            if (varItem == null) continue;
            varItem.addRef(key);
        }
    }

    public void removeRef(String key) {
        List<String> varNames = this.refKey2Var.remove(key);
        for (String varName : varNames) {
            VarItem varItem = (VarItem)this.get(varName);
            if (varItem == null) continue;
            varItem.removeRef(key);
        }
    }

    public static void main(String[] args) {
        String url = "http://{{ip}}:{{port}}/";
        List<String> vars = VarMap.extractVars(url);
        for (String varName : vars) {
            String pattern = "\\{\\{" + varName + "\\}\\}";
            url = url.replaceAll(pattern, "value");
        }
    }
}

