/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.zk;

import com.netflix.config.DynamicWatchedConfiguration;
import com.netflix.config.WatchedConfigurationSource;
import java.util.Iterator;
import kd.bos.config.client.Configuration;
import kd.bos.config.client.adapter.ApacheConfigurationListenerAdapter;
import kd.bos.config.client.zk.ZooKeeperConfigurationSource;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.zk.ZKFactory;
import org.apache.commons.configuration.event.ConfigurationListener;

public class ZookeeperConfiguration
extends Configuration {
    private ZooKeeperConfigurationSource zkConfigSource;
    private final DynamicWatchedConfiguration zkConfiguration;

    public ZookeeperConfiguration(String url, String rootPath) {
        this.zkConfigSource = new ZooKeeperConfigurationSource(ZKFactory.getZKClient((String)url), rootPath);
        try {
            this.zkConfigSource.start();
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.zookeepConfiguration, new Object[0]);
        }
        try {
            this.zkConfiguration = new DynamicWatchedConfiguration((WatchedConfigurationSource)this.zkConfigSource);
            this.zkConfiguration.setDelimiterParsingDisabled(true);
            this.zkConfiguration.addConfigurationListener((ConfigurationListener)new ApacheConfigurationListenerAdapter(this));
        }
        catch (Exception t) {
            throw new KDException((Throwable)t, BosErrorCode.zookeepConfiguration, new Object[0]);
        }
    }

    public DynamicWatchedConfiguration getZKConfiguration() {
        return this.zkConfiguration;
    }

    @Override
    public Iterator<String> keys() {
        return this.zkConfiguration.getKeys();
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.zkConfiguration.getString(key);
        return value == null ? defaultValue : value;
    }
}

