/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.server.ContainerManager;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.admin.AdminServerFactory;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class LightweightZookeeperServer {
    private ServerCnxnFactory cnxnFactory;
    private ServerCnxnFactory secureCnxnFactory;
    private ContainerManager containerManager;
    private AdminServer adminServer;
    private ServerConfig serverConfig = new ServerConfig();

    public void start(String[] args) throws IOException, AdminServer.AdminServerException {
        this.serverConfig.parse(args);
        this.initConfig(this.serverConfig);
    }

    private boolean initConfig(ServerConfig config) throws IOException, AdminServer.AdminServerException {
        try {
            FileTxnSnapLog txnLog = new FileTxnSnapLog(config.dataLogDir, config.dataDir);
            ZooKeeperServer zkServer = new ZooKeeperServer(txnLog, config.tickTime, config.minSessionTimeout, config.maxSessionTimeout, config.getClientPortListenBacklog(), null, config.initialConfig, QuorumPeerConfig.isReconfigEnabled());
            txnLog.setServerStats(zkServer.serverStats());
            this.adminServer = AdminServerFactory.createAdminServer();
            this.adminServer.setZooKeeperServer(zkServer);
            this.adminServer.start();
            boolean needStartZKServer = true;
            if (config.getClientPortAddress() != null) {
                this.cnxnFactory = ServerCnxnFactory.createFactory();
                this.cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns(), config.getClientPortListenBacklog(), false);
                this.cnxnFactory.startup(zkServer);
                needStartZKServer = false;
            }
            if (config.getSecureClientPortAddress() != null) {
                this.secureCnxnFactory = ServerCnxnFactory.createFactory();
                this.secureCnxnFactory.configure(config.getSecureClientPortAddress(), config.getMaxClientCnxns(), config.getClientPortListenBacklog(), true);
                this.secureCnxnFactory.startup(zkServer, needStartZKServer);
            }
            this.containerManager = new ContainerManager(zkServer.getZKDatabase(), zkServer.firstProcessor, Integer.getInteger("znode.container.checkIntervalMs", (int)TimeUnit.MINUTES.toMillis(1L)).intValue(), Integer.getInteger("znode.container.maxPerMinute", 10000).intValue());
            this.containerManager.start();
            FileTxnSnapLog finalTxnLog = txnLog;
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                this.shutdown();
                try {
                    if (this.cnxnFactory != null) {
                        this.cnxnFactory.join();
                    }
                    if (this.secureCnxnFactory != null) {
                        this.secureCnxnFactory.join();
                    }
                    if (zkServer.canShutdown()) {
                        zkServer.shutdown(true);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    if (finalTxnLog != null) {
                        try {
                            finalTxnLog.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }));
            return zkServer.isRunning();
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected void shutdown() {
        if (this.containerManager != null) {
            this.containerManager.stop();
        }
        if (this.cnxnFactory != null) {
            this.cnxnFactory.shutdown();
        }
        if (this.secureCnxnFactory != null) {
            this.secureCnxnFactory.shutdown();
        }
        try {
            if (this.adminServer != null) {
                this.adminServer.shutdown();
            }
        }
        catch (AdminServer.AdminServerException adminServerException) {
            // empty catch block
        }
    }
}

