/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.LockSupport;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.framework.lifecycle.Service;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.pigeon.core.constant.PigeonConstant;
import kd.bos.pigeon.core.support.PigeonRequestContextUtil;
import kd.bos.pigeon.core.support.instance.ServiceEventListener;
import kd.bos.pigeon.core.support.instance.ServiceEventManager;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.core.support.instance.ServiceInfoManager;
import kd.bos.pigeon.dispatch.support.DispatchExecutionEnvironment;
import kd.bos.pigeon.dispatch.support.DispatchExecutionEnvironmentManager;
import kd.bos.pigeon.dispatch.support.DispatchExecutionEnvironmentService;
import kd.bos.pigeon.elect.ElectorDTO;
import kd.bos.pigeon.elect.ElectorManager;
import kd.bos.pigeon.elect.ElectorNode;
import kd.bos.pigeon.elect.ElectorRole;
import kd.bos.pigeon.elect.ElectorService;
import kd.bos.service.invoke.endpoint.EndPointInvokeServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.WebPortUtil;

public class PigeonService
implements Service {
    private static final Log LOGGER = LogFactory.getLog(PigeonService.class);
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"PigeonServiceElectNotify", (int)1);
    private ElectorListener electorListener = new ElectorListener();
    private PigeonElectorServiceEventListener electorServiceEventListener = new PigeonElectorServiceEventListener();
    private Elector elector;
    private boolean isStarted;
    private static boolean isCandidate = true;

    public String getName() {
        return "PigeonService";
    }

    public void start() {
        LOGGER.info("pigeonService start...");
        this.isStarted = true;
        String mqType = QueueManager.getMQType((String)"demo");
        if (mqType != null && !mqType.equals("pigeon")) {
            return;
        }
        boolean isAppSplit = Instance.isAppSplit();
        if (isAppSplit) {
            if (Instance.getAppIds() == null) {
                isCandidate = false;
                return;
            }
            if (Instance.getAppIds().length > 0 && !Arrays.asList(Instance.getAppIds()).contains("pigeon")) {
                isCandidate = false;
                return;
            }
        } else if (Instance.isStandaloneWebNode()) {
            isCandidate = false;
            return;
        }
        this.elector = ElectFactory.getElector((String)("pigeon_elector_" + System.getProperty("mq.debug.queue.tag", "") + System.getProperty("mq.pigeon.local.cluster.tag", "")));
        this.initDispatchScheduleEnv();
        final Timer timer = new Timer("PigeonServiceInit");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PigeonService.this.waitForServiceReady();
                ServiceInfoManager.initServiceInfoObserver();
                PigeonService.this.initElector();
                ServiceEventManager.registerListener((String)"pigeon_elector", (ServiceEventListener)PigeonService.this.electorServiceEventListener);
                timer.cancel();
            }
        }, PigeonConstant.ELECTOR_WAIT_TIME_VALUE);
    }

    private void waitForServiceReady() {
        String ip = NetAddressUtils.getLocalIpAddress();
        if (NetAddressUtils.isPreferIPv6() && !ip.startsWith("[")) {
            ip = "[" + ip + "]";
        }
        String port = "dubbo".equals(MserviceAssemblyConfig.getMserviceRpcType()) ? System.getProperty("dubbo.protocol.port", "20880") : ("feign".equals(MserviceAssemblyConfig.getMserviceRpcType()) ? WebPortUtil.getWebPort((String)WebPortUtil.getServerPort()) : ("assembly".equals(MserviceAssemblyConfig.getMserviceRpcType()) ? System.getProperty("monitor.custom.rpc.port", System.getProperty("dubbo.protocol.port", "20880")) : System.getProperty("monitor.custom.rpc.port", WebPortUtil.getWebPort((String)WebPortUtil.getServerPort()))));
        boolean connectOk = false;
        for (int i = 0; i < 300; ++i) {
            try (Socket socket = new Socket();){
                socket.connect(new InetSocketAddress(ip, Integer.parseInt(port)), 1000);
                connectOk = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (connectOk) break;
            LockSupport.parkNanos(1000000000L);
        }
    }

    private void initDispatchScheduleEnv() {
        for (DispatchExecutionEnvironmentService tempEnvironmentService : ServiceLoader.load(DispatchExecutionEnvironmentService.class)) {
            DispatchExecutionEnvironment env = new DispatchExecutionEnvironment(tempEnvironmentService.bizType());
            env.setSourceFunctionClass(tempEnvironmentService.sourceFunctionClass());
            env.regist();
        }
    }

    private void initElector() {
        this.elector.registerListener((kd.bos.elect.ElectorListener)this.electorListener);
        this.elector.start();
        ElectorService.startElectorResultNotify();
    }

    private static void broadcastSlave(Set<ServiceInfo> slaveServiceSet) {
        if (slaveServiceSet.size() > 0) {
            PigeonRequestContextUtil.createRpcRequestContext();
            ElectorDTO electorDTO = new ElectorDTO.Builder().build();
            electorDTO.setRole(ElectorRole.SLAVE);
            LOGGER.info("ElectorResult,epoch:{},ElectorDTO:{}", (Object)ElectorManager.getCurrEpoch(), (Object)electorDTO);
            for (ServiceInfo tempServiceInfo : slaveServiceSet) {
                try {
                    Object object = EndPointInvokeServiceHelper.invoke((String)tempServiceInfo.getIp(), (String)tempServiceInfo.getRpcPort(), (String)"kd.bos.pigeon.elect.ElectorService", (String)"notifyElectorResult", (Object[])new Object[]{electorDTO});
                }
                catch (Exception e) {
                    LOGGER.error("broadcastSlaveError", (Throwable)e);
                }
            }
        }
    }

    private static void asyncBroadcastCandidate(Set<ServiceInfo> candidateServiceSet) {
        if (candidateServiceSet.size() > 0) {
            threadPool.execute(() -> {
                PigeonRequestContextUtil.createRpcRequestContext();
                ElectorDTO electorDTO = new ElectorDTO.Builder().build();
                electorDTO.setRole(ElectorRole.CANDIDATE);
                for (ServiceInfo tempServiceInfo : candidateServiceSet) {
                    try {
                        Object object = EndPointInvokeServiceHelper.invoke((String)tempServiceInfo.getIp(), (String)tempServiceInfo.getRpcPort(), (String)"kd.bos.pigeon.elect.ElectorService", (String)"notifyElectorResult", (Object[])new Object[]{electorDTO});
                    }
                    catch (Exception e) {
                        LOGGER.error("asyncBroadcastCandidateError", (Throwable)e);
                    }
                }
            });
        }
    }

    private static void asyncNotifyCandidate(ServiceInfo candidateService) {
        threadPool.execute(() -> {
            PigeonRequestContextUtil.createRpcRequestContext();
            ElectorDTO electorDTO = new ElectorDTO.Builder().build();
            electorDTO.setRole(ElectorRole.CANDIDATE);
            try {
                Object object = EndPointInvokeServiceHelper.invoke((String)candidateService.getIp(), (String)candidateService.getRpcPort(), (String)"kd.bos.pigeon.elect.ElectorService", (String)"notifyElectorResult", (Object[])new Object[]{electorDTO});
            }
            catch (Exception e) {
                LOGGER.error("asyncNotifyCandidateError", (Throwable)e);
            }
        });
    }

    public void stop() {
        try {
            LOGGER.info("pigeonService stop...");
            this.elector.unRegisterListener((kd.bos.elect.ElectorListener)this.electorListener);
            this.elector.close();
            ServiceEventManager.removeListener((String)"pigeon_elector");
            DispatchExecutionEnvironmentManager.destoryEnv();
            this.isStarted = false;
        }
        catch (Exception e) {
            LOGGER.error("stopError", (Throwable)e);
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    private static class PigeonElectorServiceEventListener
    implements ServiceEventListener {
        private PigeonElectorServiceEventListener() {
        }

        public void serviceUp(ServiceInfo serviceInfo) {
            if (Instance.isAppSplit() && serviceInfo.getAppIds() != null && !Arrays.asList(serviceInfo.getAppIds()).contains("pigeon")) {
                return;
            }
            if (!ElectorManager.isMasterNode() || serviceInfo.getInstanceId().equals(Instance.getInstanceId())) {
                return;
            }
            try {
                LOGGER.info(serviceInfo.getInstanceId() + " up");
                int slaveNum = PigeonConstant.ELECTOR_SLAVE_NUMBER_VALUE;
                Set<ServiceInfo> slaveServiceSet = ElectorManager.getCopySlaveServiceSet();
                if (slaveServiceSet.size() >= slaveNum) {
                    PigeonService.asyncNotifyCandidate(serviceInfo);
                    return;
                }
                if (!slaveServiceSet.contains(serviceInfo)) {
                    ElectorManager.ElectorResultWrapper electorResultWrapper = ElectorManager.detectElectorResult(false, ElectorManager.getMasterNode(), serviceInfo);
                    PigeonService.broadcastSlave(electorResultWrapper.getSlaveServiceSet());
                }
            }
            catch (Exception e) {
                LOGGER.error("initServiceInfoListener#serviceUp error,upInstanceId:{},{}", (Object)serviceInfo.getInstanceId(), (Object)e);
            }
        }

        public void serviceDown(ServiceInfo serviceInfo) {
            if (Instance.isAppSplit() && serviceInfo.getAppIds() != null && !Arrays.asList(serviceInfo.getAppIds()).contains("pigeon")) {
                return;
            }
            if (!ElectorManager.isMasterNode() || serviceInfo.getInstanceId().equals(Instance.getInstanceId())) {
                return;
            }
            LOGGER.info(serviceInfo.getInstanceId() + " down");
            ElectorRole downServiceRole = ElectorRole.CANDIDATE;
            if (serviceInfo.getInstanceId().equals(ElectorManager.getMasterNode().getServiceInfo().getInstanceId())) {
                downServiceRole = ElectorRole.MASTER;
            } else if (ElectorManager.getCopySlaveServiceSet().contains(serviceInfo)) {
                downServiceRole = ElectorRole.SLAVE;
            }
            if (downServiceRole == ElectorRole.CANDIDATE) {
                return;
            }
            ElectorManager.ElectorResultWrapper electorResultWrapper = ElectorManager.detectElectorResult(false, ElectorManager.getMasterNode(), null);
            Set<ServiceInfo> slaveServiceSet = electorResultWrapper.getSlaveServiceSet();
            Set<ServiceInfo> candidateServiceSet = electorResultWrapper.getCandidateServiceSet();
            PigeonService.broadcastSlave(slaveServiceSet);
            PigeonService.asyncBroadcastCandidate(candidateServiceSet);
        }
    }

    private static class ElectorListener
    implements kd.bos.elect.ElectorListener {
        private ElectorListener() {
        }

        public void notifyMaster() {
            LOGGER.info(Instance.getInstanceId() + " notifyMaster");
            try {
                ElectorManager.incrementEpoch();
                ElectorNode lastMasterNode = ElectorManager.getMasterNode();
                ElectorManager.setMasterNode();
                ElectorManager.ElectorResultWrapper electorResultWrapper = ElectorManager.detectElectorResult(true, lastMasterNode, null);
                Set<ServiceInfo> slaveServiceSet = electorResultWrapper.getSlaveServiceSet();
                Set<ServiceInfo> candidateServiceSet = electorResultWrapper.getCandidateServiceSet();
                PigeonService.broadcastSlave(slaveServiceSet);
                PigeonService.asyncBroadcastCandidate(candidateServiceSet);
            }
            catch (Exception e) {
                LOGGER.error(Instance.getInstanceId() + " notifyMasterError:{}", (Throwable)e);
            }
        }

        public void notifyLostMaster() {
            LOGGER.info(Instance.getInstanceId() + " notifyLostMaster");
            DispatchExecutionEnvironmentManager.destoryEnv();
        }
    }
}

