/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.pigeon.core.data.PigeonNoRouteQueueNameWrapper;
import kd.bos.pigeon.core.task.GeneralMessageTask;
import kd.bos.pigeon.core.task.Task;
import kd.bos.pigeon.core.task.TaskState;

public class TaskContext {
    private final AtomicReference<TaskState> state = new AtomicReference<TaskState>(TaskState.NOT_INIT);
    private GeneralMessageTask generalMsgTask = null;
    private final List<Task> otherTasks = new ArrayList<Task>(10);
    private final Set<String> bigQueueNameSet = new HashSet<String>(8);
    private final Map<String, PigeonNoRouteQueueNameWrapper> queueName2noRouteQueueNameWrapperMap = new ConcurrentHashMap<String, PigeonNoRouteQueueNameWrapper>(8);
    private final AtomicLong queueStateChangeTime = new AtomicLong(System.currentTimeMillis());

    public TaskState getState() {
        return this.state.get();
    }

    public void setState(TaskState state) {
        this.state.set(state);
    }

    public boolean cmpAndSetState(TaskState oldVal, TaskState newVal) {
        return this.state.compareAndSet(oldVal, newVal);
    }

    public GeneralMessageTask getGeneralMsgTask() {
        return this.generalMsgTask;
    }

    public void setGeneralMsgTask(GeneralMessageTask generalMsgTask) {
        this.generalMsgTask = generalMsgTask;
    }

    public List<Task> getOtherTasks() {
        return this.otherTasks;
    }

    public Set<String> getBigQueueNameSet() {
        return this.bigQueueNameSet;
    }

    public Set<String> getNoRouteQueueNameSet() {
        return this.queueName2noRouteQueueNameWrapperMap.keySet();
    }

    public Map<String, PigeonNoRouteQueueNameWrapper> getQueueName2noRouteQueueNameWrapperMap() {
        return this.queueName2noRouteQueueNameWrapperMap;
    }

    public void markNoRouteQueueName(String queueName, PigeonNoRouteQueueNameWrapper noRouteQueueNameWrapper) {
        this.updateQueueStateChangeTime();
        this.queueName2noRouteQueueNameWrapperMap.put(queueName, noRouteQueueNameWrapper);
    }

    public PigeonNoRouteQueueNameWrapper unmarkNoRouteQueueName(String queueName) {
        this.updateQueueStateChangeTime();
        return this.queueName2noRouteQueueNameWrapperMap.remove(queueName);
    }

    public long getQueueStateChangeTime() {
        return this.queueStateChangeTime.get();
    }

    public void updateQueueStateChangeTime() {
        this.queueStateChangeTime.set(System.currentTimeMillis());
    }
}

