/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.sch;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.pigeon.core.context.ServiceContext;
import kd.bos.pigeon.core.sch.ComparableStack;
import kd.bos.pigeon.core.sch.PigeonSchMgr;
import kd.bos.pigeon.core.store.cache.PigeonCache;
import kd.bos.pigeon.core.task.Task;

public class PigeonSch {
    private static final Map<String, ExecutorService> biztype2threadPoolMap = new ConcurrentHashMap<String, ExecutorService>();
    private final ServiceContext srvCtx;
    private final PigeonCache cache;
    private final ComparableStack<Item> queue = new ComparableStack();
    private final int maxThreadCount;
    private final ExecutorService threadPool;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final PigeonSchMgr mgr;

    public PigeonSch(final String name, int maxThreadCount, ServiceContext srvCtx, PigeonCache cache) {
        biztype2threadPoolMap.computeIfAbsent(name, key -> new ThreadPoolExecutor(5, maxThreadCount, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, name + "-" + this.atomicInteger.incrementAndGet());
            }
        }, new ThreadPoolExecutor.AbortPolicy()));
        this.threadPool = biztype2threadPoolMap.get(name);
        this.maxThreadCount = maxThreadCount;
        this.srvCtx = srvCtx;
        this.cache = cache;
        this.mgr = new PigeonSchMgr(this, srvCtx);
    }

    public boolean removeByAccountId(String accountId) {
        return this.queue.removeIf(item -> Objects.equals(((Item)item).ctx.getAccountId(), accountId));
    }

    public long submit(Task task, int milliseconds) {
        long delay = Math.max((long)milliseconds, 50L);
        long scheduleTime = System.currentTimeMillis() + delay;
        return this.submit(task, RequestContext.get(), scheduleTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long submit(Task task, RequestContext ctx, long scheduleTime) {
        if (ctx == null) {
            throw new NullPointerException("ctx is null.");
        }
        if (task == null) {
            throw new NullPointerException("task is null.");
        }
        task.setSchedule(true);
        Item item = new Item(task, scheduleTime, ctx);
        this.queue.push(item);
        if (this.threadCount.get() > 0 && this.queue.top() == item) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            catch (Exception exception) {
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.queue.size() > this.threadCount.get() && this.threadCount.get() < this.maxThreadCount) {
            try {
                this.startThread();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return scheduleTime;
    }

    private boolean hasTask() {
        boolean hasTask;
        boolean bl = hasTask = !this.queue.isEmpty();
        if (!hasTask) {
            long now = System.currentTimeMillis();
            this.pause(now, now + 30000L);
            hasTask = !this.queue.isEmpty();
        }
        return hasTask;
    }

    private Item pop() {
        long now = System.currentTimeMillis();
        Item item = this.queue.top();
        if (item == null) {
            return null;
        }
        long scheduleTime = item.scheduledTime;
        if (now >= scheduleTime) {
            return this.queue.cmpAndPop(item);
        }
        this.pause(now, scheduleTime);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pause(long now, long scheduleTime) {
        long delay = Math.max(scheduleTime - now, 0L);
        this.lock.lock();
        try {
            this.condition.await(delay, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    public Item[] getQueue() {
        return (Item[])this.queue.toArray(new Item[0]);
    }

    private void startThread() {
        this.threadPool.execute(() -> {
            if (this.threadCount.get() >= this.maxThreadCount) {
                return;
            }
            this.threadCount.incrementAndGet();
            try {
                while (this.hasTask()) {
                    Item i = this.pop();
                    if (i == null) continue;
                    Task task = i.task;
                    try {
                        ServiceContext.setCurrent(this.srvCtx);
                        PigeonSchMgr.setCurrent(this.mgr);
                        RequestContext.copyAndSet((RequestContext)i.ctx);
                        RequestContextThreadBinder.bind((RequestContext)i.ctx);
                        task.run();
                    }
                    catch (Throwable delay) {}
                    continue;
                    finally {
                        if (task.getInterval() > 0) {
                            long delay = Math.max((long)task.getInterval(), 50L);
                            long scheduleTime = System.currentTimeMillis() + delay;
                            this.submit(task, i.ctx, scheduleTime);
                            continue;
                        }
                        task.setSchedule(false);
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                return;
            }
            finally {
                this.threadCount.decrementAndGet();
                ServiceContext.remove();
                PigeonSchMgr.remove();
            }
        });
    }

    public static class Item
    implements Comparable<Item> {
        private final Task task;
        private final long scheduledTime;
        private final RequestContext ctx;

        private Item(Task task, long scheduledTime, RequestContext ctx) {
            this.task = task;
            this.scheduledTime = scheduledTime;
            this.ctx = ctx;
        }

        public Task getTask() {
            return this.task;
        }

        public long getScheduledTime() {
            return this.scheduledTime;
        }

        public RequestContext getRequestContext() {
            return this.ctx;
        }

        @Override
        public int compareTo(Item o) {
            return Long.compare(this.scheduledTime, o.scheduledTime);
        }

        public String toString() {
            return "Item{task=" + this.task + ", scheduledTime=" + this.scheduledTime + '}';
        }
    }
}

