/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.task;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.pigeon.PigeonConsumerManager;
import kd.bos.mq.pigeon.PigeonQueueManager;
import kd.bos.mq.pigeon.PigeonmqFactory;
import kd.bos.pigeon.core.constant.PigeonConstant;
import kd.bos.pigeon.core.context.ServiceContext;
import kd.bos.pigeon.core.context.TaskContext;
import kd.bos.pigeon.core.data.PigeonMessageDTO;
import kd.bos.pigeon.core.sch.PigeonSchMgr;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.core.support.instance.ServiceInfoManager;
import kd.bos.pigeon.core.task.AbstractDispatchMessageTask;
import kd.bos.pigeon.dispatch.support.DispatchJobResult;
import kd.bos.pigeon.dispatch.support.DispatchJobResultType;
import kd.bos.pigeon.dispatch.tranformation.dto.DispatchTaskDTO;
import kd.bos.service.invoke.endpoint.EndPointInvokeServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class BigMessageTask
extends AbstractDispatchMessageTask {
    private static final Log LOGGER = LogFactory.getLog(BigMessageTask.class);
    private static final String TASK_BIG_DISPATCH_BROADCAST_ENABLE_KEY = "mq.pigeon.task.big.dispatch.broadcast.enable";
    private static boolean TASK_BIG_DISPATCH_BROADCAST_ENABLE_VALUE = true;
    private static final String TASK_BIG_DISPATCH_BROADCAST_SIZE_KEY = "mq.pigeon.task.big.dispatch.broadcast.size";
    private static int TASK_BIG_DISPATCH_BROADCAST_SIZE_VALUE;
    private final String queueName;
    private int currInterval = 5000;

    public BigMessageTask(String queueName) {
        this.queueName = queueName;
        this.setInterval(this.currInterval);
    }

    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public void doRun() {
        DispatchJobResult jobResult;
        LOGGER.debug(LocalDateTime.now() + " " + RequestContext.get().getAccountId() + " " + this.getClass().getSimpleName() + ".load");
        IStoreDbConfig storeDbConfig = ServiceContext.getCurrent().getStoreDbConfig();
        Set queueServiceInfoSet = PigeonQueueManager.getQueueServiceInfoSet((String)this.queueName);
        if (queueServiceInfoSet == null) {
            this.setInterval(PigeonConstant.MQ_PIGEON_TASK_BIGMESSAGE_MAX_INTERVAL_VALUE);
            return;
        }
        int dbCountSize = this.getDbCountSize(this.queueName, queueServiceInfoSet);
        List entityList = QueueMessageEntityHelper.queryList((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)storeDbConfig, (int)dbCountSize, (String[])new String[]{MessageStatus.READY.getDesc(), MessageStatus.RETRY.getDesc()}, (String)this.queueName, null);
        List<DispatchTaskDTO<PigeonMessageDTO>> dispatchTaskDTOList = this.filterAndconvertDTOList(entityList);
        if (dispatchTaskDTOList.isEmpty()) {
            PigeonSchMgr.getCurrent().removeTask(this, () -> PigeonSchMgr.getCurrent().getTaskContext().getBigQueueNameSet().remove(this.queueName));
            return;
        }
        if (TASK_BIG_DISPATCH_BROADCAST_ENABLE_VALUE) {
            jobResult = ServiceContext.getCurrent().getDispatchDataStream().broadcastCollection(dispatchTaskDTOList, TASK_BIG_DISPATCH_BROADCAST_SIZE_VALUE);
            if (jobResult.getJobResultType() == DispatchJobResultType.ALL) {
                if (this.currInterval > PigeonConstant.MQ_PIGEON_TASK_BIGMESSAGE_MIN_INTERVAL_VALUE) {
                    this.currInterval -= 100;
                }
            } else if (this.currInterval < PigeonConstant.MQ_PIGEON_TASK_BIGMESSAGE_MAX_INTERVAL_VALUE) {
                this.currInterval += 100;
            }
        } else {
            jobResult = ServiceContext.getCurrent().getDispatchDataStream().collection(dispatchTaskDTOList);
        }
        this.handleFailRoute(storeDbConfig, (DispatchJobResult<PigeonMessageDTO>)jobResult);
        this.setInterval(this.currInterval);
        TaskContext taskContext = ServiceContext.getCurrent().getCurrTaskContext();
        if (taskContext != null && CollectionUtils.isEmpty((Collection)PigeonQueueManager.getQueueServiceInfoSet((String)this.queueName))) {
            PigeonSchMgr.getCurrent().removeTask(this, () -> PigeonSchMgr.getCurrent().getTaskContext().getBigQueueNameSet().remove(this.queueName));
        }
    }

    private int getDbCountSize(String queueName, Set<ServiceInfo> queueServiceInfoSet) {
        int waitingValue;
        int queueDefConcurrency;
        int serviceInfoSize = 0;
        serviceInfoSize = PigeonConstant.LOCAL_SERVER_STANDALONE ? 1 : queueServiceInfoSet.size();
        int dbCountSize = serviceInfoSize * ((queueDefConcurrency = this.getQueueDefConcurrency(queueName)) + (waitingValue = PigeonConsumerManager.getWaitingValue((int)queueDefConcurrency)));
        if (dbCountSize > 50) {
            dbCountSize = 50;
        }
        return dbCountSize;
    }

    private int getQueueDefConcurrency(String queueName) {
        int queueDefConcurrency = PigeonQueueManager.getQueueDefConcurrency((String)queueName);
        if (queueDefConcurrency == -1) {
            ServiceInfo serviceInfo = this.getQueueServiceInfo(queueName);
            try {
                Object responseObject = EndPointInvokeServiceHelper.invoke((String)serviceInfo.getIp(), (String)serviceInfo.getRpcPort(), (String)"kd.bos.mq.pigeon.PigeonConsumerManager", (String)"mserviceGetDefConcurrency", (Object[])new Object[]{queueName});
                if (responseObject != null) {
                    AtomicInteger atomicInteger = (AtomicInteger)responseObject;
                    int defConcurrency = atomicInteger.get();
                    PigeonQueueManager.cacheQueueDefConcurrency((String)queueName, (Integer)defConcurrency);
                    return defConcurrency;
                }
            }
            catch (Exception e) {
                LOGGER.error("getQueueDefConcurrencyError,targetInstanceId:{}", (Object)serviceInfo.getInstanceId(), (Object)e);
            }
        }
        return queueDefConcurrency;
    }

    private ServiceInfo getQueueServiceInfo(String queueName) {
        ServiceInfo serviceInfo = PigeonConstant.LOCAL_SERVER_STANDALONE ? ServiceInfoManager.getCurrServiceInfo() : (ServiceInfo)new ArrayList(PigeonQueueManager.getQueueServiceInfoSet((String)queueName)).get(0);
        return serviceInfo;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + "(" + this.queueName + ")";
    }

    static {
        TASK_BIG_DISPATCH_BROADCAST_ENABLE_VALUE = ConfigurationUtil.getBoolean((String)TASK_BIG_DISPATCH_BROADCAST_ENABLE_KEY, (Boolean)true);
        ConfigurationUtil.observeChange((String)TASK_BIG_DISPATCH_BROADCAST_ENABLE_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                TASK_BIG_DISPATCH_BROADCAST_ENABLE_VALUE = Boolean.getBoolean(BigMessageTask.TASK_BIG_DISPATCH_BROADCAST_ENABLE_KEY);
            }
        });
        TASK_BIG_DISPATCH_BROADCAST_SIZE_VALUE = 999;
        TASK_BIG_DISPATCH_BROADCAST_SIZE_VALUE = ConfigurationUtil.getInteger((String)TASK_BIG_DISPATCH_BROADCAST_SIZE_KEY, (Integer)TASK_BIG_DISPATCH_BROADCAST_SIZE_VALUE);
        ConfigurationUtil.observeChange((String)TASK_BIG_DISPATCH_BROADCAST_SIZE_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                Integer tempBroadcastSize = Integer.getInteger(BigMessageTask.TASK_BIG_DISPATCH_BROADCAST_SIZE_KEY);
                if (tempBroadcastSize <= 0) {
                    TASK_BIG_DISPATCH_BROADCAST_SIZE_VALUE = 1;
                } else {
                    TASK_BIG_DISPATCH_BROADCAST_SIZE_VALUE = tempBroadcastSize;
                }
            }
        });
    }
}

