/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.task;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.pigeon.PigeonmqFactory;
import kd.bos.pigeon.core.constant.PigeonConstant;
import kd.bos.pigeon.core.context.ServiceContext;
import kd.bos.pigeon.core.context.TaskContext;
import kd.bos.pigeon.core.data.PigeonMessageDTO;
import kd.bos.pigeon.core.sch.PigeonSchMgr;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.entity.QueueMessageEntity;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.core.task.AbstractDispatchMessageTask;
import kd.bos.pigeon.dispatch.support.DispatchJobResult;
import kd.bos.pigeon.dispatch.support.DispatchTaskResultVO;
import kd.bos.pigeon.dispatch.tranformation.dto.DispatchTaskDTO;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class GeneralMessageTask
extends AbstractDispatchMessageTask {
    private static final Log LOGGER = LogFactory.getLog(GeneralMessageTask.class);
    private static final String TASK_GENERALMESSAGE_CACHEMSG_SIZE_KEY = "mq.pigeon.task.generalmessage.cachemsg.size";
    private static int TASK_GENERALMESSAGE_CACHEMSG_SIZE_VALUE = 200;
    private static final String TASK_GENERALMESSAGE_CACHEMSG_TIMEOUT_KEY = "mq.pigeon.task.generalmessage.cachemsg.timeout";
    private static int TASK_GENERALMESSAGE_CACHEMSG_TIMEOUT_VALUE;
    private static final String TASK_GENERALMESSAGE_LOAD_SIZE_KEY = "mq.pigeon.task.generalmessage.load.size";
    private static int TASK_GENERALMESSAGE_LOAD_SIZE_VALUE;
    private volatile long scheduledTime = System.currentTimeMillis();
    private long emptyStart = -1L;
    private long lastLoadMsgTime = -1L;
    private List<QueueMessageEntity> cacheMsgList = null;
    private volatile boolean lastUseCacheMsgList = false;
    private Map<String, AtomicInteger> queueName2cacheCountMap = new HashMap<String, AtomicInteger>();

    public GeneralMessageTask() {
        this.setInterval(PigeonConstant.MQ_PIGEON_TASK_GENERALMESSAGE_INTERVAL_VALUE);
    }

    @Override
    public void doRun() {
        long now = System.currentTimeMillis();
        if (now > this.scheduledTime) {
            this.load();
        }
    }

    private void load() {
        LOGGER.debug(LocalDateTime.now() + " " + RequestContext.get().getAccountId() + " " + this.getClass().getSimpleName() + ".load");
        IStoreDbConfig storeDbConfig = ServiceContext.getCurrent().getStoreDbConfig();
        TaskContext taskContext = ServiceContext.getCurrent().getCurrTaskContext();
        List<DispatchTaskDTO<PigeonMessageDTO>> dispatchTaskDTOList = this.loadMsg(storeDbConfig, taskContext);
        if (dispatchTaskDTOList.isEmpty()) {
            if (this.emptyStart == -1L) {
                this.emptyStart = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - this.emptyStart > 10000L) {
                this.scheduledTime = System.currentTimeMillis() + 10000L;
            }
            return;
        }
        this.emptyStart = -1L;
        if (dispatchTaskDTOList.size() == TASK_GENERALMESSAGE_LOAD_SIZE_VALUE) {
            this.setInterval(PigeonConstant.MQ_PIGEON_TASK_GENERALMESSAGE_INTERVAL_VALUE / 2);
        } else {
            this.setInterval(PigeonConstant.MQ_PIGEON_TASK_GENERALMESSAGE_INTERVAL_VALUE);
        }
        HashMap<String, AtomicInteger> queueMsgCount = new HashMap<String, AtomicInteger>();
        ArrayList<DispatchTaskDTO<PigeonMessageDTO>> toDispatchList = new ArrayList<DispatchTaskDTO<PigeonMessageDTO>>();
        for (DispatchTaskDTO<PigeonMessageDTO> tempDTO : dispatchTaskDTOList) {
            AtomicInteger count = queueMsgCount.computeIfAbsent(tempDTO.getQueueName(), s -> new AtomicInteger(0));
            int i = count.incrementAndGet();
            if (i > 10) continue;
            toDispatchList.add(tempDTO);
        }
        DispatchJobResult jobResult = ServiceContext.getCurrent().getDispatchDataStream().collection(toDispatchList);
        this.handleDispatchResult(storeDbConfig, (DispatchJobResult<PigeonMessageDTO>)jobResult);
        this.removeSuccessMsg((DispatchJobResult<PigeonMessageDTO>)jobResult);
    }

    private List<DispatchTaskDTO<PigeonMessageDTO>> loadMsg(IStoreDbConfig storeDbConfig, TaskContext taskContext) {
        List entityList;
        int cacheMsgSize = TASK_GENERALMESSAGE_CACHEMSG_SIZE_VALUE;
        if (this.cacheMsgList == null || this.cacheMsgList.size() < cacheMsgSize || this.lastLoadMsgTime < taskContext.getQueueStateChangeTime() || System.currentTimeMillis() - this.lastLoadMsgTime > (long)TASK_GENERALMESSAGE_CACHEMSG_TIMEOUT_VALUE) {
            ArrayList<String> ignoreQueueName = new ArrayList<String>();
            if (!taskContext.getBigQueueNameSet().isEmpty()) {
                ignoreQueueName.addAll(taskContext.getBigQueueNameSet());
            }
            if (!taskContext.getNoRouteQueueNameSet().isEmpty()) {
                ignoreQueueName.addAll(taskContext.getNoRouteQueueNameSet());
            }
            entityList = QueueMessageEntityHelper.queryList((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)storeDbConfig, (int)TASK_GENERALMESSAGE_LOAD_SIZE_VALUE, (String[])new String[]{MessageStatus.READY.getDesc(), MessageStatus.RETRY.getDesc()}, (String)"", ignoreQueueName);
            this.lastLoadMsgTime = System.currentTimeMillis();
            this.cacheMsgList = null;
            if (ServiceContext.getCurrent().isEnableMemCacheQueue() && entityList.size() >= cacheMsgSize) {
                this.cacheMsgListIfNecessary(entityList, cacheMsgSize);
            }
            this.lastUseCacheMsgList = false;
        } else {
            entityList = this.cacheMsgList;
            this.lastUseCacheMsgList = true;
        }
        return this.filterAndconvertDTOList(entityList);
    }

    private void cacheMsgListIfNecessary(List<QueueMessageEntity> entityList, int cacheMsgSize) {
        ArrayList<QueueMessageEntity> cacheList = new ArrayList<QueueMessageEntity>(entityList.size());
        long currentTimeMillis = System.currentTimeMillis();
        HashMap<String, AtomicInteger> ueue2countMap = new HashMap<String, AtomicInteger>();
        for (QueueMessageEntity tempMessageEntity : entityList) {
            if (tempMessageEntity.getSchTime().getTime() >= currentTimeMillis + (long)TASK_GENERALMESSAGE_CACHEMSG_TIMEOUT_VALUE) continue;
            cacheList.add(tempMessageEntity);
            AtomicInteger count = ueue2countMap.computeIfAbsent(tempMessageEntity.getQueueName(), s -> new AtomicInteger(0));
            count.incrementAndGet();
        }
        if (cacheList.size() >= cacheMsgSize) {
            if (this.lastUseCacheMsgList) {
                String maxQueueName = "";
                int maxCount = 0;
                for (Map.Entry entry : ueue2countMap.entrySet()) {
                    if (((AtomicInteger)entry.getValue()).get() <= maxCount) continue;
                    maxQueueName = (String)entry.getKey();
                    maxCount = ((AtomicInteger)entry.getValue()).get();
                }
                String finalMaxQueueName = maxQueueName;
                AtomicInteger lastCacheCount = this.queueName2cacheCountMap.get(finalMaxQueueName);
                this.queueName2cacheCountMap.clear();
                if (lastCacheCount == null) {
                    this.queueName2cacheCountMap.put(finalMaxQueueName, new AtomicInteger(1));
                } else {
                    int currCacheCount = lastCacheCount.incrementAndGet();
                    if (currCacheCount < 3) {
                        this.queueName2cacheCountMap.put(finalMaxQueueName, lastCacheCount);
                    } else {
                        TaskContext taskContext = ServiceContext.getCurrent().getCurrTaskContext();
                        if (taskContext != null && !taskContext.getNoRouteQueueNameSet().contains(finalMaxQueueName)) {
                            PigeonSchMgr.getCurrent().addBigMsgLoader(finalMaxQueueName);
                            LOGGER.info(RequestContext.get().getAccountId() + " start BigMessageTask,queue=" + finalMaxQueueName);
                            entityList.removeIf(e -> e.getQueueName().equals(finalMaxQueueName));
                            cacheList.removeIf(e -> e.getQueueName().equals(finalMaxQueueName));
                        }
                    }
                }
            } else {
                this.queueName2cacheCountMap.clear();
            }
            this.cacheMsgList = cacheList;
        } else {
            this.queueName2cacheCountMap.clear();
        }
    }

    private void removeSuccessMsg(DispatchJobResult<PigeonMessageDTO> jobResult) {
        if (this.cacheMsgList == null) {
            return;
        }
        HashSet<Long> successIdSet = new HashSet<Long>();
        for (DispatchTaskResultVO resultVO : jobResult.getResultList()) {
            if (!resultVO.isSuccess()) continue;
            successIdSet.add(resultVO.getDispatchTaskDTO().getId());
        }
        if (!successIdSet.isEmpty()) {
            this.cacheMsgList.removeIf(msg -> successIdSet.contains(msg.getId()));
        }
    }

    public synchronized void notify(long scheduledTime) {
        if (scheduledTime < this.scheduledTime) {
            this.scheduledTime = scheduledTime;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    static {
        TASK_GENERALMESSAGE_CACHEMSG_SIZE_VALUE = ConfigurationUtil.getInteger((String)TASK_GENERALMESSAGE_CACHEMSG_SIZE_KEY, (Integer)TASK_GENERALMESSAGE_CACHEMSG_SIZE_VALUE);
        ConfigurationUtil.observeChange((String)TASK_GENERALMESSAGE_CACHEMSG_SIZE_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                TASK_GENERALMESSAGE_CACHEMSG_SIZE_VALUE = Integer.getInteger(GeneralMessageTask.TASK_GENERALMESSAGE_CACHEMSG_SIZE_KEY);
            }
        });
        TASK_GENERALMESSAGE_CACHEMSG_TIMEOUT_VALUE = 30000;
        TASK_GENERALMESSAGE_CACHEMSG_TIMEOUT_VALUE = ConfigurationUtil.getInteger((String)TASK_GENERALMESSAGE_CACHEMSG_TIMEOUT_KEY, (Integer)TASK_GENERALMESSAGE_CACHEMSG_TIMEOUT_VALUE);
        ConfigurationUtil.observeChange((String)TASK_GENERALMESSAGE_CACHEMSG_TIMEOUT_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                TASK_GENERALMESSAGE_CACHEMSG_TIMEOUT_VALUE = Integer.getInteger(GeneralMessageTask.TASK_GENERALMESSAGE_CACHEMSG_TIMEOUT_KEY);
            }
        });
        TASK_GENERALMESSAGE_LOAD_SIZE_VALUE = 500;
        TASK_GENERALMESSAGE_LOAD_SIZE_VALUE = ConfigurationUtil.getInteger((String)TASK_GENERALMESSAGE_LOAD_SIZE_KEY, (Integer)TASK_GENERALMESSAGE_LOAD_SIZE_VALUE);
        ConfigurationUtil.observeChange((String)TASK_GENERALMESSAGE_LOAD_SIZE_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                TASK_GENERALMESSAGE_LOAD_SIZE_VALUE = Integer.getInteger(GeneralMessageTask.TASK_GENERALMESSAGE_LOAD_SIZE_KEY);
            }
        });
    }
}

