/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.task;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.pigeon.PigeonmqFactory;
import kd.bos.pigeon.core.context.ServiceContext;
import kd.bos.pigeon.core.sch.PigeonSchMgr;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.entity.QueueMessageEntity;
import kd.bos.pigeon.core.store.db.entity.QueueTodoMessageEntity;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.store.db.helper.QueueTodoMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.core.task.Task;

public class RouteMoveMessageTask
extends Task {
    private static final Log LOGGER = LogFactory.getLog(RouteMoveMessageTask.class);
    private final String fromTable;
    private final String toTable;
    private final String queueName;

    public RouteMoveMessageTask(String fromTable, String toTable, String queueName) {
        this.fromTable = fromTable;
        this.toTable = toTable;
        this.queueName = queueName;
        this.setInterval(0);
    }

    @Override
    public void doRun() {
        RequestContext requestContext = RequestContext.get();
        IStoreDbConfig storeDbConfig = ServiceContext.getCurrent().getStoreDbConfig();
        long startTime = System.currentTimeMillis();
        LOGGER.info("MoveMessageTask run,tenantId={},accountId={},fromTable={},toTable={},queueName={}", new Object[]{requestContext.getTenantId(), requestContext.getAccountId(), this.fromTable, this.toTable, this.queueName});
        if (this.fromTable.equals(storeDbConfig.getQueueMessageTable()) && this.toTable.equals(storeDbConfig.getQueueTodoMessageTable())) {
            boolean isAllSuccess;
            for (int i = 0; i < 10 && !(isAllSuccess = this.moveGeneral2todo(storeDbConfig)); ++i) {
            }
            PigeonSchMgr.getCurrent().removeTask(this);
        } else if (this.fromTable.equals(storeDbConfig.getQueueTodoMessageTable()) && this.toTable.equals(storeDbConfig.getQueueMessageTable())) {
            boolean isAllSuccess;
            while (!(isAllSuccess = this.moveTodo2General(storeDbConfig))) {
            }
            PigeonSchMgr.getCurrent().removeTask(this, () -> PigeonSchMgr.getCurrent().getTaskContext().unmarkNoRouteQueueName(this.queueName));
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("MoveMessageTask run success,tenantId={},accountId={},fromTable={},toTable={},queueName={},cost={}", new Object[]{requestContext.getTenantId(), requestContext.getAccountId(), this.fromTable, this.toTable, this.queueName, endTime - startTime + "ms"});
    }

    private boolean moveGeneral2todo(IStoreDbConfig storeDbConfig) {
        boolean allSuccess = false;
        List queueMessageEntityList = QueueMessageEntityHelper.queryListForMsgdata((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)storeDbConfig, (int)5000, (String[])new String[]{MessageStatus.READY.getDesc(), MessageStatus.RETRY.getDesc()}, (String)this.queueName);
        if (queueMessageEntityList.size() == 0) {
            return true;
        }
        ArrayList<QueueTodoMessageEntity> todoMessageEntityList = new ArrayList<QueueTodoMessageEntity>(queueMessageEntityList.size());
        for (QueueMessageEntity tempMessageEntity : queueMessageEntityList) {
            QueueTodoMessageEntity todoMessageEntity = new QueueTodoMessageEntity();
            todoMessageEntity.setId(tempMessageEntity.getId());
            todoMessageEntity.setVhost(tempMessageEntity.getVhost());
            todoMessageEntity.setQueueName(this.queueName);
            todoMessageEntity.setRegion(tempMessageEntity.getRegion());
            todoMessageEntity.setAppId(tempMessageEntity.getAppId());
            todoMessageEntity.setInstanceId(tempMessageEntity.getInstanceId());
            todoMessageEntity.setMsgData(tempMessageEntity.getMsgData());
            todoMessageEntity.setStatus(tempMessageEntity.getStatus());
            todoMessageEntity.setReConsumeTime(tempMessageEntity.getReConsumeTime());
            todoMessageEntity.setCreateTime(tempMessageEntity.getCreateTime());
            todoMessageEntity.setUpdateTime(tempMessageEntity.getUpdateTime());
            todoMessageEntity.setSchTime(tempMessageEntity.getCreateTime());
            todoMessageEntityList.add(todoMessageEntity);
        }
        QueueTodoMessageEntityHelper.batchInsert((IStoreDbConfig)storeDbConfig, todoMessageEntityList);
        List idList = queueMessageEntityList.stream().map(QueueMessageEntity::getId).collect(Collectors.toList());
        QueueMessageEntityHelper.deleteList((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)storeDbConfig, idList);
        if (queueMessageEntityList.size() != 5000) {
            allSuccess = true;
        }
        return allSuccess;
    }

    private boolean moveTodo2General(IStoreDbConfig storeDbConfig) {
        boolean allSuccess = false;
        List queueTodoMessageEntityList = QueueTodoMessageEntityHelper.queryListForMsgdata((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)storeDbConfig, (int)5000, (String[])new String[]{MessageStatus.READY.getDesc(), MessageStatus.RETRY.getDesc()}, (String)this.queueName);
        if (queueTodoMessageEntityList.size() == 0) {
            return true;
        }
        ArrayList<QueueMessageEntity> messageEntityList = new ArrayList<QueueMessageEntity>(queueTodoMessageEntityList.size());
        for (QueueTodoMessageEntity tempMessageEntity : queueTodoMessageEntityList) {
            QueueMessageEntity messageEntity = new QueueMessageEntity();
            messageEntity.setId(tempMessageEntity.getId());
            messageEntity.setVhost(tempMessageEntity.getVhost());
            messageEntity.setQueueName(this.queueName);
            messageEntity.setRegion(tempMessageEntity.getRegion());
            messageEntity.setAppId(tempMessageEntity.getAppId());
            messageEntity.setInstanceId(tempMessageEntity.getInstanceId());
            messageEntity.setMsgData(tempMessageEntity.getMsgData());
            messageEntity.setStatus(tempMessageEntity.getStatus());
            messageEntity.setReConsumeTime(tempMessageEntity.getReConsumeTime());
            messageEntity.setCreateTime(tempMessageEntity.getCreateTime());
            messageEntity.setUpdateTime(tempMessageEntity.getUpdateTime());
            messageEntity.setSchTime(tempMessageEntity.getCreateTime());
            messageEntityList.add(messageEntity);
        }
        QueueMessageEntityHelper.batchInsert((IStoreDbConfig)storeDbConfig, messageEntityList);
        List idList = queueTodoMessageEntityList.stream().map(QueueMessageEntity::getId).collect(Collectors.toList());
        QueueTodoMessageEntityHelper.deleteList((IStoreDbConfig)storeDbConfig, idList);
        if (queueTodoMessageEntityList.size() != 5000) {
            allSuccess = true;
        }
        return allSuccess;
    }

    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

