/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.elect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dc.api.model.Account;
import kd.bos.pigeon.elect.AllocateAccountStrategy;
import kd.bos.pigeon.elect.ElectorManager;
import kd.bos.pigeon.elect.ElectorNode;
import kd.bos.util.StringUtils;

public abstract class AbstractAllocateAccountStrategy
implements AllocateAccountStrategy {
    @Override
    public void allocate(List<Account> allAccountList, ElectorNode lastMasterNode, Set<ElectorNode> lastSlaveNodeSet, ElectorNode currMasterNode, Set<ElectorNode> currSlaveNodeSet) {
        String whiteAccountIds = System.getProperty("mq.pigeon.elector.white.accountids");
        if (StringUtils.isNotEmpty((String)whiteAccountIds)) {
            String[] whiteAccountIdArray = whiteAccountIds.split(",|;");
            ArrayList whiteAccountIdList = new ArrayList(whiteAccountIdArray.length);
            Collections.addAll(whiteAccountIdList, whiteAccountIdArray);
            allAccountList.removeIf(tempAccount -> !whiteAccountIdList.contains(tempAccount.getAccountId()));
        }
        if (currSlaveNodeSet.size() == 0 || allAccountList.size() == 1) {
            Map<String, List<Account>> tenantId2accountListMap = this.mergeAccountList(allAccountList);
            currMasterNode.setTenantId2accountListMap(tenantId2accountListMap);
            ElectorManager.updateSlaveNodeSet(currSlaveNodeSet);
            return;
        }
        this.doAllocate(allAccountList, lastMasterNode, lastSlaveNodeSet, currMasterNode, currSlaveNodeSet);
        ElectorManager.updateSlaveNodeSet(currSlaveNodeSet);
    }

    protected Map<String, List<Account>> mergeAccountList(List<Account> accountList) {
        if (accountList == null || accountList.size() == 0) {
            return null;
        }
        HashMap<String, List<Account>> tenantId2accountListMap = new HashMap<String, List<Account>>();
        for (Account tempAccount : accountList) {
            List tempAccountList = tenantId2accountListMap.computeIfAbsent(tempAccount.getTenantId(), key -> new ArrayList());
            tempAccountList.add(tempAccount);
        }
        return tenantId2accountListMap;
    }

    abstract void doAllocate(List<Account> var1, ElectorNode var2, Set<ElectorNode> var3, ElectorNode var4, Set<ElectorNode> var5);
}

