/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.elect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dc.api.model.Account;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.elect.ElectorManager;
import kd.bos.pigeon.elect.ElectorNode;
import kd.bos.pigeon.elect.ElectorRole;

public class ElectorDTO
implements Serializable {
    private int epoch;
    private ElectorRole role;
    private ElectorNodeDTO master;
    private List<ElectorNodeDTO> slaveList;

    private ElectorDTO() {
    }

    public ElectorRole getRole() {
        return this.role;
    }

    public void setRole(ElectorRole role) {
        this.role = role;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public void setEpoch(int epoch) {
        this.epoch = epoch;
    }

    public ElectorNodeDTO getMaster() {
        return this.master;
    }

    public void setMaster(ElectorNodeDTO master) {
        this.master = master;
    }

    public List<ElectorNodeDTO> getSlaveList() {
        return this.slaveList;
    }

    public void setSlaveList(List<ElectorNodeDTO> slaveList) {
        this.slaveList = slaveList;
    }

    public String toString() {
        return "ElectorDTO{epoch=" + this.epoch + ", role=" + (Object)((Object)this.role) + ", master=" + this.master + ", slaveList=" + this.slaveList + '}';
    }

    public static class Builder {
        public ElectorDTO build() {
            ElectorDTO electorDTO = new ElectorDTO();
            electorDTO.setEpoch(ElectorManager.getCurrEpoch());
            ElectorNode masterNode = ElectorManager.getMasterNode();
            ServiceInfo currMaster = masterNode.getServiceInfo();
            ElectorNodeDTO masterElector = new ElectorNodeDTO();
            masterElector.setInstanceId(currMaster.getInstanceId());
            if (masterNode.getTenantId2accountListMap() != null) {
                Map<String, List<Account>> tenantId2accountListMap = masterNode.getTenantId2accountListMap();
                ArrayList<String> tempAccountIdList = new ArrayList<String>();
                Collection<List<Account>> accountListColl = tenantId2accountListMap.values();
                for (List<Account> tempAccoutList : accountListColl) {
                    for (Account tempAccount : tempAccoutList) {
                        tempAccountIdList.add(tempAccount.getAccountId());
                    }
                }
                masterElector.setAccountIdList(tempAccountIdList);
            }
            electorDTO.setMaster(masterElector);
            Set<ElectorNode> copySlaveNodeSet = ElectorManager.getCopySlaveNodeSet();
            ArrayList<ElectorNodeDTO> slaveElectorList = new ArrayList<ElectorNodeDTO>(copySlaveNodeSet.size());
            for (ElectorNode tempElectorNode : copySlaveNodeSet) {
                ElectorNodeDTO tempSlaveElector = new ElectorNodeDTO();
                ServiceInfo tempServiceInfo = tempElectorNode.getServiceInfo();
                tempSlaveElector.setInstanceId(tempServiceInfo.getInstanceId());
                if (tempElectorNode.getTenantId2accountListMap() != null) {
                    Map<String, List<Account>> tenantId2accountListMap = tempElectorNode.getTenantId2accountListMap();
                    ArrayList<String> tempAccountIdList = new ArrayList<String>();
                    Collection<List<Account>> accountListColl = tenantId2accountListMap.values();
                    for (List<Account> tempAccoutList : accountListColl) {
                        for (Account tempAccount : tempAccoutList) {
                            tempAccountIdList.add(tempAccount.getAccountId());
                        }
                    }
                    tempSlaveElector.setAccountIdList(tempAccountIdList);
                }
                slaveElectorList.add(tempSlaveElector);
            }
            electorDTO.setSlaveList(slaveElectorList);
            return electorDTO;
        }
    }

    public static class ElectorNodeDTO
    implements Serializable {
        private String instanceId;
        private List<String> accountIdList;

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public List<String> getAccountIdList() {
            return this.accountIdList;
        }

        public void setAccountIdList(List<String> accountIdList) {
            this.accountIdList = accountIdList;
        }

        public String toString() {
            return "ElectorNodeDTO{instanceId='" + this.instanceId + '\'' + ", accountIdList=" + this.accountIdList + '}';
        }
    }
}

