/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.elect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.extension.ExtensionFactory;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import kd.bos.pigeon.core.constant.PigeonConstant;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.core.support.instance.ServiceInfoManager;
import kd.bos.pigeon.dispatch.support.DispatchExecutionEnvironmentManager;
import kd.bos.pigeon.elect.AllocateAccountStrategy;
import kd.bos.pigeon.elect.ElectorNode;
import kd.bos.pigeon.elect.ElectorRole;

public class ElectorManager {
    private static final Log LOGGER = LogFactory.getLog(ElectorManager.class);
    private static AtomicInteger epoch = new AtomicInteger(0);
    private static ElectorRole role = ElectorRole.CANDIDATE;
    private static ElectorNode masterNode;
    private static Set<ElectorNode> slaveNodeSet;
    private static ExtensionFactory<AllocateAccountStrategy> allocateTenantLoader;
    private static ElectorResultCallback electorResultCallback;
    private static AtomicBoolean electorResultCallbackInit;

    public static int incrementEpoch() {
        return epoch.incrementAndGet();
    }

    public static void updateEpoch(int currEpoch) {
        epoch.set(currEpoch);
    }

    public static void updateRole(ElectorRole currRole) {
        role = currRole;
    }

    public static int getCurrEpoch() {
        return epoch.get();
    }

    public static boolean isMasterNode() {
        return role == ElectorRole.MASTER;
    }

    public static boolean isSlaveNode() {
        return role == ElectorRole.SLAVE;
    }

    static boolean isCandidateNode() {
        return role == ElectorRole.CANDIDATE;
    }

    public static void setMasterNode() {
        role = ElectorRole.MASTER;
        masterNode = new ElectorNode();
        masterNode.setServiceInfo(ServiceInfoManager.getCurrServiceInfo());
    }

    public static ElectorNode getMasterNode() {
        return masterNode;
    }

    public static void updateMasterNode(ElectorNode currMasterNode) {
        masterNode = currMasterNode;
    }

    public static void updateSlaveNodeSet(Set<ElectorNode> currSlaveNodeSet) {
        slaveNodeSet = currSlaveNodeSet;
    }

    public static Set<ElectorNode> getCopySlaveNodeSet() {
        return new HashSet<ElectorNode>(slaveNodeSet);
    }

    public static Set<ServiceInfo> getCopySlaveServiceSet() {
        HashSet<ServiceInfo> copySlaveServiceSet = new HashSet<ServiceInfo>(slaveNodeSet.size());
        for (ElectorNode tempElectorNode : slaveNodeSet) {
            copySlaveServiceSet.add(tempElectorNode.getServiceInfo());
        }
        return copySlaveServiceSet;
    }

    public static ElectorResultWrapper detectElectorResult(boolean isMasterChange, ElectorNode lastMasterNode, ServiceInfo upServiceInfo) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("isMasterChange:{},lastMasterNode:{},upServiceInfo:{}", new Object[]{isMasterChange, lastMasterNode, upServiceInfo != null ? upServiceInfo.getInstanceId() : ""});
        }
        ElectorNode currMasterNode = ElectorManager.getMasterNode();
        Set<ElectorNode> currSlaveNodeSet = ElectorManager.getCopySlaveNodeSet();
        currSlaveNodeSet.removeIf(e -> e.getServiceInfo().getInstanceId().equals(currMasterNode.getServiceInfo().getInstanceId()));
        List<ServiceInfoHealthWrapper> allSortedCandidateList = ElectorManager.computeSortedServiceInfoHealthList(isMasterChange, lastMasterNode, currSlaveNodeSet);
        if (upServiceInfo != null) {
            long count = allSortedCandidateList.stream().filter(wrapper -> wrapper.getServiceInfo().getInstanceId().equals(upServiceInfo.getInstanceId())).count();
            LOGGER.info("Up Service {} {} found", (Object)upServiceInfo.getInstanceId(), (Object)(count > 0L ? "" : "not "));
        }
        AllocateAccountStrategy allocateAccountStrategy = (AllocateAccountStrategy)allocateTenantLoader.getExtension("averagely");
        int slaveNum = PigeonConstant.ELECTOR_SLAVE_NUMBER_VALUE;
        if (slaveNum > 0 && currSlaveNodeSet.size() >= slaveNum) {
            Set<ServiceInfo> candidateList = ElectorManager.getCandidateList(allSortedCandidateList, currSlaveNodeSet);
            Set currSlaveServiceSet = currSlaveNodeSet.stream().map(ElectorNode::getServiceInfo).collect(Collectors.toCollection(HashSet::new));
            allocateAccountStrategy.allocate(AccountUtils.getAllAccountsOfCurrentEnv(), lastMasterNode, ElectorManager.getCopySlaveNodeSet(), currMasterNode, currSlaveNodeSet);
            ElectorManager.fireElectorResultCallback();
            return new ElectorResultWrapper(currMasterNode.getServiceInfo(), currSlaveServiceSet, candidateList);
        }
        HashSet<ServiceInfo> candidateList = new HashSet<ServiceInfo>(allSortedCandidateList.size());
        for (int i = 0; i < allSortedCandidateList.size(); ++i) {
            ServiceInfo tempServiceInfo = allSortedCandidateList.get(i).getServiceInfo();
            if (currSlaveNodeSet.size() < slaveNum) {
                ElectorNode electorNode = new ElectorNode();
                electorNode.setServiceInfo(tempServiceInfo);
                currSlaveNodeSet.add(electorNode);
                continue;
            }
            candidateList.add(tempServiceInfo);
        }
        Set currSlaveServiceSet = currSlaveNodeSet.stream().map(ElectorNode::getServiceInfo).collect(Collectors.toCollection(HashSet::new));
        allocateAccountStrategy.allocate(AccountUtils.getAllAccountsOfCurrentEnv(), lastMasterNode, ElectorManager.getCopySlaveNodeSet(), currMasterNode, currSlaveNodeSet);
        ElectorManager.fireElectorResultCallback();
        return new ElectorResultWrapper(currMasterNode.getServiceInfo(), currSlaveServiceSet, candidateList);
    }

    public static void fireElectorResultCallback() {
        boolean isInit;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("fireElectorResultCallback...");
        }
        if (isInit = electorResultCallbackInit.compareAndSet(false, true)) {
            electorResultCallback = new ElectorResultCallback(){

                @Override
                public void notify(List<Account> accountList) {
                    if (LOGGER.isInfoEnabled()) {
                        String allAccountList = accountList.stream().map(Account::getAccountId).collect(Collectors.joining(","));
                        LOGGER.info("DispatchExecutionEnvironment start,allAccountList:{}", (Object)allAccountList);
                    }
                    DispatchExecutionEnvironmentManager.runEnv(accountList);
                }
            };
        }
        if (ElectorManager.isCandidateNode()) {
            return;
        }
        Map<String, List<Account>> tenantId2accountListMap = null;
        if (ElectorManager.isMasterNode()) {
            tenantId2accountListMap = masterNode.getTenantId2accountListMap();
        } else if (slaveNodeSet.size() > 0) {
            for (ElectorNode tempElectorNode : slaveNodeSet) {
                if (!tempElectorNode.getServiceInfo().getInstanceId().equals(Instance.getInstanceId())) continue;
                tenantId2accountListMap = tempElectorNode.getTenantId2accountListMap();
                break;
            }
        }
        if (tenantId2accountListMap != null) {
            ArrayList<Account> tempAccountList = new ArrayList<Account>();
            Collection<List<Account>> accountListColl = tenantId2accountListMap.values();
            accountListColl.forEach(tempAccountList::addAll);
            electorResultCallback.notify(tempAccountList);
        }
    }

    private static Set<ServiceInfo> getCandidateList(List<ServiceInfoHealthWrapper> allSortedCandidateList, Set<ElectorNode> currSlaveNodeSet) {
        HashSet<ServiceInfo> candidateList = new HashSet<ServiceInfo>(allSortedCandidateList.size());
        if (allSortedCandidateList.size() == currSlaveNodeSet.size()) {
            return candidateList;
        }
        List slaveInstanceIdList = currSlaveNodeSet.stream().map(e -> e.getServiceInfo().getInstanceId()).collect(Collectors.toCollection(ArrayList::new));
        for (ServiceInfoHealthWrapper tempServiceInfoHealthWrapper : allSortedCandidateList) {
            if (slaveInstanceIdList.contains(tempServiceInfoHealthWrapper.getServiceInfo().getInstanceId())) continue;
            candidateList.add(tempServiceInfoHealthWrapper.getServiceInfo());
        }
        return candidateList;
    }

    private static List<ServiceInfoHealthWrapper> computeSortedServiceInfoHealthList(boolean isMasterChange, ElectorNode lastMasterNode, Set<ElectorNode> currSlaveNodeSet) {
        Set allServiceInfoSet = ServiceInfoManager.getCopyAllServiceInfoSet();
        Set<ServiceInfo> allCandidateServiceInfoSet = ElectorManager.getAllCandidateServiceInfoSet(allServiceInfoSet);
        ArrayList<ServiceInfoHealthWrapper> netAvailableResultList = new ArrayList<ServiceInfoHealthWrapper>(allCandidateServiceInfoSet.size());
        HashMap<String, ServiceInfoHealthWrapper> instanceId2wrapperMap = new HashMap<String, ServiceInfoHealthWrapper>(allCandidateServiceInfoSet.size());
        HashSet<String> candidateIpPortSet = new HashSet<String>();
        for (ServiceInfo tempServiceInfo : allCandidateServiceInfoSet) {
            String instanceId;
            int health;
            HealthLevel healthLevel;
            String ipPort = tempServiceInfo.getIp() + ":" + tempServiceInfo.getRpcPort();
            if (candidateIpPortSet.contains(ipPort) || (healthLevel = HealthLevel.from((int)(health = ClusterHealth.getHealth((String)(instanceId = tempServiceInfo.getInstanceId()))))) != HealthLevel.NORMAL && healthLevel != HealthLevel.BUSY && healthLevel != HealthLevel.OVERLOAD && healthLevel != HealthLevel.ERROR || !ServiceInfoManager.pingPongTest((String)tempServiceInfo.getIp(), (String)tempServiceInfo.getRpcPort(), (String)instanceId)) continue;
            ServiceInfoHealthWrapper serviceInfoHealthWrapper = new ServiceInfoHealthWrapper(instanceId, health, tempServiceInfo);
            netAvailableResultList.add(serviceInfoHealthWrapper);
            instanceId2wrapperMap.put(instanceId, serviceInfoHealthWrapper);
            candidateIpPortSet.add(ipPort);
        }
        if (isMasterChange) {
            int slaveNum = PigeonConstant.ELECTOR_SLAVE_NUMBER_VALUE;
            if (lastMasterNode != null && netAvailableResultList.size() > slaveNum) {
                netAvailableResultList.removeIf(tempServiceInfoWrapper -> instanceId2wrapperMap.containsKey(lastMasterNode.getServiceInfo().getInstanceId()));
            }
        }
        if (instanceId2wrapperMap.size() > 0) {
            currSlaveNodeSet.removeIf(tempSlaveNode -> !instanceId2wrapperMap.containsKey(tempSlaveNode.getServiceInfo().getInstanceId()));
        } else {
            currSlaveNodeSet.clear();
        }
        return netAvailableResultList;
    }

    private static Set<ServiceInfo> getAllCandidateServiceInfoSet(Set<ServiceInfo> allServiceInfoSet) {
        if (!Instance.isAppSplit()) {
            allServiceInfoSet.remove(ServiceInfoManager.getCurrServiceInfo());
            return allServiceInfoSet;
        }
        HashSet<ServiceInfo> allCandidateServiceInfoSet = new HashSet<ServiceInfo>(allServiceInfoSet.size());
        for (ServiceInfo tempServiceInfo : allServiceInfoSet) {
            if (tempServiceInfo.getInstanceId().equals(Instance.getInstanceId()) || tempServiceInfo.getAppIds() == null || tempServiceInfo.getAppIds().length <= 0 || !Arrays.asList(tempServiceInfo.getAppIds()).contains("pigeon")) continue;
            allCandidateServiceInfoSet.add(tempServiceInfo);
        }
        return allCandidateServiceInfoSet;
    }

    static {
        slaveNodeSet = new HashSet<ElectorNode>();
        allocateTenantLoader = ExtensionFactory.getExtensionFacotry(AllocateAccountStrategy.class);
        electorResultCallbackInit = new AtomicBoolean(false);
    }

    static interface ElectorResultCallback {
        public void notify(List<Account> var1);
    }

    static class ServiceInfoHealthWrapper {
        private String instanceId;
        private int health;
        private ServiceInfo serviceInfo;

        public ServiceInfoHealthWrapper(String instanceId, int health, ServiceInfo serviceInfo) {
            this.instanceId = instanceId;
            this.health = health;
            this.serviceInfo = serviceInfo;
        }

        public int getHealth() {
            return this.health;
        }

        public String toString() {
            return "ServiceInfoHealthWrapper{instanceId='" + this.instanceId + '\'' + ", health=" + this.health + '}';
        }

        public ServiceInfo getServiceInfo() {
            return this.serviceInfo;
        }
    }

    public static class ElectorResultWrapper {
        private ServiceInfo masterService;
        Set<ServiceInfo> slaveServiceSet;
        Set<ServiceInfo> candidateServiceSet;

        public ElectorResultWrapper(ServiceInfo masterService, Set<ServiceInfo> slaveServiceSet, Set<ServiceInfo> candidateServiceSet) {
            this.masterService = masterService;
            this.slaveServiceSet = slaveServiceSet;
            this.candidateServiceSet = candidateServiceSet;
        }

        public ServiceInfo getMasterService() {
            return this.masterService;
        }

        public Set<ServiceInfo> getSlaveServiceSet() {
            return this.slaveServiceSet;
        }

        public Set<ServiceInfo> getCandidateServiceSet() {
            return this.candidateServiceSet;
        }
    }
}

