/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.store.db.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.entity.QueueMessageEntity;
import kd.bos.pigeon.core.store.db.statistics.QueueMessageStatistics;
import kd.bos.util.StringUtils;

public class QueueMessageEntityHelper {
    private static final Log LOGGER = LogFactory.getLog(QueueMessageEntityHelper.class);

    public static void initTable(IStoreDbConfig storeDbConfig) {
        String[] generalFieldNameArray;
        String routeKey = storeDbConfig.getRouteKey();
        String tableName = storeDbConfig.getQueueMessageTable();
        boolean exists = DB.exitsTable((DBRoute)DBRoute.of((String)routeKey), (String)tableName);
        if (!exists) {
            String pkConstraintName = "PK_" + tableName;
            String string = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '" + tableName + "') \nCREATE TABLE " + tableName + " (\nFID         BIGINT NOT NULL,\nFVHOST      VARCHAR(50) NOT NULL DEFAULT ' ',\nFQUEUENAME      VARCHAR(255) NOT NULL DEFAULT ' ',\nFREGION        VARCHAR(50) NOT NULL DEFAULT ' ',\nFAPPID        VARCHAR(50) NOT NULL DEFAULT ' ',\nFINSTANCEID        VARCHAR(120) NOT NULL DEFAULT ' ',\nFMSGDATA        BLOB,\nFSTATUS     VARCHAR(50) NOT NULL DEFAULT ' ',\nFRECONSUMETIME    INT NOT NULL DEFAULT 0,\nFCREATETIME DATETIME NOT NULL,\nFUPDATETIME DATETIME,\nFSCHTIME DATETIME NOT NULL\n);";
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)string);
            String createPkIdSql = "EXEC P_ALTERPK '" + pkConstraintName + "', '" + tableName + "', 'FID', '1'";
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)createPkIdSql);
        }
        for (String tempFieldName : generalFieldNameArray = new String[]{"FVHOST", "FSTATUS", "FQUEUENAME", "FSCHTIME"}) {
            String indexName = "IDX_" + tableName + "_" + tempFieldName;
            String createIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '" + indexName + "') CREATE INDEX " + indexName + " ON " + tableName + " ( " + tempFieldName + " );";
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)createIndexSql);
        }
        String string = "IDX_" + tableName + "_FVHOST_FSTATUS_FQUEUENAME";
        String createIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '" + string + "') CREATE INDEX " + string + " ON " + tableName + " ( FVHOST, FSTATUS, FQUEUENAME );";
        DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)createIndexSql);
    }

    public static boolean insert(IStoreDbConfig storeDbConfig, QueueMessageEntity entity) {
        String msgTable = storeDbConfig.getQueueMessageTable();
        String insertSql = "insert into " + msgTable + " (fid,fvhost,fqueuename,fregion,fappid,finstanceid,fmsgdata,fstatus,freconsumetime,fcreatetime,fupdatetime,fschtime) values(?,?,?,?,?,?,?,?,?,?,?,?);";
        ArrayList insertList = new ArrayList();
        Collections.addAll(insertList, entity.getId(), entity.getVhost(), entity.getQueueName(), entity.getRegion(), entity.getAppId(), entity.getInstanceId(), entity.getMsgData(), entity.getStatus(), entity.getReConsumeTime(), entity.getCreateTime(), entity.getUpdateTime(), entity.getSchTime());
        return DB.execute((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)insertSql, (Object[])insertList.toArray(new Object[0]));
    }

    public static boolean batchInsert(IStoreDbConfig storeDbConfig, List<QueueMessageEntity> entityList) {
        String msgTable = storeDbConfig.getQueueMessageTable();
        String insertSql = "insert into " + msgTable + " (fid,fvhost,fqueuename,fregion,fappid,finstanceid,fmsgdata,fstatus,freconsumetime,fcreatetime,fupdatetime,fschtime) values(?,?,?,?,?,?,?,?,?,?,?,?);";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(entityList.size());
        for (QueueMessageEntity entity : entityList) {
            ArrayList insertList = new ArrayList();
            Collections.addAll(insertList, entity.getId(), entity.getVhost(), entity.getQueueName(), entity.getRegion(), entity.getAppId(), entity.getInstanceId(), entity.getMsgData(), entity.getStatus(), entity.getReConsumeTime(), entity.getCreateTime(), entity.getUpdateTime(), entity.getSchTime());
            paramList.add(insertList.toArray(new Object[0]));
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)insertSql, paramList);
        return true;
    }

    public static QueueMessageEntity query(IStoreDbConfig storeDbConfig, long id) {
        String msgTable = storeDbConfig.getQueueMessageTable();
        String selectSql = "select fid,fvhost,fqueuename,fregion,fappid,finstanceid,fmsgdata,fstatus,freconsumetime,fcreatetime,fupdatetime,fschtime from " + msgTable + " where fid = ?";
        QueueMessageEntity resultEntity = (QueueMessageEntity)DB.query((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)selectSql, (Object[])new Object[]{id}, resultSet -> {
            if (resultSet.next()) {
                QueueMessageEntity tempResultEntity = new QueueMessageEntity();
                tempResultEntity.setId(resultSet.getLong("fid"));
                tempResultEntity.setVhost(resultSet.getString("fvhost"));
                tempResultEntity.setQueueName(resultSet.getString("fqueuename"));
                tempResultEntity.setRegion(resultSet.getString("fregion"));
                tempResultEntity.setAppId(resultSet.getString("fappid"));
                tempResultEntity.setInstanceId(resultSet.getString("finstanceid"));
                tempResultEntity.setMsgData(resultSet.getBytes("fmsgdata"));
                tempResultEntity.setStatus(resultSet.getString("fstatus"));
                tempResultEntity.setReConsumeTime(resultSet.getInt("freconsumetime"));
                tempResultEntity.setCreateTime(resultSet.getTimestamp("fcreatetime"));
                tempResultEntity.setUpdateTime(resultSet.getTimestamp("fupdatetime"));
                tempResultEntity.setSchTime(resultSet.getTimestamp("fschtime"));
                return tempResultEntity;
            }
            return null;
        });
        return resultEntity;
    }

    public static List<QueueMessageEntity> queryListForMsgdata(String vhost, IStoreDbConfig storeDbConfig, int count, String[] statusArray, String queueName) {
        ArrayList<QueueMessageEntity> resultEntityList = new ArrayList<QueueMessageEntity>(count);
        String msgTable = storeDbConfig.getQueueMessageTable();
        String selectSql = "select top " + count + " fid,fvhost,fqueuename,fregion,fappid,finstanceid,fmsgdata,fstatus,freconsumetime,fcreatetime,fupdatetime,fschtime from " + msgTable + " where fvhost=? and fstatus in ";
        ArrayList<String> selectList = new ArrayList<String>();
        selectList.add(vhost);
        StringBuilder statusSb = new StringBuilder();
        for (int i = 0; i < statusArray.length; ++i) {
            statusSb.append("?").append(",");
        }
        statusSb.deleteCharAt(statusSb.length() - 1);
        selectSql = selectSql + "(" + statusSb + ")";
        Collections.addAll(selectList, statusArray);
        if (queueName != null && !queueName.equals("")) {
            selectSql = selectSql + " and fqueuename = ?";
            Collections.addAll(selectList, queueName);
        }
        selectSql = selectSql + " order by fschtime asc;";
        DB.query((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)selectSql, (Object[])selectList.toArray(new Object[0]), resultSet -> {
            while (resultSet.next()) {
                QueueMessageEntity tempEntity = new QueueMessageEntity();
                tempEntity.setId(resultSet.getLong("fid"));
                tempEntity.setVhost(resultSet.getString("fvhost"));
                tempEntity.setQueueName(resultSet.getString("fqueuename"));
                tempEntity.setRegion(resultSet.getString("fregion"));
                tempEntity.setAppId(resultSet.getString("fappid"));
                tempEntity.setInstanceId(resultSet.getString("finstanceid"));
                tempEntity.setMsgData(resultSet.getBytes("fmsgdata"));
                tempEntity.setStatus(resultSet.getString("fstatus"));
                tempEntity.setReConsumeTime(resultSet.getInt("freconsumetime"));
                tempEntity.setCreateTime(resultSet.getTimestamp("fcreatetime"));
                tempEntity.setUpdateTime(resultSet.getTimestamp("fupdatetime"));
                tempEntity.setSchTime(resultSet.getTimestamp("fschtime"));
                resultEntityList.add(tempEntity);
            }
            return null;
        });
        return resultEntityList;
    }

    public static List<QueueMessageEntity> queryList(String vhost, IStoreDbConfig storeDbConfig, int count, String[] statusArray) {
        ArrayList<QueueMessageEntity> resultEntityList = new ArrayList<QueueMessageEntity>(count);
        String msgTable = storeDbConfig.getQueueMessageTable();
        String selectSql = "select top " + count + " fid,fschtime from " + msgTable + " where fvhost = ? and fstatus in ";
        ArrayList<String> selectList = new ArrayList<String>();
        selectList.add(vhost);
        StringBuilder statusSb = new StringBuilder();
        for (int i = 0; i < statusArray.length; ++i) {
            statusSb.append("?").append(",");
        }
        statusSb.deleteCharAt(statusSb.length() - 1);
        selectSql = selectSql + "(" + statusSb + ");";
        Collections.addAll(selectList, statusArray);
        DB.query((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)selectSql, (Object[])selectList.toArray(new Object[0]), resultSet -> {
            while (resultSet.next()) {
                QueueMessageEntity tempEntity = new QueueMessageEntity();
                tempEntity.setId(resultSet.getLong("fid"));
                tempEntity.setSchTime(resultSet.getTimestamp("fschtime"));
                resultEntityList.add(tempEntity);
            }
            return null;
        });
        return resultEntityList;
    }

    public static List<QueueMessageEntity> queryList(String vhost, IStoreDbConfig storeDbConfig, int count, String[] statusArray, String queueName, List<String> ignoreQueueNames) {
        ArrayList<QueueMessageEntity> resultEntityList = new ArrayList<QueueMessageEntity>();
        String msgTable = storeDbConfig.getQueueMessageTable();
        String selectSql = "select top " + count + " fid,fvhost,fqueuename,fregion,fappid,finstanceid,fstatus,freconsumetime,fcreatetime,fupdatetime,fschtime from " + msgTable + " where fvhost = ? and fstatus in ";
        ArrayList<String> selectList = new ArrayList<String>();
        selectList.add(vhost);
        StringBuilder statusSb = new StringBuilder();
        for (int i = 0; i < statusArray.length; ++i) {
            statusSb.append("?").append(",");
        }
        statusSb.deleteCharAt(statusSb.length() - 1);
        selectSql = selectSql + "(" + statusSb + ")";
        Collections.addAll(selectList, statusArray);
        if (queueName != null && !queueName.equals("")) {
            selectSql = selectSql + " and fqueuename = ?";
            Collections.addAll(selectList, queueName);
        } else if (ignoreQueueNames != null && !ignoreQueueNames.isEmpty()) {
            StringBuilder ignoreSelectSb = new StringBuilder();
            for (String s : ignoreQueueNames) {
                ignoreSelectSb.append("?").append(",");
                selectList.add(s);
            }
            ignoreSelectSb.deleteCharAt(ignoreSelectSb.length() - 1);
            selectSql = selectSql + " and fqueuename not in (" + ignoreSelectSb + ")";
        }
        selectSql = selectSql + " order by fschtime asc;";
        DB.query((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)selectSql, (Object[])selectList.toArray(new Object[0]), resultSet -> {
            while (resultSet.next()) {
                QueueMessageEntity tempEntity = new QueueMessageEntity();
                tempEntity.setId(resultSet.getLong("fid"));
                tempEntity.setVhost(resultSet.getString("fvhost"));
                tempEntity.setQueueName(resultSet.getString("fqueuename"));
                tempEntity.setRegion(resultSet.getString("fregion"));
                tempEntity.setAppId(resultSet.getString("fappid"));
                tempEntity.setInstanceId(resultSet.getString("finstanceid"));
                tempEntity.setStatus(resultSet.getString("fstatus"));
                tempEntity.setReConsumeTime(resultSet.getInt("freconsumetime"));
                tempEntity.setCreateTime(resultSet.getTimestamp("fcreatetime"));
                tempEntity.setUpdateTime(resultSet.getTimestamp("fupdatetime"));
                tempEntity.setSchTime(resultSet.getTimestamp("fschtime"));
                resultEntityList.add(tempEntity);
            }
            return null;
        });
        return resultEntityList;
    }

    public static int updateList(IStoreDbConfig storeDbConfig, List<Long> idList, String status, String[] whereStatus, String instanceId) {
        if (idList == null || idList.size() == 0) {
            return 0;
        }
        String msgTable = storeDbConfig.getQueueMessageTable();
        String updateSql = "update " + msgTable + " set " + (StringUtils.isNotEmpty((String)instanceId) ? "finstanceid=?," : "") + "fstatus=?,fupdatetime=? where fid in ";
        ArrayList<Object> updateList = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((String)instanceId)) {
            Collections.addAll(updateList, instanceId);
        }
        Collections.addAll(updateList, status, new Date());
        StringBuilder idSb = new StringBuilder();
        for (int i = 0; i < idList.size(); ++i) {
            idSb.append("?").append(",");
        }
        idSb.deleteCharAt(idSb.length() - 1);
        updateSql = updateSql + "(" + idSb + ")";
        updateList.addAll(idList);
        if (whereStatus != null && whereStatus.length > 0) {
            StringBuilder statusSb = new StringBuilder();
            for (int i = 0; i < whereStatus.length; ++i) {
                statusSb.append("?").append(",");
                updateList.add(whereStatus[i]);
            }
            statusSb.deleteCharAt(statusSb.length() - 1);
            updateSql = updateSql + " and fstatus in (" + statusSb + ")";
        }
        return DB.update((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)updateSql, (Object[])updateList.toArray(new Object[0]));
    }

    public static int updateList(String vhost, IStoreDbConfig storeDbConfig, String status, String[] whereStatus, String instanceId) {
        String msgTable = storeDbConfig.getQueueMessageTable();
        String updateSql = "update " + msgTable + " set fstatus=?,fupdatetime=? where fvhost=? and finstanceid=?";
        ArrayList<String> updateList = new ArrayList<String>();
        Collections.addAll(updateList, status, new Date(), vhost, instanceId);
        if (whereStatus != null && whereStatus.length > 0) {
            StringBuilder statusSb = new StringBuilder();
            for (int i = 0; i < whereStatus.length; ++i) {
                statusSb.append("?").append(",");
                updateList.add(whereStatus[i]);
            }
            statusSb.deleteCharAt(statusSb.length() - 1);
            updateSql = updateSql + " and fstatus in (" + statusSb + ")";
        }
        return DB.update((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)updateSql, (Object[])updateList.toArray(new Object[0]));
    }

    public static boolean update(IStoreDbConfig storeDbConfig, long id, String status) {
        return QueueMessageEntityHelper.update(storeDbConfig, id, status, -1, null);
    }

    public static boolean update(IStoreDbConfig storeDbConfig, long id, String status, Integer reconsumeTime, Date schDate) {
        return QueueMessageEntityHelper.update(storeDbConfig, id, status, reconsumeTime, schDate, null);
    }

    public static boolean update(IStoreDbConfig storeDbConfig, long id, String status, String[] whereStatus) {
        return QueueMessageEntityHelper.update(storeDbConfig, id, status, -1, null, whereStatus);
    }

    public static boolean update(IStoreDbConfig storeDbConfig, long id, String status, Integer reconsumeTime, Date schDate, String[] whereStatus) {
        String msgTable = storeDbConfig.getQueueMessageTable();
        String updateSql = "update " + msgTable + " set fstatus=?,fupdatetime=?";
        ArrayList<String> updateList = new ArrayList<String>();
        Collections.addAll(updateList, status, new Date());
        if (reconsumeTime > 0) {
            updateSql = updateSql + ",freconsumetime=?,fschtime=?";
            Collections.addAll(updateList, reconsumeTime, schDate);
        }
        updateSql = updateSql + " where fid = ?";
        Collections.addAll(updateList, id);
        if (whereStatus != null && whereStatus.length > 0) {
            StringBuilder statusSb = new StringBuilder();
            for (int i = 0; i < whereStatus.length; ++i) {
                statusSb.append("?").append(",");
                updateList.add(whereStatus[i]);
            }
            statusSb.deleteCharAt(statusSb.length() - 1);
            updateSql = updateSql + " and fstatus in (" + statusSb + ")";
        }
        boolean flag = false;
        int updateSize = DB.update((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)updateSql, (Object[])updateList.toArray(new Object[0]));
        if (updateSize > 0) {
            flag = true;
        }
        return flag;
    }

    public static boolean deleteList(String vhost, IStoreDbConfig storeDbConfig, List<Long> idList) {
        if (idList == null || idList.size() == 0) {
            return false;
        }
        String msgTable = storeDbConfig.getQueueMessageTable();
        String deleteSql = "delete from " + msgTable + " where fvhost = ? and fid in ";
        ArrayList<Object> deleteList = new ArrayList<Object>();
        deleteList.add(vhost);
        StringBuilder idSb = new StringBuilder();
        for (int i = 0; i < idList.size(); ++i) {
            idSb.append("?").append(",");
        }
        idSb.deleteCharAt(idSb.length() - 1);
        deleteSql = deleteSql + "(" + idSb + ")";
        deleteList.addAll(idList);
        boolean flag = false;
        int deleteSize = DB.update((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)deleteSql, (Object[])deleteList.toArray(new Object[0]));
        if (deleteSize > 0) {
            flag = true;
        }
        return flag;
    }

    public static int deleteList(String vhost, IStoreDbConfig storeDbConfig, String queueName, Date beforeDate, String[] whereStatus) {
        String msgTable = storeDbConfig.getQueueMessageTable();
        String deleteSql = "delete from " + msgTable + " where fvhost = ?";
        ArrayList<Object> deleteList = new ArrayList<Object>();
        deleteList.add(vhost);
        if (StringUtils.isNotEmpty((String)queueName)) {
            deleteSql = deleteSql + " and fqueueName = ?";
            deleteList.add(queueName);
        }
        if (beforeDate != null) {
            deleteSql = deleteSql + " and fcreatetime < ?";
            deleteList.add(beforeDate);
        }
        if (whereStatus != null && whereStatus.length > 0) {
            StringBuilder statusSb = new StringBuilder();
            for (int i = 0; i < whereStatus.length; ++i) {
                statusSb.append("?").append(",");
                deleteList.add(whereStatus[i]);
            }
            statusSb.deleteCharAt(statusSb.length() - 1);
            deleteSql = deleteSql + " and fstatus in (" + statusSb + ")";
        }
        return DB.update((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)deleteSql, (Object[])deleteList.toArray(new Object[0]));
    }

    public static int deleteIdList(String vhost, IStoreDbConfig storeDbConfig, List<Long> idList) {
        String msgTable = storeDbConfig.getQueueMessageTable();
        String deleteSql = "delete from " + msgTable + " where fvhost = ? and fid in ";
        ArrayList<Object> deleteList = new ArrayList<Object>();
        deleteList.add(vhost);
        StringBuilder idSb = new StringBuilder();
        for (int i = 0; i < idList.size(); ++i) {
            idSb.append("?").append(",");
        }
        idSb.deleteCharAt(idSb.length() - 1);
        deleteSql = deleteSql + "(" + idSb + ")";
        deleteList.addAll(idList);
        return DB.update((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)deleteSql, (Object[])deleteList.toArray(new Object[0]));
    }

    public static int count(String vhost, IStoreDbConfig storeDbConfig, String queueName, String[] statusArray) {
        String msgTable = storeDbConfig.getQueueMessageTable();
        String selectSql = "select count(*) countSize,fqueuename from " + msgTable + " where fvhost=? and fqueuename=?";
        ArrayList<String> selectList = new ArrayList<String>();
        selectList.add(vhost);
        selectList.add(queueName);
        if (statusArray != null && statusArray.length > 0) {
            StringBuilder statusSb = new StringBuilder();
            for (int i = 0; i < statusArray.length; ++i) {
                statusSb.append("?").append(",");
                selectList.add(statusArray[i]);
            }
            statusSb.deleteCharAt(statusSb.length() - 1);
            selectSql = selectSql + " and fstatus in (" + statusSb + ")";
        }
        selectSql = selectSql + " group by fqueuename order by countSize desc;";
        DB.query((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)selectSql, (Object[])selectList.toArray(new Object[0]), resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt("countSize");
            }
            return 0;
        });
        return 0;
    }

    public static List<QueueMessageStatistics> countStatus(String vhost, IStoreDbConfig storeDbConfig, String queueName) {
        ArrayList<QueueMessageStatistics> resultStatisticsList = new ArrayList<QueueMessageStatistics>(8);
        String msgTable = storeDbConfig.getQueueMessageTable();
        String selectSql = "select count(*) countSize,fqueuename,fstatus from " + msgTable + " where fvhost=?";
        ArrayList<String> selectList = new ArrayList<String>();
        selectList.add(vhost);
        if (StringUtils.isNotEmpty((String)queueName)) {
            selectSql = selectSql + " and fqueuename=?";
            selectList.add(queueName);
        }
        selectSql = selectSql + " group by fqueuename,fstatus order by countSize desc;";
        DB.query((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)selectSql, (Object[])selectList.toArray(new Object[0]), resultSet -> {
            while (resultSet.next()) {
                QueueMessageStatistics tempStatistics = new QueueMessageStatistics();
                tempStatistics.setCountSize(resultSet.getInt("countSize"));
                tempStatistics.setQueueName(resultSet.getString("fqueuename"));
                tempStatistics.setStatus(resultSet.getString("fstatus"));
                resultStatisticsList.add(tempStatistics);
            }
            return null;
        });
        return resultStatisticsList;
    }
}

