/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.store.db.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.pigeon.core.data.PigeonNoRouteQueueNameWrapper;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.entity.QueueMessageEntity;
import kd.bos.pigeon.core.store.db.entity.QueueTodoMessageEntity;

public class QueueTodoMessageEntityHelper {
    private static final Log LOGGER = LogFactory.getLog(QueueTodoMessageEntityHelper.class);

    public static void initTable(IStoreDbConfig storeDbConfig) {
        String[] generalFieldNameArray;
        String routeKey = storeDbConfig.getRouteKey();
        String tableName = storeDbConfig.getQueueTodoMessageTable();
        boolean exists = DB.exitsTable((DBRoute)DBRoute.of((String)routeKey), (String)tableName);
        if (!exists) {
            String pkConstraintName = "PK_" + tableName;
            String createTableCageSwitch = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '" + tableName + "') \nCREATE TABLE " + tableName + " (\nFID         BIGINT NOT NULL,\nFVHOST      VARCHAR(50) NOT NULL DEFAULT ' ',\nFQUEUENAME      VARCHAR(255) NOT NULL DEFAULT ' ',\nFREGION        VARCHAR(50) NOT NULL DEFAULT ' ',\nFAPPID        VARCHAR(50) NOT NULL DEFAULT ' ',\nFINSTANCEID        VARCHAR(120) NOT NULL DEFAULT ' ',\nFMSGDATA        BLOB,\nFSTATUS     VARCHAR(50) NOT NULL DEFAULT ' ',\nFRECONSUMETIME    INT NOT NULL DEFAULT 0,\nFCREATETIME DATETIME NOT NULL,\nFUPDATETIME DATETIME,\nFSCHTIME DATETIME NOT NULL\n);";
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)createTableCageSwitch);
            String createPkIdSql = "EXEC P_ALTERPK '" + pkConstraintName + "', '" + tableName + "', 'FID', '1'";
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)createPkIdSql);
        }
        for (String tempFieldName : generalFieldNameArray = new String[]{"FVHOST", "FSTATUS", "FQUEUENAME", "FSCHTIME"}) {
            String indexName = "IDX_" + tableName + "_" + tempFieldName;
            String createIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '" + indexName + "') CREATE INDEX " + indexName + " ON " + tableName + " ( " + tempFieldName + " );";
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)createIndexSql);
        }
    }

    public static boolean insert(IStoreDbConfig storeDbConfig, QueueTodoMessageEntity entity) {
        String msgTable = storeDbConfig.getQueueTodoMessageTable();
        String insertSql = "insert into " + msgTable + " (fid,fvhost,fqueuename,fregion,fappid,finstanceid,fmsgdata,fstatus,freconsumetime,fcreatetime,fupdatetime,fschtime) values(?,?,?,?,?,?,?,?,?,?,?,?);";
        ArrayList insertList = new ArrayList();
        Collections.addAll(insertList, entity.getId(), entity.getVhost(), entity.getQueueName(), entity.getRegion(), entity.getAppId(), entity.getInstanceId(), entity.getMsgData(), entity.getStatus(), entity.getReConsumeTime(), entity.getCreateTime(), entity.getUpdateTime(), entity.getSchTime());
        return DB.execute((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)insertSql, (Object[])insertList.toArray(new Object[0]));
    }

    public static boolean batchInsert(IStoreDbConfig storeDbConfig, List<QueueTodoMessageEntity> entityList) {
        String msgTable = storeDbConfig.getQueueTodoMessageTable();
        String insertSql = "insert into " + msgTable + " (fid,fvhost,fqueuename,fregion,fappid,finstanceid,fmsgdata,fstatus,freconsumetime,fcreatetime,fupdatetime,fschtime) values(?,?,?,?,?,?,?,?,?,?,?,?);";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(entityList.size());
        for (QueueMessageEntity queueMessageEntity : entityList) {
            ArrayList insertList = new ArrayList();
            Collections.addAll(insertList, queueMessageEntity.getId(), queueMessageEntity.getVhost(), queueMessageEntity.getQueueName(), queueMessageEntity.getRegion(), queueMessageEntity.getAppId(), queueMessageEntity.getInstanceId(), queueMessageEntity.getMsgData(), queueMessageEntity.getStatus(), queueMessageEntity.getReConsumeTime(), queueMessageEntity.getCreateTime(), queueMessageEntity.getUpdateTime(), queueMessageEntity.getSchTime());
            paramList.add(insertList.toArray(new Object[0]));
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)insertSql, paramList);
        return true;
    }

    public static QueueTodoMessageEntity query(IStoreDbConfig storeDbConfig, long id) {
        String msgTable = storeDbConfig.getQueueTodoMessageTable();
        String selectSql = "select fid,fvhost,fqueuename,fregion,fappid,finstanceid,fmsgdata,fstatus,freconsumetime,fcreatetime,fupdatetime,fschtime from " + msgTable + " where fid = ?";
        ArrayList selectList = new ArrayList();
        Collections.addAll(selectList, id);
        QueueTodoMessageEntity resultEntity = (QueueTodoMessageEntity)DB.query((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)selectSql, (Object[])new Object[]{id}, resultSet -> {
            if (resultSet.next()) {
                QueueTodoMessageEntity tempResultEntity = new QueueTodoMessageEntity();
                tempResultEntity.setId(resultSet.getLong("fid"));
                tempResultEntity.setVhost(resultSet.getString("fvhost"));
                tempResultEntity.setQueueName(resultSet.getString("fqueuename"));
                tempResultEntity.setRegion(resultSet.getString("fregion"));
                tempResultEntity.setAppId(resultSet.getString("fappid"));
                tempResultEntity.setInstanceId(resultSet.getString("finstanceid"));
                tempResultEntity.setMsgData(resultSet.getBytes("fmsgdata"));
                tempResultEntity.setStatus(resultSet.getString("fstatus"));
                tempResultEntity.setReConsumeTime(resultSet.getInt("freconsumetime"));
                tempResultEntity.setCreateTime(resultSet.getTimestamp("fcreatetime"));
                tempResultEntity.setUpdateTime(resultSet.getTimestamp("fupdatetime"));
                tempResultEntity.setSchTime(resultSet.getTimestamp("fschtime"));
                return tempResultEntity;
            }
            return null;
        });
        return resultEntity;
    }

    public static List<QueueTodoMessageEntity> queryList(String vhost, IStoreDbConfig storeDbConfig, int count, String[] statusArray, String queueName) {
        ArrayList<QueueTodoMessageEntity> resultEntityList = new ArrayList<QueueTodoMessageEntity>(count);
        String msgTable = storeDbConfig.getQueueTodoMessageTable();
        String selectSql = "select top " + count + " fid,fvhost,fqueuename,fregion,fappid,finstanceid,fstatus,freconsumetime,fcreatetime,fupdatetime,fschtime from " + msgTable + " where fvhost = ? and fstatus in ";
        ArrayList<String> selectList = new ArrayList<String>();
        selectList.add(vhost);
        StringBuilder statusSb = new StringBuilder();
        for (int i = 0; i < statusArray.length; ++i) {
            statusSb.append("?").append(",");
        }
        statusSb.deleteCharAt(statusSb.length() - 1);
        selectSql = selectSql + "(" + statusSb + ")";
        Collections.addAll(selectList, statusArray);
        if (queueName != null && !queueName.equals("")) {
            selectSql = selectSql + " and fqueuename = ?";
            Collections.addAll(selectList, queueName);
        }
        selectSql = selectSql + " order by fschtime asc;";
        DB.query((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)selectSql, (Object[])selectList.toArray(new Object[0]), resultSet -> {
            while (resultSet.next()) {
                QueueTodoMessageEntity tempEntity = new QueueTodoMessageEntity();
                tempEntity.setId(resultSet.getLong("fid"));
                tempEntity.setVhost(resultSet.getString("fvhost"));
                tempEntity.setQueueName(resultSet.getString("fqueuename"));
                tempEntity.setRegion(resultSet.getString("fregion"));
                tempEntity.setAppId(resultSet.getString("fappid"));
                tempEntity.setInstanceId(resultSet.getString("finstanceid"));
                tempEntity.setStatus(resultSet.getString("fstatus"));
                tempEntity.setReConsumeTime(resultSet.getInt("freconsumetime"));
                tempEntity.setCreateTime(resultSet.getTimestamp("fcreatetime"));
                tempEntity.setUpdateTime(resultSet.getTimestamp("fupdatetime"));
                tempEntity.setSchTime(resultSet.getTimestamp("fschtime"));
                resultEntityList.add(tempEntity);
            }
            return null;
        });
        return resultEntityList;
    }

    public static List<QueueTodoMessageEntity> queryListForMsgdata(String vhost, IStoreDbConfig storeDbConfig, int count, String[] statusArray, String queueName) {
        ArrayList<QueueTodoMessageEntity> resultEntityList = new ArrayList<QueueTodoMessageEntity>(count);
        String msgTable = storeDbConfig.getQueueTodoMessageTable();
        String selectSql = "select top " + count + " fid,fvhost,fqueuename,fregion,fappid,finstanceid,fmsgdata,fstatus,freconsumetime,fcreatetime,fupdatetime,fschtime from " + msgTable + " where fvhost = ? and fstatus in ";
        ArrayList<String> selectList = new ArrayList<String>();
        selectList.add(vhost);
        StringBuilder statusSb = new StringBuilder();
        for (int i = 0; i < statusArray.length; ++i) {
            statusSb.append("?").append(",");
        }
        statusSb.deleteCharAt(statusSb.length() - 1);
        selectSql = selectSql + "(" + statusSb + ")";
        Collections.addAll(selectList, statusArray);
        if (queueName != null && !queueName.equals("")) {
            selectSql = selectSql + " and fqueuename = ?";
            Collections.addAll(selectList, queueName);
        }
        selectSql = selectSql + " order by fschtime asc;";
        DB.query((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)selectSql, (Object[])selectList.toArray(new Object[0]), resultSet -> {
            while (resultSet.next()) {
                QueueTodoMessageEntity tempEntity = new QueueTodoMessageEntity();
                tempEntity.setId(resultSet.getLong("fid"));
                tempEntity.setVhost(resultSet.getString("fvhost"));
                tempEntity.setQueueName(resultSet.getString("fqueuename"));
                tempEntity.setRegion(resultSet.getString("fregion"));
                tempEntity.setAppId(resultSet.getString("fappid"));
                tempEntity.setInstanceId(resultSet.getString("finstanceid"));
                tempEntity.setMsgData(resultSet.getBytes("fmsgdata"));
                tempEntity.setStatus(resultSet.getString("fstatus"));
                tempEntity.setReConsumeTime(resultSet.getInt("freconsumetime"));
                tempEntity.setCreateTime(resultSet.getTimestamp("fcreatetime"));
                tempEntity.setUpdateTime(resultSet.getTimestamp("fupdatetime"));
                tempEntity.setSchTime(resultSet.getTimestamp("fschtime"));
                resultEntityList.add(tempEntity);
            }
            return null;
        });
        return resultEntityList;
    }

    public static boolean updateList(IStoreDbConfig storeDbConfig, List<Long> idList, String status) {
        if (idList == null || idList.size() == 0) {
            return false;
        }
        String msgTable = storeDbConfig.getQueueTodoMessageTable();
        String updateSql = "update " + msgTable + " set fstatus=?,fupdatetime=? where fid in ";
        ArrayList<Long> updateList = new ArrayList<Long>();
        Collections.addAll(updateList, status, new Date());
        StringBuilder idSb = new StringBuilder();
        for (int i = 0; i < idList.size(); ++i) {
            idSb.append("?").append(",");
        }
        idSb.deleteCharAt(idSb.length() - 1);
        updateSql = updateSql + "(" + idSb + ")";
        updateList.addAll(idList);
        boolean flag = false;
        int updateSize = DB.update((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)updateSql, (Object[])updateList.toArray(new Object[0]));
        if (updateSize > 0) {
            flag = true;
        }
        return flag;
    }

    public static boolean update(IStoreDbConfig storeDbConfig, long id, String status) {
        String msgTable = storeDbConfig.getQueueTodoMessageTable();
        String updateSql = "update " + msgTable + " set fstatus=?,fupdatetime=?";
        ArrayList updateList = new ArrayList();
        Collections.addAll(updateList, status, new Date());
        updateSql = updateSql + " where fid = ?;";
        Collections.addAll(updateList, id);
        boolean flag = false;
        int updateSize = DB.update((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)updateSql, (Object[])updateList.toArray(new Object[0]));
        if (updateSize > 0) {
            flag = true;
        }
        return flag;
    }

    public static boolean deleteList(IStoreDbConfig storeDbConfig, List<Long> idList) {
        if (idList == null || idList.size() == 0) {
            return false;
        }
        String msgTable = storeDbConfig.getQueueTodoMessageTable();
        String deleteSql = "delete from " + msgTable + " where fid in ";
        ArrayList<Long> deleteList = new ArrayList<Long>();
        StringBuilder idSb = new StringBuilder();
        for (int i = 0; i < idList.size(); ++i) {
            idSb.append("?").append(",");
        }
        idSb.deleteCharAt(idSb.length() - 1);
        deleteSql = deleteSql + "(" + idSb + ")";
        deleteList.addAll(idList);
        boolean flag = false;
        int deleteSize = DB.update((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)deleteSql, (Object[])deleteList.toArray(new Object[0]));
        if (deleteSize > 0) {
            flag = true;
        }
        return flag;
    }

    public static int deleteList(String vhost, IStoreDbConfig storeDbConfig, Date beforeDate, String[] whereStatus) {
        String msgTable = storeDbConfig.getQueueTodoMessageTable();
        String deleteSql = "delete from " + msgTable + " where fvhost = ? and fcreatetime < ?";
        ArrayList<Object> deleteList = new ArrayList<Object>();
        deleteList.add(vhost);
        deleteList.add(beforeDate);
        if (whereStatus != null && whereStatus.length > 0) {
            StringBuilder statusSb = new StringBuilder();
            for (int i = 0; i < whereStatus.length; ++i) {
                statusSb.append("?").append(",");
                deleteList.add(whereStatus[i]);
            }
            statusSb.deleteCharAt(statusSb.length() - 1);
            deleteSql = deleteSql + " and fstatus in (" + statusSb + ")";
        }
        return DB.update((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)deleteSql, (Object[])deleteList.toArray(new Object[0]));
    }

    public static Set<PigeonNoRouteQueueNameWrapper> queryDistanctQueueName(String vhost, IStoreDbConfig storeDbConfig) {
        HashSet<PigeonNoRouteQueueNameWrapper> noConsumerList = new HashSet<PigeonNoRouteQueueNameWrapper>();
        String msgTable = storeDbConfig.getQueueTodoMessageTable();
        String selectSql = "select distinct fqueuename,fappid from " + msgTable + " where fvhost=?";
        DB.query((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)selectSql, (Object[])new Object[]{vhost}, resultSet -> {
            while (resultSet.next()) {
                PigeonNoRouteQueueNameWrapper noConsumerWrapper = new PigeonNoRouteQueueNameWrapper(storeDbConfig.bizType(), resultSet.getString("fappid"), resultSet.getString("fqueuename"));
                noConsumerList.add(noConsumerWrapper);
            }
            return null;
        });
        return noConsumerList;
    }
}

