/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.support.instance;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.pigeon.core.support.instance.ServiceEvent;
import kd.bos.pigeon.core.support.instance.ServiceEventListener;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.core.support.instance.ServiceInfoManager;

public class ServiceEventManager {
    private static final Log LOGGER = LogFactory.getLog(ServiceEventManager.class);
    private static final Map<String, ServiceEventListener> scene2eventListenerMap = new ConcurrentHashMap<String, ServiceEventListener>();

    public static void registerListener(String scene, ServiceEventListener listener) {
        scene2eventListenerMap.putIfAbsent(scene, listener);
    }

    public static void removeListener(String scene) {
        scene2eventListenerMap.remove(scene);
    }

    public static void fireServiceEvent(ServiceEvent serviceEvent, ServiceInfo serviceInfo) {
        if (scene2eventListenerMap.size() == 0) {
            return;
        }
        if (serviceEvent == ServiceEvent.UP) {
            boolean isAlive;
            block14: {
                long currTime;
                if (Instance.isAppSplit() && serviceInfo.getAppIds() == null) {
                    return;
                }
                long startTime = System.currentTimeMillis();
                String ipPort = serviceInfo.getIp() + ":" + serviceInfo.getRpcPort();
                isAlive = false;
                do {
                    if (ServiceInfoManager.rpcPortNetTest(serviceInfo)) {
                        isAlive = true;
                        break block14;
                    }
                    LockSupport.parkNanos(1000000000L);
                } while ((currTime = System.currentTimeMillis()) - startTime <= 180000L);
                LOGGER.error("rpcPortNetTest error,instanceId={},ipPort:{}", (Object)serviceInfo.getInstanceId(), (Object)ipPort);
            }
            if (isAlive) {
                try {
                    for (ServiceEventListener tempListener : scene2eventListenerMap.values()) {
                        tempListener.serviceUp(serviceInfo);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("fireServiceEvent#up error,instanceId={}", (Object)serviceInfo.getInstanceId());
                }
            }
        } else if (serviceEvent == ServiceEvent.DOWN) {
            for (ServiceEventListener tempListener : scene2eventListenerMap.values()) {
                try {
                    tempListener.serviceDown(serviceInfo);
                }
                catch (Exception ex) {
                    LOGGER.error("fireServiceEvent#down error,instanceId={}", (Object)serviceInfo.getInstanceId());
                }
            }
        }
    }
}

