/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.support.instance;

import java.util.Objects;
import kd.bos.pigeon.core.constant.PigeonConstant;

public class ServiceInfo {
    private String appName;
    private String instanceId;
    private String ip;
    private String rpcPort;
    private String monitorPort;
    private String[] appIds;
    private boolean isGateWay;
    private volatile int lastTaskQueueSize;
    private long queueSizeUpdateTime;

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getMonitorPort() {
        return this.monitorPort;
    }

    public void setMonitorPort(String monitorPort) {
        this.monitorPort = monitorPort;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(String rpcPort) {
        this.rpcPort = rpcPort;
    }

    public String[] getAppIds() {
        return this.appIds;
    }

    public void setAppIds(String[] appIds) {
        this.appIds = appIds;
    }

    public int getLastTaskQueueSize() {
        if (System.currentTimeMillis() - this.queueSizeUpdateTime > PigeonConstant.MQ_PIGEON_DISPATCH_SERVICEINFO_TASKQUEUE_TIMEOUT_VALUE) {
            this.lastTaskQueueSize = 0;
        }
        return this.lastTaskQueueSize;
    }

    public void setLastTaskQueueSize(int lastTaskQueueSize) {
        this.lastTaskQueueSize = lastTaskQueueSize;
        this.queueSizeUpdateTime = System.currentTimeMillis();
    }

    public boolean isGateWay() {
        return this.isGateWay;
    }

    public void setGateWay(boolean gateWay) {
        this.isGateWay = gateWay;
    }

    public String toString() {
        return "ServiceInfo{appName='" + this.appName + '\'' + ", instanceId='" + this.instanceId + '\'' + ", ip='" + this.ip + '\'' + ", rpcPort=" + this.rpcPort + ", lastTaskQueueSize=" + this.lastTaskQueueSize + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceInfo that = (ServiceInfo)o;
        return this.instanceId.equals(that.instanceId);
    }

    public int hashCode() {
        return Objects.hash(this.instanceId);
    }
}

