/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.debug;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import kd.bos.script.ScriptException;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.ScriptExecutorFactory;
import kd.bos.script.ScriptInfo;
import kd.bos.script.debug.CallableWithInfo;
import kd.bos.script.debug.DebugCache;
import kd.bos.script.debug.DebugExecutor;
import kd.bos.script.debug.DebugResult;
import kd.bos.script.debug.DebugThreadType;
import kd.bos.script.jsengine.debug.DebugMainThread;
import kd.bos.script.jsengine.debug.KDebugManager;
import kd.bos.script.jsengine.objects.LogMessage;
import kd.bos.util.DisCardUtil;

public interface DebugManager {
    public static void setupThreadDebug(String debugId, DebugThreadType threadType) {
        ScriptExecutorFactory.setupThreadDebug(debugId, threadType);
    }

    public static DebugManager getDebugManager(String debugId) {
        return KDebugManager.getDebugManager(debugId);
    }

    public static DebugManager waitForDebugManager(String debugId) throws InterruptedException {
        return KDebugManager.waitForDebugManager(debugId);
    }

    public static DebugCache getDebugCache(String debugId) {
        return KDebugManager.getDebugCache(debugId);
    }

    public static boolean currentIsDebugMainThread() {
        return ScriptExecutorFactory.getThreadDebugId() != null && ScriptExecutorFactory.getDebugThreadType() == DebugThreadType.main;
    }

    public static boolean keepAlive(String debugId) {
        return KDebugManager.getDebugManager(debugId) != null;
    }

    public static void exit(String debugId) {
        try {
            Object conf = Class.forName("kd.bos.dubbo.debug.conf.DebugAttachConf").getMethod("get", new Class[0]).invoke(null, new Object[0]);
            Method detachByDebugId = conf.getClass().getMethod("detachByDebugId", String.class);
            detachByDebugId.setAccessible(true);
            detachByDebugId.invoke(conf, debugId);
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        finally {
            KDebugManager.removeDebugManager(debugId);
        }
    }

    public static <T> T runAtDebugCmdThread(String debugId, Callable<T> callable, Supplier<String> callableInfoSupplier) throws ScriptException {
        return KDebugManager.runAtDebugCmdThread(debugId, new CallableWithInfo<T>(callable, callableInfoSupplier));
    }

    public static <T> T runAtDebugMainThread(String debugId, Callable<T> callable, Supplier<String> callableInfoSupplier) throws ScriptException {
        return KDebugManager.runAtDebugMainThread(debugId, new CallableWithInfo<T>(callable, callableInfoSupplier), false);
    }

    public static <T> T inspectAtDebugMainThread(String debugId, Callable<T> callable, Supplier<String> callableInfoSupplier) throws ScriptException {
        return KDebugManager.runAtDebugMainThread(debugId, new CallableWithInfo<T>(callable, callableInfoSupplier), true);
    }

    public static DebugMainThread getDebugMainThread(String debugId) {
        return KDebugManager.getDebugMainThread(debugId);
    }

    public ScriptExecutor getScriptExecutor();

    public DebugExecutor getDebugExecutor();

    public void start();

    public void startup();

    public void updateScriptInfo(ScriptInfo ... var1);

    public DebugResult startupThenGet();

    public boolean isStarted();

    public boolean isTerminaled();

    public void addBreakPoint(String var1, int ... var2);

    public void removeBreakPoint(String var1, int ... var2);

    public void setBreakPoint(String var1, int ... var2);

    public void clearBreakPoints(String var1);

    public void clearAllBreakPoints();

    public void skipAllBreakpoints(boolean var1);

    public void addWatch(String var1, String var2);

    public void removeWatch(String var1, String var2);

    public void clearWatches(String var1);

    public void clearAllWatches();

    public List<LogMessage> getLogMessages();
}

