/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.script.Initializer;
import kd.bos.script.ScriptContext;
import kd.bos.script.ScriptException;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.ScriptExecutorFactory;
import kd.bos.script.ScriptFunction;
import kd.bos.script.ScriptInfo;
import kd.bos.script.ScriptValidateResult;
import kd.bos.script.debug.DebugManager;
import kd.bos.script.jsengine.KBigDecimalScale;
import kd.bos.script.jsengine.KContext;
import kd.bos.script.jsengine.KErrorCollector;
import kd.bos.script.jsengine.KExecutorListener;
import kd.bos.script.jsengine.KRuntime;
import kd.bos.script.jsengine.debug.KDebugManager;
import kd.bos.script.jsengine.def.typemap.KJsType;
import kd.bos.script.jsengine.mate.KContextEnv;
import kd.bos.script.log.KScriptLogable;
import kd.bos.script.util.ScriptLookup;
import kd.bos.script.util.SimpleScriptInfo;
import kd.bos.util.ThreadLocals;
import kd.bos.util.resource.Resources;
import org.mozilla.javascript.KVMBridge;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class KExecutor
implements ScriptExecutor,
KScriptLogable {
    private static final AutoCloseable autoCloseable = () -> KContextEnv.exit();
    private static final ThreadLocal<AutoCloseable> thAutoCloseable = ThreadLocals.create(() -> autoCloseable);
    private ClassLoader classLoader;
    private boolean safeModel;
    private KContext context;
    private Initializer si;
    private AtomicBoolean begined = new AtomicBoolean(false);
    private List<KExecutorListener> listeners = new ArrayList<KExecutorListener>();
    private KDebugManager dm = null;
    private CountDownLatch cdDebugStepStart = new CountDownLatch(1);
    private CountDownLatch cdWaitForDebugStepStartted = null;
    private Map<String, Object> attribuiteMap = new HashMap<String, Object>();

    public KExecutor(ClassLoader classLoader, boolean safeModel) {
        this.classLoader = classLoader;
        this.safeModel = safeModel;
        thAutoCloseable.get();
    }

    @Override
    public void init(Initializer si) {
        this.si = si;
    }

    public void addExecutorListener(KExecutorListener l) {
        this.listeners.add(l);
    }

    public boolean removeExecutorListener(KExecutorListener l) {
        return this.listeners.remove(l);
    }

    @Override
    public void begin() {
        if (!this.begined.compareAndSet(false, true)) {
            throw new IllegalStateException(Resources.getString((String)"\u4e0d\u80fd\u91cd\u590dbegin", (String)"KExecutor_0", (String)"bos-serverscript", (Object[])new Object[0]));
        }
        ScriptExecutorFactory.setCurrentScriptExecutor(this);
        this.context = KContext.begin(this.classLoader, this.safeModel, this.si);
        KBigDecimalScale.setupBigDecimalScaleCleaner(this);
    }

    private void checkBegin() {
        if (!this.begined.get()) {
            throw new IllegalStateException(Resources.getString((String)"\u5c1a\u672a\u6267\u884cbegin(\u6267\u884c\u6b65\u9aa4\uff1abegin--> exec/call -->end)\u3002", (String)"KExecutor_1", (String)"bos-serverscript", (Object[])new Object[0]));
        }
    }

    @Override
    public <T> T exec(String ... scripts) {
        ArrayList<SimpleScriptInfo> all = new ArrayList<SimpleScriptInfo>();
        if (scripts != null) {
            int i = 0;
            for (String script : scripts) {
                all.add(new SimpleScriptInfo(++i, script));
            }
        }
        return this.exec(all.toArray(new ScriptInfo[all.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T exec(ScriptInfo ... scriptInfos) {
        ArrayList<ScriptInfo> all = new ArrayList<ScriptInfo>();
        if (scriptInfos != null) {
            all.addAll(Arrays.asList(scriptInfos));
        }
        if (all.size() == 0) {
            return null;
        }
        Object ret = null;
        String script = null;
        this.checkBegin();
        try {
            this.context.onStart();
            this.fireOnStart();
            for (ScriptInfo scriptInfo : all) {
                if (scriptInfo == null || scriptInfo.getContent() == null) continue;
                if (this.dm != null && scriptInfo.debugable() && !this.dm.isDebugBooted()) {
                    if (!this.cdDebugStepStart.await(this.context.getDebugTimeout(), TimeUnit.MILLISECONDS)) throw new RuntimeException("Wait for debugger start timeout.");
                    this.dm.bootDebug(scriptInfo, this.context.getScriptLookup());
                } else {
                    try {
                        if (!scriptInfo.debugable() || this.dm == null) {
                            this.context.maskDebug(true);
                        } else {
                            this.dm.resetForNextExecute();
                            if (this.cdWaitForDebugStepStartted != null && this.cdWaitForDebugStepStartted.getCount() > 0L) {
                                this.cdWaitForDebugStepStartted.countDown();
                            }
                        }
                        script = scriptInfo.getContent();
                        ret = this.context.evaluateString((Scriptable)this.context.getScope(), script, scriptInfo.getName(), 1, (Object)this.context.getSecurityDomain());
                    }
                    finally {
                        if (!scriptInfo.debugable() || this.dm == null) {
                            this.context.maskDebug(false);
                        }
                    }
                }
                this.fireOnExecuted(scriptInfo);
            }
        }
        catch (Throwable e) {
            log.error("script exec error: " + e.getMessage() + "\nscript:" + script, e);
            this.fireOnError(e);
            try {
                ret = this.context.onError(e);
                if (ret instanceof Throwable) {
                    if (!(ret instanceof Error)) throw KRuntime.wrapRuntimeException((Throwable)ret);
                    throw (Error)ret;
                }
            }
            catch (Error t) {
                throw t;
            }
            catch (Throwable t) {
                throw KRuntime.wrapRuntimeException(t);
            }
        }
        finally {
            if (this.cdWaitForDebugStepStartted != null && this.cdWaitForDebugStepStartted.getCount() > 0L) {
                this.cdWaitForDebugStepStartted.countDown();
            }
            this.fireOnStop();
            this.context.onStop();
        }
        ret = KJsType.js2java(ret);
        return (T)ret;
    }

    @Override
    public <T> T execName(String ... scriptNames) {
        ArrayList<ScriptInfo> all = new ArrayList<ScriptInfo>();
        if (scriptNames != null && scriptNames.length > 0) {
            ScriptLookup lookup = this.context.getScriptLookup();
            for (String scriptName : scriptNames) {
                ScriptInfo info = lookup.lookup(scriptName);
                if (info == null) {
                    throw new ScriptException("Script not found: " + scriptName);
                }
                all.add(info);
            }
        }
        return this.exec(all.toArray(new ScriptInfo[all.size()]));
    }

    @Override
    public <T> T call(String name, Object ... args) {
        this.checkBegin();
        int p = name.lastIndexOf(46);
        if (p != -1) {
            String objsName = name.substring(0, p);
            String funcName = name.substring(p + 1);
            ScriptableObject obj = null;
            int i = 0;
            for (String objName : objsName.split("\\.")) {
                obj = i == 0 ? (ScriptableObject)this.context.getScope().get(objName) : (ScriptableObject)obj.get((Object)objName);
                ++i;
            }
            Object ret = ScriptableObject.callMethod(obj, (String)funcName, (Object[])(args == null ? new Object[]{} : args));
            return (T)KJsType.js2java(ret);
        }
        Object func = this.context.get(name);
        if (func instanceof ScriptFunction) {
            return (T)KJsType.js2java(((ScriptFunction)func).call(args));
        }
        throw new IllegalArgumentException("Function " + name + " not found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptValidateResult validate(String script) {
        ScriptValidateResult ret = new ScriptValidateResult();
        this.checkBegin();
        try {
            this.context.onStart();
            this.fireOnStart();
            SimpleScriptInfo scriptInfo = new SimpleScriptInfo(1, script);
            this.context.setValidateModel(true);
            this.context.compileString(scriptInfo.getContent(), scriptInfo.getName(), 1, (Object)this.context.getSecurityDomain());
            ret.setValid(true);
            this.fireOnExecuted(scriptInfo);
        }
        catch (Exception e) {
            log.error("script validate error: " + e.getMessage() + "\nscript:" + script, (Throwable)e);
            ret.setMessage(e.getMessage());
            ret.setValid(false);
            this.fireOnError(e);
            this.context.onError(e);
        }
        finally {
            KErrorCollector rpt = (KErrorCollector)this.context.getErrorReporter();
            rpt.fillToScriptValidateResult(ret);
            this.context.setValidateModel(false);
            this.fireOnStop();
            this.context.onStop();
        }
        return ret;
    }

    @Override
    public void end() {
        if (!this.begined.get()) {
            return;
        }
        int c = KVMBridge.getEnterCount();
        if (c > 0) {
            if (c == 1) {
                if (this.dm != null) {
                    this.dm.terminal();
                }
                this.onEndContext();
                if (this.context != null) {
                    this.context.end();
                }
            } else if (this.context != null) {
                this.context.end();
            }
        }
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    private void fireOnStart() {
        for (KExecutorListener l : this.listeners) {
            l.onStart();
        }
    }

    private void fireOnExecuted(ScriptInfo si) {
        for (KExecutorListener l : this.listeners) {
            l.onExecuted(si);
        }
    }

    private void fireOnError(Throwable e) {
        for (KExecutorListener l : this.listeners) {
            l.onError(e);
        }
    }

    private void fireOnStop() {
        for (KExecutorListener l : this.listeners) {
            l.onStop();
        }
    }

    private void onEndContext() {
        for (KExecutorListener l : new ArrayList<KExecutorListener>(this.listeners)) {
            l.onEndContext();
        }
    }

    public DebugManager attachDebug(String debugId) {
        if (this.dm != null) {
            throw new IllegalStateException(Resources.getString((String)"\u5df2attachDebug", (String)"KExecutor_2", (String)"bos-serverscript", (Object[])new Object[0]));
        }
        this.dm = new KDebugManager(debugId, this);
        return this.dm;
    }

    public void debugStepStart(boolean waitForStartted) {
        if (waitForStartted) {
            this.cdWaitForDebugStepStartted = new CountDownLatch(1);
        }
        this.cdDebugStepStart.countDown();
        if (waitForStartted) {
            try {
                while (this.context == null) {
                    Thread.sleep(100L);
                }
                if (!this.cdWaitForDebugStepStartted.await(this.context.getDebugTimeout(), TimeUnit.MILLISECONDS)) {
                    throw new RuntimeException("Wait for debugger start timeout.");
                }
            }
            catch (InterruptedException e) {
                throw KRuntime.wrapRuntimeException(e);
            }
        }
    }

    @Override
    public void exit() {
        KContextEnv.exit();
    }

    public void setAttribuite(String key, Object value) {
        this.attribuiteMap.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attribuiteMap.get(key);
    }
}

