/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.script.jsengine.KBigDecimalScale;
import kd.bos.script.jsengine.KContext;
import kd.bos.script.jsengine.KDumpper;
import kd.bos.script.jsengine.KRuntime;
import kd.bos.script.jsengine.def.typemap.KJsType;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.annotations.JSFunction;

public class KScope
extends TopLevel {
    private static final long serialVersionUID = -5697881829560064995L;
    private static final String SCRIPT_FUNCTION_PREFIX = "org.mozilla.javascript.gen.KScript";
    private static Map<String, SimpleDateFormat> sdfMap = new ConcurrentHashMap<String, SimpleDateFormat>();

    private static SimpleDateFormat getSimpleDateFormat(String pattern) {
        SimpleDateFormat sdf = sdfMap.get(pattern);
        if (sdf == null) {
            sdf = sdfMap.computeIfAbsent(pattern, p -> new SimpleDateFormat((String)p));
        }
        return sdf;
    }

    @JSFunction
    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @JSFunction
    public BaseFunction[] functions() {
        ArrayList<BaseFunction> funcs = new ArrayList<BaseFunction>();
        for (Object obj : this.getAllIds()) {
            if ((obj = this.get(obj)) == null || !(obj instanceof BaseFunction) || !((BaseFunction)obj).getClass().getName().startsWith(SCRIPT_FUNCTION_PREFIX)) continue;
            funcs.add((BaseFunction)obj);
        }
        Collections.sort(funcs, new Comparator<BaseFunction>(){

            @Override
            public int compare(BaseFunction f1, BaseFunction f2) {
                return f1.getFunctionName().compareTo(f2.getFunctionName());
            }
        });
        return funcs.toArray(new BaseFunction[funcs.size()]);
    }

    @JSFunction
    public String version() {
        return "K-SDK V0.1";
    }

    @JSFunction
    public Date now() {
        return new Date();
    }

    @JSFunction
    public static int toInt(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(String.valueOf(value));
    }

    @JSFunction
    public static long toLong(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(String.valueOf(value));
    }

    @JSFunction
    public static float toFloat(Object value) {
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return Float.parseFloat(String.valueOf(value));
    }

    @JSFunction
    public static double toDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.parseDouble(String.valueOf(value));
    }

    @JSFunction
    public Date toDate(String s) throws ParseException {
        if (s == null) {
            return null;
        }
        if (s.length() <= 10) {
            return KScope.getSimpleDateFormat("yyyy-MM-dd").parse(s);
        }
        return KScope.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(s);
    }

    @JSFunction
    public String dateToString(Scriptable scriptable, String pattern) {
        Date date = (Date)KJsType.js2java(scriptable, Date.class);
        return KScope.getSimpleDateFormat(pattern).format(date);
    }

    @JSFunction
    public static BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return BigDecimal.valueOf(((Number)value).doubleValue());
        }
        return new BigDecimal(String.valueOf(value));
    }

    @JSFunction
    public static String toString(Object value) {
        return Context.toString((Object)value);
    }

    @JSFunction
    public static Boolean toBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return Boolean.FALSE;
    }

    @JSFunction
    public static boolean isNull(Object value) {
        return value == null;
    }

    @JSFunction
    public static boolean isEmpty(Object value) {
        return value == null || value instanceof String && ((String)value).length() == 0;
    }

    @JSFunction
    public static boolean isBlank(Object value) {
        return value == null || value instanceof String && ((String)value).trim().length() == 0;
    }

    @JSFunction
    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                System.out.print(Context.toString((Object)args[i]));
            }
        }
    }

    @JSFunction
    public static void println(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                System.out.println(Context.toString((Object)args[i]));
            }
        } else {
            System.out.println();
        }
    }

    @JSFunction
    public static void dump(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                KDumpper.dump(args[i]);
            }
        }
    }

    @JSFunction
    public Object[] __vars() {
        return super.getIds();
    }

    @JSFunction
    public Object __getJSObject(Object key) {
        key = KJsType.js2java(key);
        Object value = null;
        if (key instanceof String) {
            value = super.get((String)key, (Scriptable)this);
        } else if (key instanceof Number) {
            value = super.get(((Number)key).intValue(), (Scriptable)this);
        }
        return value;
    }

    @JSFunction
    public Object __get(Object key) {
        key = KJsType.js2java(key);
        return KJsType.js2java(this.get(key));
    }

    @Deprecated
    @JSFunction
    public static int importModule(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int c = 0;
        try {
            int n;
            int n2 = n = args == null ? 0 : args.length;
            if (n > 0) {
                KContext ctx = KContext.get();
                for (Object arg : args) {
                    c += ctx.importModule(KScope.class.getResource(String.valueOf(arg)));
                }
            }
        }
        catch (Exception e) {
            throw KRuntime.wrapRuntimeException(e);
        }
        return c;
    }

    @JSFunction
    public static void require(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        try {
            int n;
            int n2 = n = args == null ? 0 : args.length;
            if (n <= 0) {
                return;
            }
            KContext ctx = KContext.get();
            for (Object arg : args) {
                if (arg == null) continue;
                String res = String.valueOf(arg);
                ctx.require(res);
            }
        }
        catch (Exception e) {
            throw KRuntime.wrapRuntimeException(e);
        }
    }

    @Deprecated
    @JSFunction
    public static void importClass(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        try {
            int n;
            int n2 = n = args == null ? 0 : args.length;
            if (n > 0) {
                KContext ctx = KContext.get();
                for (Object arg : args) {
                    String className = String.valueOf(arg);
                    Class<?> clasz = Class.forName(className);
                    ctx.importClass(clasz);
                }
            }
        }
        catch (Exception e) {
            throw KRuntime.wrapRuntimeException(e);
        }
    }

    @JSFunction
    public static void beginBigDecimalScale(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        KBigDecimalScale.DecimalScaleContext ctx = KBigDecimalScale.getDefaultDecimalScaleContext();
        int scale = ctx.scale;
        int roundingMode = ctx.roundingMode;
        if (args != null && args.length > 0) {
            scale = (Integer)KJsType.js2java(args[0], Integer.class);
            if (args.length > 1) {
                roundingMode = KBigDecimalScale.parseRoundingMode(KJsType.js2java(args[1]));
            }
        }
        KBigDecimalScale.beginBigDecimalScale(scale, roundingMode);
    }

    @JSFunction
    public static void endBigDecimalScale(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        KBigDecimalScale.endBigDecimalScale();
    }

    @JSFunction
    public static int getBigDecimalScale(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return KBigDecimalScale.getDefaultDecimalScaleContext().scale;
    }

    @JSFunction
    public static int getBigDecimalRoundingMode(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return KBigDecimalScale.getDefaultDecimalScaleContext().roundingMode;
    }

    @JSFunction
    public static BigDecimal fitBigDecimalScale(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        BigDecimal value = (BigDecimal)KJsType.js2java(args[0], BigDecimal.class);
        return KBigDecimalScale.limitMaxScale(value);
    }
}

