/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.script.jsengine.KRuntime;
import kd.bos.script.jsengine.KScope;
import kd.bos.util.io.IO;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.mozilla.javascript.annotations.JSStaticFunction;

public final class KUtil {
    private static Map<String, String> defineFileContentCache = new ConcurrentHashMap<String, String>();

    static String[] getExportNames(Class<?> objCls) {
        TreeSet<String> set = new TreeSet<String>();
        for (Method method : objCls.getMethods()) {
            if (method.getAnnotation(JSFunction.class) == null && method.getAnnotation(JSStaticFunction.class) == null && method.getAnnotation(JSGetter.class) == null && method.getAnnotation(JSSetter.class) == null) continue;
            set.add(method.getName());
        }
        return set.toArray(new String[set.size()]);
    }

    static void devLog(Object instance, String msg) {
        KUtil.devLog(instance == null ? null : instance.getClass(), msg);
    }

    static void devLog(Class<?> cls, String msg) {
        if (cls != null) {
            msg = "[" + cls.getSimpleName() + "] " + msg;
        }
        IO.out.println((Object)msg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String loadDefineFile(String path, boolean silenceAndCache) {
        String s;
        if (silenceAndCache && (s = defineFileContentCache.get(path)) != null) {
            return s;
        }
        String string = path.intern();
        synchronized (string) {
            try (InputStream is = KScope.class.getResourceAsStream(path);){
                String s2 = KUtil.loadDefineFile(is);
                if (silenceAndCache) {
                    defineFileContentCache.put(path, s2);
                }
                String string2 = s2;
                return string2;
            }
            catch (Exception e) {
                if (silenceAndCache) {
                    defineFileContentCache.put(path, "");
                    return "";
                }
                throw KRuntime.wrapRuntimeException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String loadDefineFile(URL url) {
        try (InputStream is = url.openStream();){
            String string = KUtil.loadDefineFile(is);
            return string;
        }
        catch (Exception e) {
            throw KRuntime.wrapRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadDefineFile(InputStream is) {
        try (InputStreamReader fr = new InputStreamReader(is, StandardCharsets.UTF_8);){
            int size;
            StringBuffer sb = new StringBuffer();
            char[] buf = new char[1024];
            while ((size = fr.read(buf)) != -1) {
                sb.append(buf, 0, size);
            }
            fr.close();
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw KRuntime.wrapRuntimeException(e);
        }
    }

    static List<String[]> toDefineVarConfig(String defs) throws IOException {
        String[] lines = KUtil.split(defs, true, '\r', '\n');
        ArrayList<String[]> ret = new ArrayList<String[]>(lines.length);
        for (String line : lines) {
            String[] segs;
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            for (String seg : segs = KUtil.split(line, true, ';')) {
                int pos;
                if ((seg = seg.trim()).length() == 0 || seg.startsWith("#") || (pos = seg.indexOf(61)) == -1) continue;
                String name = seg.substring(0, pos).trim();
                String value = pos == seg.length() - 1 ? "" : seg.substring(pos + 1).trim();
                ret.add(new String[]{name, value});
            }
        }
        return ret;
    }

    static List<String> toDefineClassConfig(String defs) throws IOException {
        String[] lines = KUtil.split(defs, true, '\r', '\n');
        ArrayList<String> ret = new ArrayList<String>(lines.length);
        for (String line : lines) {
            String[] segs;
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            for (String seg : segs = KUtil.split(line, true, ';')) {
                if ((seg = seg.trim()).length() == 0 || seg.startsWith("#")) continue;
                ret.add(seg);
            }
        }
        return ret;
    }

    static String[] split(String value, boolean withoutEmpty, char ... delim) {
        String[] stringArray;
        if (value == null || value.length() == 0) {
            if (withoutEmpty) {
                return new String[0];
            }
            return new String[]{""};
        }
        if (delim.length > 0) {
            ArrayList<String> ret = new ArrayList<String>();
            String split = new StringBuffer().append(delim).toString();
            char[] chs = value.toCharArray();
            StringBuilder token = new StringBuilder(16);
            int n = chs.length;
            for (int i = 0; i < n; ++i) {
                char ch = chs[i];
                if (split.indexOf(ch) != -1) {
                    if (withoutEmpty) {
                        if (token.toString().trim().length() > 0) {
                            ret.add(token.toString().trim());
                        }
                    } else {
                        ret.add(token.toString());
                    }
                    token.setLength(0);
                    continue;
                }
                token.append(ch);
            }
            if (split.indexOf(chs[chs.length - 1]) != -1) {
                if (!withoutEmpty) {
                    ret.add("");
                }
            } else if (withoutEmpty) {
                if (token.toString().trim().length() > 0) {
                    ret.add(token.toString().trim());
                }
            } else {
                ret.add(token.toString());
            }
            return ret.toArray(new String[ret.size()]);
        }
        if (withoutEmpty) {
            value = value.trim();
        }
        if (value.length() == 0) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        return stringArray;
    }
}

