/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.debug;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.script.jsengine.debug.GuiCallback;
import kd.bos.script.jsengine.debug.KDebugger;
import kd.bos.script.jsengine.debug.KScopeProvider;
import kd.bos.script.jsengine.debug.KSourceProvider;
import kd.bos.script.log.KScriptLogable;
import kd.bos.util.io.IO;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableObject;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class DIM
implements KScriptLogable {
    public static final int STEP_OVER = 0;
    public static final int STEP_INTO = 1;
    public static final int STEP_OUT = 2;
    public static final int GO_FLAG = 3;
    public static final int RESUME = 6;
    public static final int BREAK = 4;
    public static final int EXIT = 5;
    private static final int IPROXY_DEBUG = 0;
    private static final int IPROXY_LISTEN = 1;
    private static final int IPROXY_COMPILE_SCRIPT = 2;
    private static final int IPROXY_EVAL_SCRIPT = 3;
    private static final int IPROXY_STRING_IS_COMPILABLE = 4;
    private static final int IPROXY_OBJECT_TO_STRING = 5;
    private static final int IPROXY_OBJECT_PROPERTY = 6;
    private static final int IPROXY_OBJECT_IDS = 7;
    private boolean penddingResume = false;
    private GuiCallback callback;
    private boolean breakFlag;
    private KScopeProvider scopeProvider;
    private KSourceProvider sourceProvider;
    private int frameIndex = -1;
    private volatile ContextData interruptedContextData;
    private ContextFactory contextFactory;
    private Object monitor = new Object();
    private Object eventThreadMonitor = new Object();
    private volatile int returnValue = -1;
    private boolean insideInterruptLoop;
    private String evalRequest;
    private StackFrame evalFrame;
    private Object evalResult;
    private final AtomicBoolean skipAllBreakpoints;
    private boolean breakOnExceptions;
    private boolean breakOnEnter;
    private boolean breakOnReturn;
    private final Map<String, SourceInfo> urlToSourceInfo = Collections.synchronizedMap(new HashMap());
    private final Map<String, FunctionSource> functionNamesMap = Collections.synchronizedMap(new HashMap());
    private final Map<DebuggableScript, FunctionSource> functionToSource = Collections.synchronizedMap(new HashMap());
    private DimIProxy listener;

    public DIM(AtomicBoolean skipAllBreakpoints) {
        this.skipAllBreakpoints = skipAllBreakpoints;
    }

    public void setGuiCallback(GuiCallback callback) {
        this.callback = callback;
    }

    public void setBreak() {
        this.breakFlag = true;
    }

    public void setScopeProvider(KScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    public void setSourceProvider(KSourceProvider sourceProvider) {
        this.sourceProvider = sourceProvider;
    }

    public void contextSwitch(int frameIndex) {
        this.frameIndex = frameIndex;
    }

    public void setBreakOnExceptions(boolean breakOnExceptions) {
        this.breakOnExceptions = breakOnExceptions;
    }

    public void setBreakOnEnter(boolean breakOnEnter) {
        this.breakOnEnter = breakOnEnter;
    }

    public void setBreakOnReturn(boolean breakOnReturn) {
        this.breakOnReturn = breakOnReturn;
    }

    public void attachTo(ContextFactory factory) {
        this.detach();
        this.contextFactory = factory;
        this.listener = new DimIProxy(this, 1);
        factory.addListener((ContextFactory.Listener)this.listener);
    }

    public void detach() {
        if (this.listener != null) {
            this.contextFactory.removeListener((ContextFactory.Listener)this.listener);
            this.contextFactory = null;
            this.listener = null;
        }
    }

    public void dispose() {
        this.detach();
    }

    private FunctionSource getFunctionSource(DebuggableScript fnOrScript) {
        FunctionSource fsource = this.functionSource(fnOrScript);
        if (fsource != null) {
            return fsource;
        }
        String url = this.getNormalizedUrl(fnOrScript);
        SourceInfo si = this.sourceInfo(url);
        if (si == null && !fnOrScript.isGeneratedScript()) {
            fsource = this.loadFunctionSource(url, fnOrScript);
        }
        return fsource;
    }

    private FunctionSource loadFunctionSource(String url, DebuggableScript fnOrScript) {
        String source = this.loadSource(url);
        if (source != null) {
            DebuggableScript parent;
            DebuggableScript top = fnOrScript;
            while ((parent = top.getParent()) != null) {
                top = parent;
            }
            this.registerTopScript(top, source);
            return this.functionSource(fnOrScript);
        }
        return null;
    }

    private String loadSource(String sourceUrl) {
        String source = null;
        int hash = sourceUrl.indexOf(35);
        if (hash >= 0) {
            sourceUrl = sourceUrl.substring(0, hash);
        }
        try {
            InputStream is;
            block19: {
                if (sourceUrl.indexOf(58) < 0) {
                    block20: {
                        try {
                            String pathFromHome;
                            File f;
                            String home;
                            if (sourceUrl.startsWith("~/") && (home = SecurityUtilities.getSystemProperty((String)"user.home")) != null && (f = new File(new File(home), pathFromHome = sourceUrl.substring(2))).exists()) {
                                is = new FileInputStream(f);
                                break block19;
                            }
                            File f2 = new File(sourceUrl);
                            if (!f2.exists()) break block20;
                            is = new FileInputStream(f2);
                            break block19;
                        }
                        catch (SecurityException ex) {
                            log.warn(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    sourceUrl = sourceUrl.startsWith("//") ? "http:" + sourceUrl : (sourceUrl.startsWith("/") ? "http://127.0.0.1" + sourceUrl : "http://" + sourceUrl);
                }
                is = new URL(sourceUrl).openStream();
            }
            try (InputStreamReader reader = new InputStreamReader(is);){
                source = Kit.readReader((Reader)reader);
            }
        }
        catch (IOException ex) {
            IO.err.println((Object)("Failed to load source from " + sourceUrl + ": " + ex));
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTopScript(DebuggableScript topScript, String source) {
        String providedSource;
        if (!topScript.isTopLevel()) {
            throw new IllegalArgumentException();
        }
        String url = this.getNormalizedUrl(topScript);
        DebuggableScript[] functions = DIM.getAllFunctions(topScript);
        if (this.sourceProvider != null && (providedSource = this.sourceProvider.getSource(topScript)) != null) {
            source = providedSource;
        }
        SourceInfo sourceInfo = new SourceInfo(source, functions, url);
        Map<String, Object> map = this.urlToSourceInfo;
        synchronized (map) {
            SourceInfo old = this.urlToSourceInfo.get(url);
            if (old != null) {
                sourceInfo.copyBreakpointsFrom(old);
            }
            this.urlToSourceInfo.put(url, sourceInfo);
            for (int i = 0; i != sourceInfo.functionSourcesTop(); ++i) {
                FunctionSource fsource = sourceInfo.functionSource(i);
                String name = fsource.name();
                if (name.length() == 0) continue;
                this.functionNamesMap.put(name, fsource);
            }
        }
        map = this.functionToSource;
        synchronized (map) {
            for (int i = 0; i != functions.length; ++i) {
                FunctionSource fsource = sourceInfo.functionSource(i);
                this.functionToSource.put(functions[i], fsource);
            }
        }
        this.callback.onRegist(sourceInfo);
    }

    private FunctionSource functionSource(DebuggableScript fnOrScript) {
        return this.functionToSource.get(fnOrScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] functionNames() {
        Map<String, SourceInfo> map = this.urlToSourceInfo;
        synchronized (map) {
            return this.functionNamesMap.keySet().toArray(new String[this.functionNamesMap.size()]);
        }
    }

    public FunctionSource functionSourceByName(String functionName) {
        return this.functionNamesMap.get(functionName);
    }

    public SourceInfo sourceInfo(String url) {
        return this.urlToSourceInfo.get(url);
    }

    private String getNormalizedUrl(DebuggableScript fnOrScript) {
        String url = fnOrScript.getSourceName();
        if (url == null) {
            url = "<stdin>";
        } else {
            int searchStart;
            int evalSeparator = 35;
            StringBuilder sb = null;
            int urlLength = url.length();
            int cursor = 0;
            while ((searchStart = url.indexOf(evalSeparator, cursor)) >= 0) {
                char c;
                int i;
                String replace = null;
                for (i = searchStart + 1; i != urlLength && '0' <= (c = url.charAt(i)) && c <= '9'; ++i) {
                }
                if (i != searchStart + 1 && "(eval)".regionMatches(0, url, i, 6)) {
                    cursor = i + 6;
                    replace = "(eval)";
                }
                if (replace == null) break;
                if (sb == null) {
                    sb = new StringBuilder();
                    sb.append(url.substring(0, searchStart));
                }
                sb.append(replace);
            }
            if (sb != null) {
                if (cursor != urlLength) {
                    sb.append(url.substring(cursor));
                }
                url = sb.toString();
            }
        }
        return url;
    }

    private static DebuggableScript[] getAllFunctions(DebuggableScript function) {
        ObjArray functions = new ObjArray();
        DIM.collectFunctions_r(function, functions);
        Object[] result = new DebuggableScript[functions.size()];
        functions.toArray(result);
        return result;
    }

    private static void collectFunctions_r(DebuggableScript function, ObjArray array) {
        array.add((Object)function);
        for (int i = 0; i != function.getFunctionCount(); ++i) {
            DIM.collectFunctions_r(function.getFunction(i), array);
        }
    }

    public void clearAllBreakpoints() {
        for (SourceInfo si : new ArrayList<SourceInfo>(this.urlToSourceInfo.values())) {
            si.removeAllBreakpoints();
        }
    }

    private void handleBreakpointHit(StackFrame frame, Context cx) {
        this.breakFlag = false;
        this.interrupted(cx, frame, null);
    }

    private void handleExceptionThrown(Context cx, Throwable ex, StackFrame frame) {
        ContextData cd;
        if (this.breakOnExceptions && (cd = frame.contextData()).lastProcessedException != ex) {
            this.interrupted(cx, frame, ex);
            cd.lastProcessedException = ex;
        }
    }

    public ContextData currentContextData() {
        return this.interruptedContextData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReturnValue(int returnValue) {
        Object object = this.monitor;
        synchronized (object) {
            this.returnValue = returnValue;
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        Object object = this.monitor;
        synchronized (object) {
            this.returnValue = 3;
            this.monitor.notifyAll();
        }
    }

    public Object eval(String expr) {
        return this.eval(expr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String expr, boolean forWatch) {
        Object result = "undefined";
        if (expr == null) {
            return result;
        }
        ContextData contextData = this.currentContextData();
        if (contextData == null || this.frameIndex >= contextData.frameCount()) {
            return result;
        }
        StackFrame frame = contextData.getFrame(this.frameIndex);
        if (contextData.eventThreadFlag || forWatch) {
            Context cx = Context.getCurrentContext();
            result = DIM.do_eval(cx, frame, expr);
        } else {
            Object object = this.monitor;
            synchronized (object) {
                if (this.insideInterruptLoop) {
                    this.evalRequest = expr;
                    this.evalFrame = frame;
                    this.monitor.notify();
                    do {
                        try {
                            this.monitor.wait();
                        }
                        catch (InterruptedException exc) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    } while (this.evalRequest != null);
                    result = this.evalResult;
                }
            }
        }
        return result;
    }

    public void compileScript(String url, String text) {
        DimIProxy action = new DimIProxy(this, 2);
        action.url = url;
        action.text = text;
        action.withContext();
    }

    public void evalScript(String url, String text) {
        DimIProxy action = new DimIProxy(this, 3);
        action.url = url;
        action.text = text;
        action.withContext();
    }

    public String objectToString(Object object) {
        DimIProxy action = new DimIProxy(this, 5);
        action.object = object;
        action.withContext();
        return action.stringResult;
    }

    public boolean stringIsCompilableUnit(String str) {
        DimIProxy action = new DimIProxy(this, 4);
        action.text = str;
        action.withContext();
        return action.booleanResult;
    }

    public Object getObjectProperty(Object object, Object id) {
        DimIProxy action = new DimIProxy(this, 6);
        action.object = object;
        action.id = id;
        action.withContext();
        return action.objectResult;
    }

    public Object[] getObjectIds(Object object) {
        DimIProxy action = new DimIProxy(this, 7);
        action.object = object;
        action.withContext();
        return action.objectArrayResult;
    }

    private Object getObjectPropertyImpl(Context cx, Object object, Object id) {
        Object result;
        Scriptable scriptable = (Scriptable)object;
        if (id instanceof String) {
            String name = (String)id;
            if (name.equals("this")) {
                result = scriptable;
            } else if (name.equals("__proto__")) {
                result = scriptable.getPrototype();
            } else if (name.equals("__parent__")) {
                result = scriptable.getParentScope();
            } else {
                result = ScriptableObject.getProperty((Scriptable)scriptable, (String)name);
                if (result == ScriptableObject.NOT_FOUND) {
                    result = Undefined.instance;
                }
            }
        } else {
            int index = (Integer)id;
            result = ScriptableObject.getProperty((Scriptable)scriptable, (int)index);
            if (result == ScriptableObject.NOT_FOUND) {
                result = Undefined.instance;
            }
        }
        return result;
    }

    private Object[] getObjectIdsImpl(Context cx, Object object) {
        if (!(object instanceof Scriptable) || object == Undefined.instance) {
            return Context.emptyArgs;
        }
        Scriptable scriptable = (Scriptable)object;
        Object[] ids = scriptable instanceof DebuggableObject ? ((DebuggableObject)scriptable).getAllIds() : scriptable.getIds();
        Scriptable proto = scriptable.getPrototype();
        Scriptable parent = scriptable.getParentScope();
        int extra = 0;
        if (proto != null) {
            ++extra;
        }
        if (parent != null) {
            ++extra;
        }
        if (extra != 0) {
            Object[] tmp = new Object[extra + ids.length];
            System.arraycopy(ids, 0, tmp, extra, ids.length);
            ids = tmp;
            extra = 0;
            if (proto != null) {
                ids[extra++] = "__proto__";
            }
            if (parent != null) {
                ids[extra++] = "__parent__";
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void interrupted(Context cx, StackFrame frame, Throwable scriptException) {
        boolean recursiveEventThreadCall;
        boolean eventThreadFlag;
        ContextData contextData;
        block41: {
            block40: {
                block39: {
                    if (this.skipAllBreakpoints.get()) {
                        return;
                    }
                    contextData = frame.contextData();
                    ((KDebugger)this.callback).setCurrentSourceInfo(frame.fsource.sourceInfoField);
                    eventThreadFlag = this.callback.isGuiEventThread();
                    contextData.eventThreadFlag = eventThreadFlag;
                    recursiveEventThreadCall = false;
                    Object object = this.eventThreadMonitor;
                    // MONITORENTER : object
                    if (!eventThreadFlag) break block39;
                    if (this.interruptedContextData == null) break block40;
                    recursiveEventThreadCall = true;
                    // MONITOREXIT : object
                    break block41;
                }
                while (this.interruptedContextData != null) {
                    try {
                        this.eventThreadMonitor.wait();
                    }
                    catch (InterruptedException exc) {
                        // MONITOREXIT : object
                        return;
                    }
                }
            }
            this.interruptedContextData = contextData;
            // MONITOREXIT : object
        }
        if (recursiveEventThreadCall) {
            return;
        }
        if (this.interruptedContextData == null) {
            Kit.codeBug();
        }
        try {
            int frameCount = contextData.frameCount();
            this.frameIndex = frameCount - 1;
            String threadTitle = Thread.currentThread().toString();
            String alertMessage = scriptException == null ? null : scriptException.toString();
            int returnValue = -1;
            if (!eventThreadFlag) {
                block38: {
                    Object object = this.monitor;
                    // MONITORENTER : object
                    if (this.insideInterruptLoop) {
                        Kit.codeBug();
                    }
                    this.insideInterruptLoop = true;
                    this.evalRequest = null;
                    try {
                        this.returnValue = -1;
                        this.callback.enterInterrupt(frame, threadTitle, alertMessage);
                        while (true) {
                            try {
                                this.monitor.wait();
                            }
                            catch (InterruptedException exc) {
                                Thread.currentThread().interrupt();
                                break block38;
                            }
                            if (this.evalRequest != null) {
                                this.evalResult = null;
                                try {
                                    this.evalResult = DIM.do_eval(cx, this.evalFrame, this.evalRequest);
                                }
                                finally {
                                    this.evalRequest = null;
                                    this.evalFrame = null;
                                    this.monitor.notify();
                                }
                                continue;
                            }
                            if (this.returnValue != -1) break;
                        }
                        returnValue = this.returnValue;
                    }
                    finally {
                        this.insideInterruptLoop = false;
                    }
                }
                // MONITOREXIT : object
            } else {
                this.returnValue = -1;
                this.callback.enterInterrupt(frame, threadTitle, alertMessage);
                while (this.returnValue == -1) {
                    try {
                        this.callback.dispatchNextGuiEvent();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                returnValue = this.returnValue;
            }
            switch (returnValue) {
                case 0: {
                    contextData.breakNextLine = true;
                    contextData.stopAtFrameDepth = contextData.frameCount();
                    break;
                }
                case 1: {
                    contextData.breakNextLine = true;
                    contextData.stopAtFrameDepth = -1;
                    break;
                }
                case 2: {
                    if (contextData.frameCount() <= 1) break;
                    contextData.breakNextLine = true;
                    contextData.stopAtFrameDepth = contextData.frameCount() - 1;
                    break;
                }
                case 6: {
                    this.penddingResume = true;
                    break;
                }
            }
            Object object = this.eventThreadMonitor;
        }
        catch (Throwable throwable) {
            Object object = this.eventThreadMonitor;
            // MONITORENTER : object
            this.interruptedContextData = null;
            this.eventThreadMonitor.notifyAll();
            // MONITOREXIT : object
            throw throwable;
        }
        this.interruptedContextData = null;
        this.eventThreadMonitor.notifyAll();
        // MONITOREXIT : object
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object do_eval(Context cx, StackFrame frame, String expr) {
        Object ret;
        Debugger saved_debugger = cx.getDebugger();
        Object saved_data = cx.getDebuggerContextData();
        int saved_level = cx.getOptimizationLevel();
        cx.setDebugger(null, null);
        cx.setOptimizationLevel(-1);
        cx.setGeneratingDebug(false);
        try {
            Object result;
            Callable script = (Callable)cx.compileString(expr, "", 0, null);
            ret = result = script.call(cx, frame.scopeField, frame.thisObjField, ScriptRuntime.emptyArgs);
        }
        catch (Exception exc) {
            ret = exc.getMessage();
        }
        finally {
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(saved_level);
            cx.setDebugger(saved_debugger, saved_data);
        }
        return ret;
    }

    public static class SourceInfo {
        private static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
        private String sourceScript;
        private String urlOfScript;
        private boolean[] breakableLines;
        private boolean[] breakpoints;
        private FunctionSource[] functionSources;

        private SourceInfo(String source, DebuggableScript[] functions, String normilizedUrl) {
            int i;
            this.sourceScript = source;
            this.urlOfScript = normilizedUrl;
            int N = functions.length;
            int[][] lineArrays = new int[N][];
            for (int i2 = 0; i2 != N; ++i2) {
                lineArrays[i2] = functions[i2].getLineNumbers();
            }
            int minAll = 0;
            int maxAll = -1;
            int[] firstLines = new int[N];
            for (i = 0; i != N; ++i) {
                int max;
                int[] lines = lineArrays[i];
                if (lines == null || lines.length == 0) {
                    firstLines[i] = -1;
                    continue;
                }
                int min = max = lines[0];
                for (int j = 1; j != lines.length; ++j) {
                    int line = lines[j];
                    if (line < min) {
                        min = line;
                        continue;
                    }
                    if (line <= max) continue;
                    max = line;
                }
                firstLines[i] = min;
                if (minAll > maxAll) {
                    minAll = min;
                    maxAll = max;
                    continue;
                }
                if (min < minAll) {
                    minAll = min;
                }
                if (max <= maxAll) continue;
                maxAll = max;
            }
            if (minAll > maxAll) {
                this.breakableLines = EMPTY_BOOLEAN_ARRAY;
                this.breakpoints = EMPTY_BOOLEAN_ARRAY;
            } else {
                if (minAll < 0) {
                    throw new IllegalStateException(String.valueOf(minAll));
                }
                int linesTop = maxAll + 1;
                this.breakableLines = new boolean[linesTop];
                this.breakpoints = new boolean[linesTop];
                for (int i3 = 0; i3 != N; ++i3) {
                    int[] lines = lineArrays[i3];
                    if (lines == null || lines.length == 0) continue;
                    for (int j = 0; j != lines.length; ++j) {
                        int line = lines[j];
                        this.breakableLines[line] = true;
                    }
                }
            }
            this.functionSources = new FunctionSource[N];
            for (i = 0; i != N; ++i) {
                String name = functions[i].getFunctionName();
                if (name == null) {
                    name = "";
                }
                this.functionSources[i] = new FunctionSource(this, firstLines[i], name);
            }
        }

        public boolean[] getBreakpoints() {
            return this.breakpoints;
        }

        public String source() {
            return this.sourceScript;
        }

        public String url() {
            return this.urlOfScript;
        }

        public int functionSourcesTop() {
            return this.functionSources.length;
        }

        public FunctionSource functionSource(int i) {
            return this.functionSources[i];
        }

        private void copyBreakpointsFrom(SourceInfo old) {
            int end = old.breakpoints.length;
            if (end > this.breakpoints.length) {
                end = this.breakpoints.length;
            }
            for (int line = 0; line != end; ++line) {
                if (!old.breakpoints[line]) continue;
                this.breakpoints[line] = true;
            }
        }

        public boolean breakableLine(int line) {
            return line < this.breakableLines.length && this.breakableLines[line];
        }

        public boolean breakpoint(int line) {
            if (!this.breakableLine(line)) {
                throw new IllegalArgumentException(String.valueOf(line));
            }
            return line < this.breakpoints.length && this.breakpoints[line];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean breakpoint(int line, boolean value) {
            if (!this.breakableLine(line)) {
                throw new IllegalArgumentException(String.valueOf(line));
            }
            boolean[] blArray = this.breakpoints;
            synchronized (this.breakpoints) {
                boolean changed;
                if (this.breakpoints[line] != value) {
                    this.breakpoints[line] = value;
                    changed = true;
                } else {
                    changed = false;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return changed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllBreakpoints() {
            boolean[] blArray = this.breakpoints;
            synchronized (this.breakpoints) {
                for (int line = 0; line != this.breakpoints.length; ++line) {
                    this.breakpoints[line] = false;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public int calcMaxBreakpointLine() {
            for (int i = this.breakpoints.length; i >= 0; --i) {
                if (!this.breakpoints[i]) continue;
                return i;
            }
            return Integer.MIN_VALUE;
        }

        public boolean hasBreakpoint() {
            for (boolean b : this.breakpoints) {
                if (!b) continue;
                return true;
            }
            return false;
        }

        public int getLine() {
            return this.breakpoints.length - 1;
        }
    }

    public static class FunctionSource {
        private SourceInfo sourceInfoField;
        private int firstLineField;
        private String nameField;

        private FunctionSource(SourceInfo sourceInfo, int firstLine, String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.sourceInfoField = sourceInfo;
            this.firstLineField = firstLine;
            this.nameField = name;
        }

        public SourceInfo sourceInfo() {
            return this.sourceInfoField;
        }

        public int firstLine() {
            return this.firstLineField;
        }

        public String name() {
            return this.nameField;
        }
    }

    public static class StackFrame
    implements DebugFrame {
        private DIM dim;
        private ContextData contextDataField;
        private Scriptable scopeField;
        private Scriptable thisObjField;
        private FunctionSource fsource;
        private boolean[] breakpoints;
        private int lineNumber;
        private int breakPointLineNumber = -1;

        private StackFrame(Context cx, DIM dim, FunctionSource fsource) {
            this.dim = dim;
            this.contextDataField = ContextData.get(cx);
            this.fsource = fsource;
            this.breakpoints = fsource.sourceInfo().breakpoints;
            this.lineNumber = fsource.firstLine();
        }

        public void onEnter(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            this.contextDataField.pushFrame(this);
            this.scopeField = scope;
            this.thisObjField = thisObj;
            if (this.dim.breakOnEnter) {
                this.dim.handleBreakpointHit(this, cx);
            }
        }

        public void onLineChange(Context cx, int lineno) {
            this.lineNumber = lineno;
            if (!this.breakpoints[lineno] && !this.dim.breakFlag) {
                boolean lineBreak = this.contextDataField.breakNextLine;
                if (lineBreak && this.contextDataField.stopAtFrameDepth >= 0) {
                    boolean bl = lineBreak = this.contextDataField.frameCount() <= this.contextDataField.stopAtFrameDepth;
                }
                if (!lineBreak) {
                    if (this.dim.penddingResume) {
                        this.dim.penddingResume = false;
                        this.dim.callback.onResumed();
                    }
                    return;
                }
                this.contextDataField.stopAtFrameDepth = -1;
                this.contextDataField.breakNextLine = false;
            }
            this.dim.handleBreakpointHit(this, cx);
        }

        public void onExceptionThrown(Context cx, Throwable exception) {
            this.dim.handleExceptionThrown(cx, exception, this);
        }

        public void onExit(Context cx, boolean byThrow, Object resultOrException) {
            if (this.dim.breakOnReturn && this.contextDataField.breakNextLine && !byThrow) {
                this.dim.handleBreakpointHit(this, cx);
            }
            this.contextDataField.popFrame();
        }

        public void onDebuggerStatement(Context cx) {
            this.dim.handleBreakpointHit(this, cx);
        }

        public SourceInfo sourceInfo() {
            return this.fsource.sourceInfo();
        }

        public ContextData contextData() {
            return this.contextDataField;
        }

        public Object scope() {
            return this.scopeField;
        }

        public Object thisObj() {
            return this.thisObjField;
        }

        public String getUrl() {
            return this.fsource.sourceInfo().url();
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setBreakPointLineNumber(int breakPointLineNumber) {
            this.breakPointLineNumber = breakPointLineNumber;
        }

        public int getBreakPointLineNumber() {
            return this.breakPointLineNumber;
        }

        public String getFunctionName() {
            return this.fsource.name();
        }
    }

    public static class ContextData {
        private ObjArray frameStack = new ObjArray();
        private boolean breakNextLine;
        private int stopAtFrameDepth = -1;
        private boolean eventThreadFlag;
        private Throwable lastProcessedException;

        public static ContextData get(Context cx) {
            return (ContextData)cx.getDebuggerContextData();
        }

        public int frameCount() {
            return this.frameStack.size();
        }

        public StackFrame getFrame(int frameNumber) {
            int num = this.frameStack.size() - frameNumber - 1;
            return (StackFrame)this.frameStack.get(num);
        }

        private void pushFrame(StackFrame frame) {
            this.frameStack.push((Object)frame);
        }

        private void popFrame() {
            this.frameStack.pop();
        }
    }

    private static class DimIProxy
    implements ContextAction,
    ContextFactory.Listener,
    Debugger {
        private DIM dim;
        private int type;
        private String url;
        private String text;
        private Object object;
        private Object id;
        private boolean booleanResult;
        private String stringResult;
        private Object objectResult;
        private Object[] objectArrayResult;

        private DimIProxy(DIM dim, int type) {
            this.dim = dim;
            this.type = type;
        }

        public Object run(Context cx) {
            switch (this.type) {
                case 2: {
                    cx.compileString(this.text, this.url, 1, null);
                    break;
                }
                case 3: {
                    Scriptable scope = null;
                    if (this.dim.scopeProvider != null) {
                        scope = this.dim.scopeProvider.getScope();
                    }
                    if (scope == null) {
                        scope = new ImporterTopLevel(cx);
                    }
                    cx.evaluateString(scope, this.text, this.url, 1, null);
                    break;
                }
                case 4: {
                    this.booleanResult = cx.stringIsCompilableUnit(this.text);
                    break;
                }
                case 5: {
                    if (this.object == Undefined.instance) {
                        this.stringResult = "undefined";
                        break;
                    }
                    if (this.object == null) {
                        this.stringResult = "null";
                        break;
                    }
                    if (this.object instanceof NativeCall) {
                        this.stringResult = "[object Call]";
                        break;
                    }
                    this.stringResult = Context.toString((Object)this.object);
                    break;
                }
                case 6: {
                    this.objectResult = this.dim.getObjectPropertyImpl(cx, this.object, this.id);
                    break;
                }
                case 7: {
                    this.objectArrayResult = this.dim.getObjectIdsImpl(cx, this.object);
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
            return null;
        }

        private void withContext() {
            this.dim.contextFactory.call((ContextAction)this);
        }

        public void contextCreated(Context cx) {
            if (this.type != 1) {
                Kit.codeBug();
            }
            ContextData contextData = new ContextData();
            DimIProxy debugger = new DimIProxy(this.dim, 0);
            cx.setDebugger((Debugger)debugger, (Object)contextData);
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(-1);
        }

        public void contextReleased(Context cx) {
            if (this.type != 1) {
                Kit.codeBug();
            }
        }

        public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
            FunctionSource item;
            if (this.type != 0) {
                Kit.codeBug();
            }
            if ((item = this.dim.getFunctionSource(fnOrScript)) == null) {
                return null;
            }
            return new StackFrame(cx, this.dim, item);
        }

        public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
            if (this.type != 0) {
                Kit.codeBug();
            }
            if (!fnOrScript.isTopLevel()) {
                return;
            }
            this.dim.registerTopScript(fnOrScript, source);
        }
    }
}

