/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.debug;

import java.util.function.Function;
import kd.bos.script.debug.DebugThreadType;
import kd.bos.script.jsengine.debug.KDebugLog;
import kd.bos.script.util.ThreadLocalEx;

public class DebugIdThread {
    protected static ThreadGroup debugThreadGroup = new ThreadGroup("DEBUG");
    private static ThreadLocalEx<DebugContext> thDC = new ThreadLocalEx();

    public static void set(String debugId, DebugThreadType threadType) {
        boolean condition;
        DebugContext ctx = thDC.get();
        boolean bl = condition = ctx != null && ctx.debugId.equals(debugId) && ctx.threadType == threadType;
        if (!condition) {
            ctx = new DebugContext(debugId, threadType);
            thDC.set(ctx);
        }
    }

    public static String getDebugId() {
        DebugContext ctx = thDC.get();
        return ctx == null ? null : ctx.debugId;
    }

    public static DebugThreadType getDebugThreadType() {
        DebugContext ctx = thDC.get();
        return ctx == null ? null : ctx.threadType;
    }

    public static void remove() {
        DebugContext ctx = thDC.get();
        if (ctx != null) {
            thDC.remove();
        }
    }

    public static void remove(Thread t) {
        KDebugLog.info("DebugIdThread.remove thread: " + t);
        thDC.remove(t);
    }

    public static void remove(String debugId, Function<Thread, Void> onRemoved) {
        for (Thread t : thDC.keys()) {
            DebugContext ctx = thDC.get(t);
            if (ctx == null || !ctx.debugId.equals(debugId)) continue;
            KDebugLog.info("DebugIdThread.remove by debugId " + debugId + ": " + t);
            thDC.remove(t);
            if (onRemoved == null) continue;
            onRemoved.apply(t);
        }
    }

    private static class DebugContext {
        private String debugId;
        private DebugThreadType threadType;

        DebugContext(String debugId, DebugThreadType threadType) {
            this.debugId = debugId;
            this.threadType = threadType;
        }

        public String toString() {
            return (Object)((Object)this.threadType) + "-" + this.debugId;
        }
    }
}

