/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.debug;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class KBreakPoints {
    private Map<String, BreakPoint> breakPointMap = new ConcurrentHashMap<String, BreakPoint>();

    private BreakPoint getOrCreate(String scriptName) {
        BreakPoint bp = this.breakPointMap.get(scriptName);
        if (bp == null) {
            bp = new BreakPoint();
            this.breakPointMap.put(scriptName, bp);
        }
        return bp;
    }

    public void setupExecutingBreakPoints(String scriptName, boolean[] executing) {
        BreakPoint bp = this.getOrCreate(scriptName);
        BreakPoint.access$102(bp, executing);
        bp.trySyncToExecuting();
    }

    public void addBreakPoint(String scriptName, int ... breakPointLines) {
        BreakPoint bp = this.getOrCreate(scriptName);
        for (int b : breakPointLines) {
            bp.clientSetted.add(b);
        }
        bp.trySyncToExecuting();
    }

    public void removeBreakPoint(String scriptName, int ... breakPointLines) {
        BreakPoint bp = this.getOrCreate(scriptName);
        for (int b : breakPointLines) {
            bp.clientSetted.remove(b);
        }
        bp.trySyncToExecuting();
    }

    public void setBreakPoint(String scriptName, int ... breakPointLines) {
        BreakPoint bp = this.getOrCreate(scriptName);
        bp.clientSetted.clear();
        for (int b : breakPointLines) {
            bp.clientSetted.add(b);
        }
        bp.trySyncToExecuting();
    }

    public void clearBreakPoints(String scriptName) {
        BreakPoint bp = this.getOrCreate(scriptName);
        bp.clientSetted.clear();
        bp.trySyncToExecuting();
    }

    public void clearAllBreakPoints() {
        for (BreakPoint bp : this.breakPointMap.values()) {
            bp.clientSetted.clear();
            bp.trySyncToExecuting();
        }
    }

    private static class BreakPoint {
        private Set<Integer> clientSetted = new HashSet<Integer>();
        private boolean[] executing = null;

        private BreakPoint() {
        }

        private void trySyncToExecuting() {
            if (this.executing != null) {
                int n = this.executing.length;
                for (int i = 0; i < n; ++i) {
                    this.executing[i] = this.clientSetted.contains(i);
                }
            }
        }

        static /* synthetic */ boolean[] access$102(BreakPoint x0, boolean[] x1) {
            x0.executing = x1;
            return x1;
        }
    }
}

