/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.debug;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.script.ScriptException;
import kd.bos.script.debug.DebugCache;

class KDebugCache
implements DebugCache {
    private Map<String, Object> propMap = new HashMap<String, Object>();

    KDebugCache() {
    }

    @Override
    public Object get(String name) {
        return this.propMap.get(name.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String name, Object value) {
        Map<String, Object> map = this.propMap;
        synchronized (map) {
            if (value == null) {
                this.propMap.remove(name.toLowerCase());
            } else {
                this.propMap.put(name.toLowerCase(), value);
            }
        }
    }

    @Override
    public void close() throws ScriptException {
        for (Object value : this.propMap.values()) {
            if (!(value instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)value).close();
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
        }
        this.propMap.clear();
    }

    @Override
    public boolean clearViewCache(String scriptClassName) {
        List viewCacheIds = (List)this.get(scriptClassName);
        if (viewCacheIds != null) {
            for (String viewCacheId : viewCacheIds) {
                this.propMap.remove(viewCacheId);
            }
        }
        return true;
    }
}

