/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.debug;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.ScriptInfo;
import kd.bos.script.debug.DebugExecutor;
import kd.bos.script.debug.DebugManager;
import kd.bos.script.debug.DebugParameter;
import kd.bos.script.debug.DebugResult;
import kd.bos.script.debug.DebugStepBack;
import kd.bos.script.jsengine.debug.DIM;
import kd.bos.script.jsengine.debug.KDebugManager;
import kd.bos.script.jsengine.debug.KDebugTerminalHandler;
import kd.bos.script.jsengine.debug.KDebugUtil;
import kd.bos.script.jsengine.debug.KDebugVars;
import kd.bos.script.jsengine.debug.KDebugger;
import kd.bos.script.util.ScriptLookup;

public class KDebugExecutor
implements DebugExecutor {
    private String debugId;
    private ScriptLookup lookup;
    private DebugStepBack dcb;
    private KDebugManager dm;
    private KDebugger debugger;

    public KDebugExecutor(String debugId, ScriptLookup lookup, DebugStepBack dcb) {
        this.debugId = debugId;
        this.lookup = lookup;
        this.dcb = dcb;
    }

    public DebugManager getDebugManager() {
        return this.dm;
    }

    public void start(DebugManager dm, String[] preScriptNames, ScriptInfo scriptInfo, DebugParameter debugParam, String[] watches, boolean ignoreSystemScripts, ScriptExecutor executor, KDebugTerminalHandler terminalHandler) {
        this.dm = (KDebugManager)dm;
        try {
            List<ScriptInfo> scriptInfos;
            this.debugger = new KDebugger(this.debugId, debugParam, watches, this.dm, terminalHandler);
            if (!ignoreSystemScripts && this.lookup != null && (scriptInfos = this.lookup.getAllSystemScripts()) != null && scriptInfos.size() > 0) {
                executor.exec(scriptInfos.toArray(new ScriptInfo[scriptInfos.size()]));
            }
            if (preScriptNames != null && preScriptNames.length > 0) {
                executor.execName(preScriptNames);
            }
            this.debugger.enableBreak(true);
            executor.exec(scriptInfo);
        }
        catch (Exception e) {
            throw KDebugUtil.handleException(e);
        }
    }

    @Override
    public DebugResult stop() {
        this.debugger.setBreakOnReturn(false);
        return this.debugger.executeCmd("stop", () -> this.debugger.cmdStop());
    }

    @Override
    public DebugResult stepOver() {
        return this.debugger.executeCmd("stepOver", () -> this.debugger.cmdStepOver());
    }

    @Override
    public DebugResult stepInto() {
        return this.debugger.executeCmd("stepInto", () -> this.debugger.cmdStepInto());
    }

    @Override
    public DebugResult stepOut() {
        return this.debugger.executeCmd("stepOut", () -> this.debugger.cmdStepOut());
    }

    @Override
    public DebugResult resume() {
        this.debugger.cmdResume();
        DebugResult ret = new DebugResult();
        ret.setDebugId(this.debugId);
        ret.setRunning(true);
        ret.setSuccess(true);
        ret.setCurrentLine(-1);
        return this.handDebugResult(ret, false);
    }

    @Override
    public DebugResult runToLine(int lineNo) {
        return this.debugger.executeCmd("runToLine " + lineNo, () -> this.debugger.cmdRunToLine(lineNo));
    }

    @Override
    public DebugResult getAtBreakPoint(boolean waitFor) {
        DebugResult result = ((KDebugManager)this.debugger.getDebugManager()).takeDebugResult(waitFor);
        if (result == null) {
            result = new DebugResult();
            result.setDebugId(this.debugId);
            return result;
        }
        DebugResult ret = this.handDebugResult(result, false);
        return ret;
    }

    @Override
    public void addBreakPoint(int[] breakPointLines) {
        for (int line : breakPointLines) {
            this.debugger.addBreakPoint(line);
        }
    }

    @Override
    public void setBreakPoint(int[] breakPointLines) {
        this.debugger.setBreakPoint(breakPointLines);
    }

    @Override
    public void clearBreakPoints() {
        this.debugger.clearBreakPoint();
    }

    @Override
    public void removeBreakPoint(int[] breakPointLines) {
        for (int line : breakPointLines) {
            this.debugger.removeBreakPoint(line);
        }
    }

    @Override
    public void addWatch(String ... exps) {
        this.debugger.addWatch(exps);
    }

    @Override
    public void setWatch(String ... exps) {
        this.debugger.setWatch(exps);
    }

    @Override
    public void removeWatch(String ... exps) {
        this.debugger.removeWatch(exps);
    }

    @Override
    public void clearWatches() {
        this.debugger.clearWatches();
    }

    @Override
    public DebugResult getWatches() {
        return this.handDebugResult(KDebugVars.buildWatches(this.debugger, this.debugger.getStackFrame()), false);
    }

    @Override
    public DebugResult getVariables() {
        return this.handDebugResult(KDebugVars.buildVariables(this.debugger, this.debugger.getStackFrame()), false);
    }

    @Override
    public DebugResult evaluate(String expression) {
        DebugResult result = new DebugResult();
        result.setDebugId(this.debugId);
        result.setSuccess(true);
        Object value = KDebugVars.resolveEvaluate(expression, this.debugger);
        result.setValue(value);
        return this.handDebugResult(result, false);
    }

    DebugResult handDebugResult(DebugResult ret, boolean put2DebugStepBack) {
        DIM.SourceInfo si = this.dm.getCurrentSourceInfo();
        if (si != null) {
            ret.setScriptName(si.url());
        }
        if (!ret.isRunning()) {
            this.dm.stopped();
        }
        if (this.dcb != null && put2DebugStepBack) {
            this.dcb.onStepBack(ret, this);
        }
        return ret;
    }

    public boolean hasSourceInfo() {
        return this.debugger.getCurrentSourceInfo() != null;
    }

    @Override
    public <V> V inspect(Callable<V> callable, Supplier<String> callableInfoSupplier) {
        try {
            return DebugManager.inspectAtDebugMainThread(this.debugId, callable, callableInfoSupplier);
        }
        catch (Exception e) {
            KDebugUtil.handleException(e);
            return null;
        }
    }
}

