/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.debug;

import kd.bos.script.ScriptException;
import kd.bos.script.debug.DebugManager;
import kd.bos.script.debug.DebugResult;
import kd.bos.script.jsengine.debug.DIM;
import kd.bos.script.jsengine.debug.DebugMainThread;
import kd.bos.script.jsengine.debug.KDebugExecutor;
import kd.bos.script.jsengine.debug.KDebugVars;
import kd.bos.script.jsengine.debug.KDebugger;
import kd.bos.util.resource.Resources;

class KStackFrame {
    private volatile DebugResult debugResult = null;
    private DIM.StackFrame debugFrame;
    private KDebugger debugger;

    KStackFrame(DIM.StackFrame debugFrame, KDebugger debugger) {
        this.debugFrame = debugFrame;
        this.debugger = debugger;
        this.debugResult = KDebugVars.buildAll(debugger, this);
        ((KDebugExecutor)debugger.getDebugExecutor()).handDebugResult(this.debugResult, true);
    }

    void pause() {
        try {
            DebugManager.getDebugMainThread(this.debugger.getDebugId()).pause();
        }
        catch (InterruptedException e) {
            this.handleInterrupted(e);
        }
        this.debugger.clearStep();
    }

    DebugResult getDebugResult() {
        return this.debugResult;
    }

    public DIM.StackFrame getDebugFrame() {
        return this.debugFrame;
    }

    void resume() {
        DebugMainThread dt = DebugManager.getDebugMainThread(this.debugger.getDebugId());
        if (dt != null) {
            dt.resume();
        }
    }

    public String toString() {
        return this.debugFrame.toString();
    }

    private void handleInterrupted(InterruptedException e) {
        if (!this.debugger.isStopped()) {
            throw new ScriptException(String.format(Resources.getString((String)"\u811a\u672c\u8c03\u8bd5\u7b49\u5f85\u8d85\u65f6(%1$ss)\u6216\u7ec8\u6b62\u8c03\u8bd5:%1$s", (String)"KStackFrame_0", (String)"bos-serverscript", (Object[])new Object[0]), 600L, e.getMessage()));
        }
    }
}

