/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.def;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.script.ScriptConfig;
import kd.bos.script.ScriptException;
import kd.bos.script.ScriptObject;
import kd.bos.script.ScriptSecurityMode;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.jsengine.KContext;
import kd.bos.script.jsengine.KRuntime;
import kd.bos.script.jsengine.KRuntimeException;
import kd.bos.script.jsengine.def.JSFunctionImpl;
import kd.bos.script.jsengine.def.JSStaticFunctionImpl;
import kd.bos.script.jsengine.def.KDyTypeCache;
import kd.bos.script.jsengine.def.KDyWrapper;
import kd.bos.script.jsengine.def.KDyWrapperFunctionCaller;
import kd.bos.script.jsengine.def.KDyWrapperInfoImpl;
import kd.bos.script.jsengine.def.KDyWrapperIntercept;
import kd.bos.script.jsengine.def.PrototypeIdMap;
import kd.bos.script.jsengine.def.typemap.KJsType;
import kd.bos.util.resource.Resources;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSStaticFunction;

public class KDyDefine {
    private static ElementMatcher<? super MethodDescription> funcAnnotation = ElementMatchers.isPublic().and((ElementMatcher)ElementMatchers.isAnnotatedWith(KSMethod.class));
    private static ElementMatcher<? super MethodDescription> staticFuncAnnotation = ElementMatchers.isPublic().and((ElementMatcher)ElementMatchers.isStatic()).and((ElementMatcher)ElementMatchers.isAnnotatedWith(KSMethod.class));
    private static JSFunction jsFuncAnnotation = new JSFunctionImpl();
    private static JSStaticFunction jsStaticFuncAnnotation = new JSStaticFunctionImpl();
    private static final Map<Class<?>, Set<String>> clsKSMethodMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void defineClassProxy(Scriptable scope, String namespace, Class<?> cls) throws ScriptException {
        try {
            Map<Class<?>, Class<Scriptable>> dyClsMap;
            Class<Scriptable> dynamicType;
            String jsType = KJsType.getJSTypeName(cls);
            if (scope.has(jsType, scope)) {
                return;
            }
            if (namespace == null) {
                namespace = "";
            }
            if ((dynamicType = (dyClsMap = KDyTypeCache.getDyClsMap()).get(cls)) == null) {
                Map<Class<?>, Class<Scriptable>> map = dyClsMap;
                synchronized (map) {
                    dynamicType = dyClsMap.get(cls);
                    if (dynamicType == null) {
                        String dynamicClassName = "__SDK_GEN__" + namespace.replace('.', '_') + "$" + cls.getSimpleName();
                        dynamicType = KDyDefine.genSubClass(cls, namespace, dynamicClassName);
                        KDyDefine.cacheIdFunction(cls, dynamicType, scope);
                        dyClsMap.put(cls, dynamicType);
                    }
                }
            }
            KDyDefine.ensureExported(jsType, cls, dynamicType, scope);
        }
        catch (Exception e) {
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            throw new ScriptException(e);
        }
    }

    private static Class<Scriptable> genSubClass(Class<?> cls, String namespace, String dynamicClassName) {
        String className = KJsType.getJSTypeName(cls);
        ArrayList clsList = new ArrayList();
        if (!ScriptObject.class.isAssignableFrom(cls)) {
            clsList.add(ScriptObject.class);
        }
        clsList.addAll(Arrays.asList(cls.getInterfaces()));
        if (cls.isInterface()) {
            clsList.add(cls);
        }
        MethodDelegation methodDelegate = MethodDelegation.to(KDyWrapperIntercept.class);
        DynamicType.Builder bb = new ByteBuddy().subclass(KDyWrapper.class).name(dynamicClassName);
        ArrayList<Annotation> annotateTypeList = new ArrayList<Annotation>(Arrays.asList(cls.getAnnotations()));
        annotateTypeList.add(new KDyWrapperInfoImpl(cls));
        bb = bb.annotateType(annotateTypeList.toArray(new Annotation[annotateTypeList.size()]));
        bb = bb.implement(clsList).intercept((Implementation)methodDelegate);
        Class genCls = bb.method(funcAnnotation).intercept((Implementation)methodDelegate).annotateMethod(new Annotation[]{jsFuncAnnotation}).method(staticFuncAnnotation).intercept((Implementation)methodDelegate).annotateMethod(new Annotation[]{jsStaticFuncAnnotation}).method((ElementMatcher)ElementMatchers.named((String)"getNamespace")).intercept((Implementation)FixedValue.value((Object)namespace)).method((ElementMatcher)ElementMatchers.named((String)"getClassName")).intercept((Implementation)FixedValue.value((Object)className)).method((ElementMatcher)ElementMatchers.named((String)"getNativeClass")).intercept((Implementation)FixedValue.value(cls)).make().load(KContext.get().getClassLoader()).getLoaded();
        return genCls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureExported(String jsType, Class<?> cls, Class<Scriptable> dynamicType, Scriptable scope) throws ScriptException {
        try {
            boolean exported = scope.has(jsType, scope);
            if (exported) {
                return;
            }
            Class<Scriptable> clazz = dynamicType;
            synchronized (clazz) {
                Set<Class<Scriptable>> exportedDyClsSet;
                exported = scope.has(jsType, scope);
                if (exported) {
                    return;
                }
                PrototypeIdMap idMap = KDyTypeCache.getDyClsIdMap().get(dynamicType);
                KDyWrapper proxy = (KDyWrapper)dynamicType.newInstance();
                boolean definingInnerClass = KContext.get().isDefiningInnerClass();
                if (KJsType.isJsReservedClassName(jsType) && !definingInnerClass) {
                    throw new KRuntimeException(Resources.getString((String)"JS\u7c7b\u540d\u4e0d\u53ef\u4f7f\u7528\u4fdd\u7559\u540d\u79f0\uff1a", (String)"KDyDefine_0", (String)"bos-serverscript", (Object[])new Object[0]) + proxy.getClassName());
                }
                IdFunctionObject jsDefineObj = proxy.exportAsJSClass(idMap.maxPrototypeId(), scope, false);
                if (cls.isEnum()) {
                    int attr = 5;
                    for (Object em : cls.getEnumConstants()) {
                        jsDefineObj.defineProperty(((Enum)em).name(), (Object)KJsType.java2js(em, scope), 5);
                    }
                }
                Set<Class<Scriptable>> set = exportedDyClsSet = KDyTypeCache.getExportedDyClsSet();
                synchronized (set) {
                    exportedDyClsSet.add(dynamicType);
                }
                if (!definingInnerClass) {
                    KJsType.registUserType(cls);
                }
            }
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    private static void cacheIdFunction(Class<?> cls, Class<?> dynamicType, Scriptable scope) throws ScriptException {
        try {
            Map<Class<?>, PrototypeIdMap> dyClsIdMap = KDyTypeCache.getDyClsIdMap();
            PrototypeIdMap idMap = new PrototypeIdMap();
            HashMap<String, List<Method>> functionMap = new HashMap<String, List<Method>>();
            dyClsIdMap.put(dynamicType, idMap);
            idMap.add("constructor", 0);
            idMap.add("getClassName", 0);
            idMap.add("getNamespace", 0);
            idMap.add("getNativeClass", 0);
            Method[] methods = cls.getMethods();
            for (Method method : methods) {
                if (!KDyDefine.canExport(method)) continue;
                String name = method.getName();
                if (!idMap.has(name)) {
                    idMap.add(name, method.getParameterTypes().length);
                }
                if (!functionMap.containsKey(name)) {
                    functionMap.put(name, new ArrayList());
                }
                ((List)functionMap.get(name)).add(method);
            }
            for (List ms : functionMap.values()) {
                KRuntime.sortMatchMethod(ms);
            }
            KDyTypeCache.getDyClsFunctionCallerMap().put(dynamicType, new KDyWrapperFunctionCaller(dynamicType, cls, functionMap));
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public static boolean canExport(Field field) {
        return true;
    }

    public static boolean canExport(Method method) {
        String methodKey = KDyDefine.genMethodKey(method.getName(), method.getParameterTypes());
        try {
            return KDyDefine.allowMethodWithSuperDeclared(method.getDeclaringClass(), methodKey, new HashSet());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String genMethodKey(String name, Class<?>[] parameterTypes) {
        if (parameterTypes.length == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name);
        sb.append('#');
        for (Class<?> cls : parameterTypes) {
            sb.append(cls).append(',');
        }
        return sb.toString();
    }

    private static boolean allowMethodWithSuperDeclared(Class<?> cls, String methodKey, Set<Class<?>> searchedClassSet) throws ScriptException {
        try {
            if (cls == null || searchedClassSet.contains(cls)) {
                return false;
            }
            if (KDyDefine.allowMethod(cls, methodKey)) {
                return true;
            }
            searchedClassSet.add(cls);
            if (cls.isInterface()) {
                if (KDyDefine.allowMethodWithSuperDeclared(cls.getSuperclass(), methodKey, searchedClassSet)) {
                    return true;
                }
            } else {
                for (Class<?> icls : cls.getInterfaces()) {
                    if (!KDyDefine.allowMethodWithSuperDeclared(icls, methodKey, searchedClassSet)) continue;
                    return true;
                }
                if (KDyDefine.allowMethodWithSuperDeclared(cls.getSuperclass(), methodKey, searchedClassSet)) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            throw new ScriptException(e);
        }
    }

    private static boolean allowMethod(Class<?> cls, String methodKey) {
        return clsKSMethodMap.computeIfAbsent(cls, cls2 -> {
            Method[] methods;
            HashSet<String> set = new HashSet<String>();
            for (Method method : methods = cls.getDeclaredMethods()) {
                if (!KDyDefine.allowMethod(cls, method)) continue;
                set.add(KDyDefine.genMethodKey(method.getName(), method.getParameterTypes()));
            }
            return set;
        }).contains(methodKey);
    }

    private static boolean allowMethod(Class<?> cls, Method method) {
        if (ScriptConfig.getScriptSecurityMode() == ScriptSecurityMode.NOLIMIT) {
            return true;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (ScriptConfig.isForbiddenBySecurity(cls.getName())) {
            return false;
        }
        if (ScriptConfig.isAllowedBySecurity(cls.getName())) {
            return true;
        }
        String name = method.getName();
        if (cls.isEnum() && "name".equals(name)) {
            return true;
        }
        String pk = cls.getPackage().getName() + '.';
        if (cls.isInterface() && pk.startsWith("java.")) {
            return true;
        }
        if (pk.startsWith("java.io.") || pk.startsWith("java.nio.") || pk.startsWith("java.lang.instrument.") || pk.startsWith("java.lang.invoke.") || pk.startsWith("java.lang.reflect.") || pk.startsWith("java.lang.management.")) {
            return false;
        }
        if (cls == Class.class) {
            return "getName".equals(name) || "toString".equals(name);
        }
        if (cls == Object.class) {
            return "getClass".equals(name) || "getName".equals(name) || "hashCode".equals(name) || "equals".equals(name) || "toString".equals(name);
        }
        if (cls == URL.class) {
            return !name.startsWith("open");
        }
        if (ClassLoader.class.isAssignableFrom(cls)) {
            return !name.startsWith("getResource");
        }
        if (ScriptConfig.isStrictMode()) {
            return method.getAnnotation(KSMethod.class) != null;
        }
        return true;
    }
}

