/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.def;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.script.jsengine.KRuntime;
import kd.bos.script.jsengine.def.KConstructor;
import kd.bos.script.jsengine.def.KDyWrapper;
import kd.bos.script.jsengine.def.typemap.KJsType;
import kd.bos.util.resource.Resources;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

class KDyWrapperFunctionCaller {
    private static final String[] sealFunctions = new String[]{"constructor", "getClassName", "getNamespace", "getNativeClass"};
    private final Class<? extends KDyWrapper> wrapperCls;
    private final Class<?> beanCls;
    private final String className;
    private final Map<String, List<Method>> functionMap;
    private final Map<String, Callable> functionCallableMap = new HashMap<String, Callable>(128);

    KDyWrapperFunctionCaller(Class<? extends KDyWrapper> wrapperCls, Class<?> beanCls, Map<String, List<Method>> functionMap) {
        this.wrapperCls = wrapperCls;
        this.beanCls = beanCls;
        this.className = KJsType.getJSTypeName(beanCls);
        this.functionMap = functionMap;
        for (final String name : functionMap.keySet()) {
            this.functionCallableMap.put(name, new Callable(){

                public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    return KDyWrapperFunctionCaller.this.doCall(name, cx, scope, thisObj, args);
                }
            });
        }
        for (final String name : sealFunctions) {
            this.functionCallableMap.put(name, new Callable(){

                public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    return KDyWrapperFunctionCaller.this.doCall(name, cx, scope, thisObj, args);
                }
            });
        }
    }

    Callable getCallable(String name) {
        return this.functionCallableMap.get(name);
    }

    Object call(String name, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Callable callable = this.getCallable(name);
        if (callable == null) {
            throw new IllegalArgumentException(this.className + Resources.getString((String)"\u65b9\u6cd5", (String)"KDyWrapperFunctionCaller_0", (String)"bos-serverscript", (Object[])new Object[0]) + name + Resources.getString((String)"\u4e0d\u5b58\u5728, args=", (String)"KDyWrapperFunctionCaller_1", (String)"bos-serverscript", (Object[])new Object[0]) + Arrays.toString(args));
        }
        return callable.call(cx, scope, thisObj, args);
    }

    private Object doCall(String name, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        try {
            List<Method> methods = this.functionMap.get(name);
            if (methods != null) {
                java.util.concurrent.Callable<?> callable;
                if (thisObj instanceof NativeObject) {
                    thisObj = ((NativeObject)thisObj).getPrototype();
                }
                if (args != null) {
                    int i = 0;
                    for (Object arg : args) {
                        args[i++] = KJsType.js2java(arg);
                    }
                }
                if ((callable = KRuntime.matchMethod(((KDyWrapper)thisObj).beanObj, methods, args, thisObj, cx)) == null) {
                    throw new IllegalArgumentException(name + Resources.getString((String)"\u65b9\u6cd5\u53c2\u6570\u4e0d\u5339\u914d\uff1a", (String)"KDyWrapperFunctionCaller_2", (String)"bos-serverscript", (Object[])new Object[0]) + Arrays.toString(args));
                }
                return callable.call();
            }
            if ("constructor".equals(name)) {
                return KConstructor.construct(this.className, this.wrapperCls, this.beanCls, args, cx);
            }
            if ("getClassName".equals(name)) {
                return ((KDyWrapper)thisObj).getClassName();
            }
            if ("getNamespace".equals(name)) {
                return ((KDyWrapper)thisObj).getNamespace();
            }
            if ("getNativeClass".equals(name)) {
                return ((KDyWrapper)thisObj).getNativeClass();
            }
            throw new IllegalArgumentException(this.className + Resources.getString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u65b9\u6cd5", (String)"KDyWrapperFunctionCaller_3", (String)"bos-serverscript", (Object[])new Object[0]) + name + "\u3002");
        }
        catch (Exception e) {
            throw KRuntime.wrapRuntimeException(e);
        }
    }

    Map<String, List<Method>> getFunctionMap() {
        return this.functionMap;
    }
}

