/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.def.typemap;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.script.ScriptClassInfo;
import kd.bos.script.ScriptException;
import kd.bos.script.ScriptFunction;
import kd.bos.script.ScriptWrapper;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.script.annotations.KSWrapper;
import kd.bos.script.jsengine.KContext;
import kd.bos.script.jsengine.KRuntime;
import kd.bos.script.jsengine.KRuntimeException;
import kd.bos.script.jsengine.debug.KKeys;
import kd.bos.script.jsengine.def.KDyTypeCache;
import kd.bos.script.jsengine.def.KDyWrapper;
import kd.bos.script.jsengine.def.KDyWrapperInfo;
import kd.bos.script.jsengine.def.KObjectConverter;
import kd.bos.script.jsengine.def.typemap.JSPrimitiveTypeMap;
import kd.bos.script.jsengine.def.typemap.KSObjectTypeMap;
import kd.bos.script.jsengine.def.typemap.KScriptObjectGenericResolver;
import kd.bos.util.resource.Resources;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.Wrapper;

public final class KJsType {
    private static final Map<Class<?>, String> nameMap = new ConcurrentHashMap(16);
    private static Set<String> jsReservedClassNameSet = new HashSet<String>(KKeys.js_reserved_class_names);

    public static void registUserType(Class<?> ksObjectCls) {
        KSObjectTypeMap.registUserType(ksObjectCls, KJsType.getJavaStandardType(ksObjectCls), KJsType.getJSTypeName(ksObjectCls));
    }

    public static Object js2java(Object value, Class<?> desiredType) {
        if ((value = KJsType.js2java(value)) == null || desiredType == null || value.getClass() == desiredType || desiredType.isPrimitive() && KObjectConverter.getObjectType(desiredType) == value.getClass()) {
            return value;
        }
        if (desiredType.isEnum()) {
            try {
                Method method = desiredType.getMethod("valueOf", String.class);
                method.setAccessible(true);
                return method.invoke(null, value);
            }
            catch (Exception e) {
                throw new RuntimeException(Resources.getString((String)"\u5b57\u7b26\u4e32\u8f6c\u6362\u679a\u4e3e\u7c7b\u578b\uff1a", (String)"KJsType_0", (String)"bos-serverscript", (Object[])new Object[0]) + desiredType.getClass().getName() + Resources.getString((String)"\u5931\u8d25:", (String)"KJsType_1", (String)"bos-serverscript", (Object[])new Object[0]) + e.getMessage(), e);
            }
        }
        if (!desiredType.isAssignableFrom(value.getClass())) {
            if (KObjectConverter.isNumber(desiredType)) {
                return KObjectConverter.toTypedObject(desiredType, value);
            }
            value = Context.original_jsToJava((Object)value, desiredType);
        }
        return value;
    }

    public static Object js2java(Object value) {
        if (value == null || value == Undefined.instance || value == UniqueTag.NOT_FOUND || value == UniqueTag.NULL_VALUE) {
            return null;
        }
        if (value instanceof ConsString) {
            return ((ConsString)value).toString();
        }
        if (value instanceof Function) {
            return KJsType.convert2ScriptFunction((Function)value);
        }
        if (value instanceof ScriptWrapper) {
            return ((ScriptWrapper)value).unwrap();
        }
        if (value instanceof Wrapper) {
            return ((Wrapper)value).unwrap();
        }
        if (value instanceof Scriptable) {
            Scriptable jsObj = (Scriptable)value;
            return JSPrimitiveTypeMap.try2JavaObject(jsObj);
        }
        return value;
    }

    public static Scriptable java2js(Object value, Scriptable scope) {
        if (value == null) {
            return null;
        }
        if (value instanceof Scriptable) {
            return (Scriptable)value;
        }
        Class<?> cls = value.getClass();
        KSWrapper wrapper = cls.getAnnotation(KSWrapper.class);
        if (wrapper != null) {
            value = KJsType.createJSWrapper(wrapper, value);
        } else {
            Object cvalue = KSObjectTypeMap.try2KSObject(value);
            if (cvalue != value) {
                return (Scriptable)cvalue;
            }
        }
        return Context.toObject((Object)value, (Scriptable)scope);
    }

    private static Object createJSWrapper(KSWrapper wrapper, Object javaObj) {
        try {
            Class<?> jsObjClass = Class.forName(wrapper.className());
            for (Constructor<?> constructor : jsObjClass.getConstructors()) {
                if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(javaObj.getClass())) continue;
                return constructor.newInstance(javaObj);
            }
            throw new RuntimeException(String.format(Resources.getString((String)"%1$s\u65e0\u53c2\u6570\u7c7b\u578b\u4e3a\uff1a%2$s\u7684\u6784\u9020\u51fd\u6570.", (String)"KJsType_2", (String)"bos-serverscript", (Object[])new Object[0]), wrapper.className(), javaObj.getClass().getName()));
        }
        catch (Exception e) {
            throw KRuntime.wrapRuntimeException(e);
        }
    }

    public static Scriptable wrapAsJavaObject(Object value, Scriptable scope, Class<?> staticType) {
        if (value instanceof Scriptable) {
            return (Scriptable)value;
        }
        KSObject dt = value.getClass().getAnnotation(KSObject.class);
        if (dt != null) {
            try {
                return (Scriptable)KDyWrapper.createJsDyWrapper(value);
            }
            catch (Exception e) {
                throw new KRuntimeException("Auto wrap " + value + " error: " + e.getMessage());
            }
        }
        Object cvalue = KSObjectTypeMap.try2KSObject(value);
        if (cvalue != value) {
            return (Scriptable)cvalue;
        }
        if (!KJsType.allowedNoneKSObjectJavaCls(value.getClass())) {
            throw new KRuntimeException("[Safe Model] Not supported none KSObject @type=" + value.getClass().getName() + ": " + value);
        }
        return new NativeJavaObject(scope, value, null);
    }

    private static boolean allowedNoneKSObjectJavaCls(Class<?> cls) {
        if (KContext.get().isSafeModel()) {
            return cls == ScriptException.class || cls == KRuntimeException.class || cls.getName().startsWith("org.mozilla.javascript.") || cls.getName().startsWith("com.sun.proxy.");
        }
        return true;
    }

    public static Scriptable java2jsClass(Scriptable scope, Class<?> javaClass) {
        return new NativeJavaClass(scope, javaClass);
    }

    private static ScriptFunction convert2ScriptFunction(final Function func) {
        if (func instanceof ScriptFunction) {
            return (ScriptFunction)func;
        }
        ArrayList interfaces = new ArrayList();
        interfaces.add(ScriptFunction.class);
        interfaces.addAll(Arrays.asList(func.getClass().getInterfaces()));
        return (ScriptFunction)Proxy.newProxyInstance(func.getClass().getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (ScriptFunction.isCallMethod(method)) {
                    return func.call((Context)KContext.get(), func.getParentScope(), (Scriptable)func, args == null ? null : (Object[])args[0]);
                }
                if (ScriptFunction.isGetNativeFunctionMethod(method)) {
                    return func;
                }
                return method.invoke((Object)func, args);
            }
        });
    }

    public static boolean isJsReservedClassName(String jsClassName) {
        return jsReservedClassNameSet.contains(jsClassName);
    }

    public static boolean isKSObjectType(Class<?> ksObjectCls) {
        return ksObjectCls.getAnnotation(KSObject.class) != null;
    }

    public static boolean isKSObjectMethod(Method m) {
        return m.getAnnotation(KSMethod.class) != null;
    }

    public static String getJSTypeName(Class<?> ksObjectCls) {
        KSObject dt;
        String name = nameMap.get(ksObjectCls);
        if (name != null) {
            return name;
        }
        if (ksObjectCls.getSuperclass() == KDyWrapper.class) {
            try {
                ksObjectCls = ((KDyWrapper)ksObjectCls.newInstance()).getNativeClass();
            }
            catch (Exception e) {
                throw new KRuntimeException(e);
            }
        }
        name = (dt = ksObjectCls.getAnnotation(KSObject.class)) != null && dt.name().trim().length() > 0 ? dt.name().trim() : ksObjectCls.getSimpleName();
        nameMap.put(ksObjectCls, name);
        return name;
    }

    public static String getJSNameSpace(Class<?> ksObjectCls) {
        KSObject dt;
        if (ksObjectCls.getSuperclass() == KDyWrapper.class) {
            try {
                ksObjectCls = ((KDyWrapper)ksObjectCls.newInstance()).getNativeClass();
            }
            catch (Exception e) {
                throw new KRuntimeException(e);
            }
        }
        if ((dt = ksObjectCls.getAnnotation(KSObject.class)) != null) {
            return dt.namespace().trim();
        }
        return ksObjectCls.getPackage() == null ? "" : ksObjectCls.getPackage().getName();
    }

    private static Class<?> getJavaStandardType(Class<?> ksObjectCls) {
        KSObject dt;
        if (ksObjectCls.getSuperclass() == KDyWrapper.class) {
            try {
                ksObjectCls = ((KDyWrapper)ksObjectCls.newInstance()).getNativeClass();
            }
            catch (Exception e) {
                throw new KRuntimeException(e);
            }
        }
        return (dt = ksObjectCls.getAnnotation(KSObject.class)) == null ? ksObjectCls : KScriptObjectGenericResolver.getScriptWrapperGT(ksObjectCls, ksObjectCls);
    }

    public static Set<ScriptClassInfo> getDefinedClasses(boolean withUnPublish) {
        HashSet<ScriptClassInfo> set = new HashSet<ScriptClassInfo>();
        for (JSPrimitiveTypeMap.Js2Java js2Java : new HashSet<JSPrimitiveTypeMap.Js2Java>(JSPrimitiveTypeMap.js2JavaMap.values())) {
            ScriptClassInfo si = js2Java.getScriptClass();
            if (!withUnPublish && !si.isPublishing()) continue;
            set.add(si);
        }
        for (Class clazz : new HashSet<Class<Scriptable>>(KDyTypeCache.getExportedDyClsSet())) {
            KSObject ks = clazz.getAnnotation(KSObject.class);
            if (ks == null || !withUnPublish && !ks.publishing()) continue;
            ScriptClassInfo si = new ScriptClassInfo();
            si.setName(ks.name());
            si.setDescription(ks.description());
            KDyWrapperInfo wi = clazz.getAnnotation(KDyWrapperInfo.class);
            if (wi != null) {
                si.setJavaClassName(wi.wrappedCls().getName());
            } else {
                si.setJavaClassName(clazz.getName());
            }
            si.setNamespace(ks.namespace());
            si.setPublishing(ks.publishing());
            si.setPrimitive(false);
            set.add(si);
        }
        return set;
    }
}

