/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.def.typemap;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import kd.bos.script.ScriptWrapper;
import kd.bos.script.jsengine.KRuntimeException;
import kd.bos.script.jsengine.def.KDyTypeCache;
import kd.bos.util.resource.Resources;

class KScriptObjectGenericResolver {
    KScriptObjectGenericResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getScriptWrapperGT(Class<?> cls, Class<?> defaultCls) {
        Map<Class<?>, Class<?>> cache = KDyTypeCache.getScriptObjectGenericMap();
        Class gtType = cache.get(cls);
        if (gtType == null) {
            Map<Class<?>, Class<?>> map = cache;
            synchronized (map) {
                gtType = cache.get(cls);
                if (gtType == null) {
                    TypeInfo ti = KScriptObjectGenericResolver.getScriptWrapperGTInfo(cls);
                    gtType = ti == null ? defaultCls : ti.type;
                    cache.put(cls, gtType);
                }
            }
        }
        return gtType;
    }

    private static TypeInfo getScriptWrapperGTInfo(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        boolean atThisCls = false;
        for (Class<?> icls : cls.getInterfaces()) {
            if (icls != ScriptWrapper.class) continue;
            atThisCls = true;
            break;
        }
        if (atThisCls) {
            return KScriptObjectGenericResolver.findOnCurrentCls(cls);
        }
        TypeInfo ti = KScriptObjectGenericResolver.getScriptWrapperGTInfo(cls.getSuperclass());
        if (ti != null) {
            return KScriptObjectGenericResolver.findOnFatherCls(cls, ti);
        }
        return null;
    }

    private static TypeInfo findOnCurrentCls(Class<?> cls) {
        for (Type gt : cls.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(gt instanceof ParameterizedType) || (pt = (ParameterizedType)gt).getRawType() != ScriptWrapper.class) continue;
            Type[] gts = pt.getActualTypeArguments();
            if (gts.length == 0) {
                return null;
            }
            return KScriptObjectGenericResolver.tryGetTypeInfo(cls, gts[0]);
        }
        return null;
    }

    private static TypeInfo findOnFatherCls(Class<?> cls, TypeInfo ti) {
        ParameterizedType pt;
        Type find;
        TypeInfo sti;
        if (ti.gtIndex == -1) {
            return ti;
        }
        Type type = cls.getGenericSuperclass();
        if (type != null && (sti = KScriptObjectGenericResolver.tryGetTypeInfo(cls, find = (pt = (ParameterizedType)type).getActualTypeArguments()[ti.gtIndex])) != null) {
            return sti;
        }
        return ti;
    }

    private static TypeInfo tryGetTypeInfo(Class<?> cls, Type find) {
        if (find instanceof TypeVariable) {
            return KScriptObjectGenericResolver.tryGetTypeInfoByTypeVariable(cls, (TypeVariable)find);
        }
        if (find instanceof ParameterizedType) {
            find = ((ParameterizedType)find).getRawType();
        }
        return new TypeInfo((Class)find, -1);
    }

    private static TypeInfo tryGetTypeInfoByTypeVariable(Class<?> cls, TypeVariable<?> find) {
        String typeName = find.getTypeName();
        int i = 0;
        for (TypeVariable<Class<?>> tv : cls.getTypeParameters()) {
            if (tv.getName().equals(typeName)) {
                if (tv.getBounds().length > 1) {
                    throw new KRuntimeException(String.format(Resources.getString((String)"%1$s\u4e2d\u5e94\u660e\u786e%2$s\u7684\u6cdb\u578b\u7c7b\u578b\uff0c\u4e0d\u80fd\u6709\u591a\u4e2asupper\u3002", (String)"KScriptObjectGenericResolver_0", (String)"bos-serverscript", (Object[])new Object[0]), cls.getName(), ScriptWrapper.class.getName()));
                }
                Type findGT = tv.getBounds()[0];
                if (findGT instanceof ParameterizedType) {
                    findGT = ((ParameterizedType)findGT).getRawType();
                }
                return new TypeInfo((Class)findGT, i);
            }
            ++i;
        }
        return null;
    }

    static class TypeInfo {
        private Class<?> type;
        private int gtIndex;

        TypeInfo(Class<?> type, int gtIndex) {
            this.type = type;
            this.gtIndex = gtIndex;
        }
    }
}

