/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.objects;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.script.ScriptWrapper;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.script.jsengine.KBigDecimalScale;
import kd.bos.script.jsengine.def.KObjectConverter;
import kd.bos.util.resource.Resources;
import org.mozilla.javascript.KNumberOperation;
import org.mozilla.javascript.ScriptRuntime;

@KSObject(name="BigDecimal", namespace="")
public class KBigDecimalObject
implements ScriptWrapper<BigDecimal> {
    private BigDecimal value = BigDecimal.ZERO;
    private static final Map<String, Integer> roundingModeMap = new HashMap<String, Integer>(10);

    public KBigDecimalObject() {
    }

    public KBigDecimalObject(Object value) {
        if (value == null) {
            this.value = null;
        } else {
            Class<?> cls = value.getClass();
            if (cls == BigDecimal.class) {
                BigDecimal p = (BigDecimal)value;
                this.value = p.setScale(p.scale());
            } else if (cls == KBigDecimalObject.class) {
                this.value = ((KBigDecimalObject)value).value;
            } else if (cls == Float.TYPE || cls == Float.class || cls == Double.class) {
                this.value = BigDecimal.valueOf(((Number)value).doubleValue());
            } else if (cls == Integer.class || cls == Short.TYPE || cls == Short.class) {
                this.value = BigDecimal.valueOf(((Number)value).intValue());
            } else if (cls == Long.class) {
                this.value = BigDecimal.valueOf(((Number)value).longValue());
            } else {
                try {
                    this.value = (BigDecimal)BigDecimal.class.getConstructor(value.getClass()).newInstance(value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(cls + ":" + value, e);
                }
            }
        }
    }

    @KSMethod
    public String toString() {
        return ScriptRuntime.numberToString((double)this.value.doubleValue(), (int)10);
    }

    @KSMethod
    public KBigDecimalObject setScale(Object scale) {
        return new KBigDecimalObject(this.value.setScale((int)KObjectConverter.toTypedObject(Integer.class, scale), RoundingMode.HALF_UP));
    }

    @KSMethod
    public int getScale() {
        return this.value.scale();
    }

    @KSMethod
    public int intValue() {
        return this.value.intValue();
    }

    @KSMethod
    public long longValue() {
        return this.value.longValue();
    }

    @KSMethod
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @KSMethod
    public KBigDecimalObject add(Object object) {
        return new KBigDecimalObject(this.value.add(KObjectConverter.toTypedObject(BigDecimal.class, object)));
    }

    @KSMethod
    public KBigDecimalObject subtract(Object object) {
        return new KBigDecimalObject(this.value.subtract(KObjectConverter.toTypedObject(BigDecimal.class, object)));
    }

    @KSMethod
    public KBigDecimalObject multiply(Object object) {
        return new KBigDecimalObject(KBigDecimalScale.limitMaxScale(this.value.multiply(KObjectConverter.toTypedObject(BigDecimal.class, object))));
    }

    @KSMethod
    public KBigDecimalObject divide(Object object) {
        return new KBigDecimalObject(KBigDecimalScale.limitMaxScale(KNumberOperation.div((BigDecimal)this.value, (BigDecimal)KObjectConverter.toTypedObject(BigDecimal.class, object))));
    }

    @KSMethod
    public KBigDecimalObject divide(Object divisor, int scale, int roundingMode) {
        return new KBigDecimalObject(KBigDecimalScale.limitMaxScale(this.value.divide(KObjectConverter.toTypedObject(BigDecimal.class, divisor), scale, roundingMode)));
    }

    @KSMethod
    public KBigDecimalObject divide(Object divisor, int scale, String roundingMode) {
        return this.divide(divisor, scale, KBigDecimalObject.parseRoundingMode(roundingMode));
    }

    @KSMethod
    public KBigDecimalObject setScale(int newScale, int roundingMode) {
        return new KBigDecimalObject(this.value.setScale(newScale, roundingMode));
    }

    @KSMethod
    public KBigDecimalObject setScale(int newScale, String roundingMode) {
        return this.setScale(newScale, KBigDecimalObject.parseRoundingMode(roundingMode));
    }

    @KSMethod
    public KBigDecimalObject abs() {
        return new KBigDecimalObject(this.value.abs());
    }

    @KSMethod
    public KBigDecimalObject negate() {
        return new KBigDecimalObject(this.value.negate());
    }

    @KSMethod
    public int precision() {
        return this.value.precision();
    }

    @KSMethod
    public KBigDecimalObject pow(Object n) {
        return new KBigDecimalObject(this.value.pow(KObjectConverter.toTypedObject(Integer.class, n)));
    }

    @KSMethod
    public KBigDecimalObject remainder(Object divisor) {
        return new KBigDecimalObject(this.value.remainder(KObjectConverter.toTypedObject(BigDecimal.class, divisor)));
    }

    @KSMethod
    public KBigDecimalObject[] divideAndRemainder(Object divisor) {
        BigDecimal[] vs = this.value.divideAndRemainder(KObjectConverter.toTypedObject(BigDecimal.class, divisor));
        KBigDecimalObject[] rets = new KBigDecimalObject[vs.length];
        int i = 0;
        for (BigDecimal v : vs) {
            rets[i++] = new KBigDecimalObject(v);
        }
        return rets;
    }

    @KSMethod
    public KBigDecimalObject ulp() {
        return new KBigDecimalObject(this.value.ulp());
    }

    @KSMethod
    public int signum() {
        return this.value.signum();
    }

    @KSMethod
    public int compareTo(Object val) {
        return this.value.compareTo(KObjectConverter.toTypedObject(BigDecimal.class, val));
    }

    public boolean equals(Object x) {
        if (x instanceof KBigDecimalObject) {
            x = ((KBigDecimalObject)x).value;
        }
        return this.value.equals(x);
    }

    @Override
    public BigDecimal unwrap() {
        return this.value;
    }

    private static int parseRoundingMode(String roundingMode) {
        Integer m;
        if (roundingMode != null && (m = roundingModeMap.get(roundingMode.trim().toUpperCase())) != null) {
            return m;
        }
        throw new IllegalArgumentException(Resources.getString((String)"\u53c2\u6570roundingMode\u4e0d\u6b63\u786e\uff1a", (String)"KBigDecimalObject_0", (String)"bos-serverscript", (Object[])new Object[0]) + roundingMode);
    }

    static {
        roundingModeMap.put("ROUND_UP", 0);
        roundingModeMap.put("ROUND_DOWN", 1);
        roundingModeMap.put("ROUND_CEILING", 2);
        roundingModeMap.put("ROUND_FLOOR", 3);
        roundingModeMap.put("ROUND_HALF_UP", 4);
        roundingModeMap.put("ROUND_HALF_DOWN", 5);
        roundingModeMap.put("ROUND_HALF_EVEN", 6);
        roundingModeMap.put("ROUND_UNNECESSARY", 7);
    }
}

