/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.util;

import com.google.common.collect.MapMaker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class ThreadLocalEx<T>
extends ThreadLocal<T> {
    private final ConcurrentMap<Thread, T> map = new MapMaker().weakKeys().makeMap();
    private static volatile Method getMapMethod;
    private static volatile Method removeMethod;

    @Override
    public T get() {
        Object val = super.get();
        Thread t = Thread.currentThread();
        if (val == null) {
            this.map.remove(t);
        } else if (!this.map.containsKey(t)) {
            this.map.put(t, val);
        }
        return val;
    }

    @Override
    public void set(T value) {
        this.map.put(Thread.currentThread(), value);
        super.set(value);
    }

    public Set<Thread> keys() {
        return new HashSet<Thread>(this.map.keySet());
    }

    public T get(Thread t) {
        return (T)this.map.get(t);
    }

    @Override
    public void remove() {
        super.remove();
        this.map.remove(Thread.currentThread());
    }

    public void remove(Thread t) {
        try {
            this.map.remove(t);
            Object threadLocalMap = this.invokeGetMethod(t);
            this.invokeRemoveMethod(threadLocalMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object invokeGetMethod(Thread t) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (getMapMethod != null) return getMapMethod.invoke((Object)this, t);
        Class<ThreadLocalEx> clazz = ThreadLocalEx.class;
        synchronized (ThreadLocalEx.class) {
            if (getMapMethod != null) return getMapMethod.invoke((Object)this, t);
            Method getMapMethodLocal = ThreadLocal.class.getDeclaredMethod("getMap", Thread.class);
            getMapMethodLocal.setAccessible(true);
            getMapMethod = getMapMethodLocal;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return getMapMethod.invoke((Object)this, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void invokeRemoveMethod(Object ThreadLocalMap2) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (ThreadLocalMap2 == null) return;
        if (removeMethod == null) {
            Class<ThreadLocalEx> clazz = ThreadLocalEx.class;
            // MONITORENTER : kd.bos.script.util.ThreadLocalEx.class
            if (removeMethod == null) {
                Method removeMethodLocal = ThreadLocalMap2.getClass().getDeclaredMethod("remove", ThreadLocal.class);
                removeMethodLocal.setAccessible(true);
                removeMethod = removeMethodLocal;
            }
            // MONITOREXIT : clazz
        }
        removeMethod.invoke(ThreadLocalMap2, this);
    }
}

