/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filestorage.minio;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.filestorage.minio.minioclient.BosMinIOClient;
import kd.bos.filestorage.spi.FileStorageConfig;
import kd.bos.filestorage.spi.FileStorageService;

public class MinIOStorage
implements FileStorageService {
    private FileStorageConfig fileStorageConfig;
    private BosMinIOClient bosMinIOClient;

    public void setConfig(FileStorageConfig fileStorageConfig) {
        this.fileStorageConfig = fileStorageConfig;
        this.bosMinIOClient = new BosMinIOClient(fileStorageConfig);
    }

    public List<String> getForbiddenExtensions() {
        return new ArrayList<String>();
    }

    public String getTicket() {
        return null;
    }

    public String upload(InputStream inputStream, String filePath, String fileName, boolean isCreateNewFileWhenExists, Map<String, String> headers) throws Exception {
        filePath = this.getRealPath(filePath);
        this.bosMinIOClient.upload(this.fileStorageConfig.getContainer(), filePath, inputStream, headers);
        return filePath;
    }

    public InputStream getInputStream(String fullFilePath, String userAgent) throws Exception {
        return this.bosMinIOClient.getInputStream(this.fileStorageConfig.getContainer(), this.getRealPath(fullFilePath));
    }

    public void download(String fullFilePath, OutputStream outputStream, String userAgent) throws Exception {
        this.bosMinIOClient.download(this.fileStorageConfig.getContainer(), this.getRealPath(fullFilePath), outputStream);
    }

    public void delete(String fullFilePath) throws Exception {
        this.bosMinIOClient.deleteFile(this.fileStorageConfig.getContainer(), this.getRealPath(fullFilePath));
    }

    public boolean exists(String fullFilePath) throws Exception {
        return this.bosMinIOClient.isFileExists(this.fileStorageConfig.getContainer(), this.getRealPath(fullFilePath));
    }

    public void close() {
    }

    public long getFileSize(String path) throws Exception {
        return this.bosMinIOClient.getFileSize(this.fileStorageConfig.getContainer(), path);
    }

    private String getRealPath(String path) {
        if (path.startsWith("/")) {
            path = this.getRealPath(path.replaceFirst("^/", ""));
        }
        if (path.startsWith(this.fileStorageConfig.getContainer())) {
            path = this.getRealPath(path.replaceFirst("^" + this.fileStorageConfig.getContainer(), ""));
        }
        return path;
    }
}

