/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dtx.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dtx.dao.DTXDao;
import kd.bos.dtx.impl.SyncDTXCleaner;

public abstract class AbstractSyncDTXDao<T>
implements DTXDao<T> {
    private static SyncDTXCleaner cleaner = SyncDTXCleaner.getCleaner();
    private boolean initIndexFlag = false;
    private Map<String, Boolean> m = new ConcurrentHashMap<String, Boolean>(4);

    protected abstract String buildCreateTableSQL();

    protected abstract String buildQuerySQL();

    protected abstract String buildQuerySQLForId();

    protected abstract String buildInsertSQL();

    protected abstract String buildDeleteSQL();

    protected abstract String buildCountSQL();

    protected abstract String buildUpdateSQL();

    @Override
    public boolean insert(T info, String dbKey) {
        cleaner.addMoniDB(dbKey);
        if (!this.hasTableInit(dbKey)) {
            this.checkTable(dbKey);
        }
        if (!this.initIndexFlag) {
            this.checkIndex(dbKey);
        }
        String sql = this.buildInsertSQL();
        boolean result = DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])this.buildInsertParam(info));
        return result;
    }

    protected abstract Object[] buildInsertParam(T var1);

    protected abstract void checkIndex(String var1);

    protected abstract void checkTable(String var1);

    public void initTable(String routeKey) {
        this.m.computeIfAbsent(this.genKey(routeKey), k -> Boolean.TRUE);
    }

    public void initIndex() {
        this.initIndexFlag = true;
    }

    private boolean hasTableInit(String routeKey) {
        return this.m.getOrDefault(this.genKey(routeKey), false);
    }

    private String genKey(String routeKey) {
        RequestContext rc = RequestContext.get();
        if (rc != null) {
            return rc.getAccountId() + routeKey;
        }
        return routeKey;
    }

    @Override
    public T get(String id, String dbKey) {
        if (!this.hasTableInit(dbKey)) {
            this.checkTable(dbKey);
        }
        if (!this.initIndexFlag) {
            this.checkIndex(dbKey);
        }
        String querysql = this.buildQuerySQLForId();
        Object info = DB.query((DBRoute)DBRoute.of((String)dbKey), (String)querysql, (Object[])this.buildGetParam(id), rs -> this.valueOf(rs));
        return (T)info;
    }

    @Override
    public T get(T param, String dbKey) {
        if (!this.hasTableInit(dbKey)) {
            this.checkTable(dbKey);
        }
        if (!this.initIndexFlag) {
            this.checkIndex(dbKey);
        }
        String querysql = this.buildQuerySQL();
        Object info = DB.query((DBRoute)DBRoute.of((String)dbKey), (String)querysql, (Object[])this.buildGetParam(param), rs -> this.valueOf(rs));
        return (T)info;
    }

    @Override
    public int count(T param, String dbKey) {
        String querysql = this.buildCountSQL();
        int count = (Integer)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)querysql, (Object[])this.buildCountParam(param), rs -> {
            if (rs.next()) {
                return 1;
            }
            return 0;
        });
        return count;
    }

    protected abstract Object[] buildGetParam(T var1);

    protected abstract Object[] buildGetParam(String var1);

    @Override
    public int count(String id, String dbKey) {
        String querysql = this.buildCountSQL();
        int count = (Integer)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)querysql, (Object[])this.buildCountParam(id), rs -> {
            if (rs.next()) {
                return rs.getInt(1);
            }
            return 0;
        });
        return count;
    }

    protected abstract Object[] buildCountParam(String var1);

    protected abstract Object[] buildCountParam(T var1);

    @Override
    public int update(T info, String dbKey) {
        cleaner.addMoniDB(dbKey);
        String sql = this.buildUpdateSQL();
        return DB.update((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])this.updateParam(info));
    }

    protected abstract Object[] updateParam(T var1);

    @Override
    public int delete(String id, String dbKey) {
        String sql = this.buildDeleteSQL();
        return DB.update((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])this.buildDeleteParam(id));
    }

    protected abstract Object[] buildDeleteParam(String var1);

    @Override
    public boolean createTable(String dbKey) {
        cleaner.addMoniDB(dbKey);
        return DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)this.buildCreateTableSQL(), (Object[])new Object[0]);
    }

    protected abstract T valueOf(ResultSet var1) throws SQLException;
}

