/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dtx.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dtx.XidInfo;
import kd.bos.dtx.dao.AbstractSyncDTXDao;
import kd.bos.dtx.util.SerializerUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class SyncDTXDao
extends AbstractSyncDTXDao<XidInfo> {
    private static final Log logger = LogFactory.getLog(SyncDTXDao.class);
    protected static final String XID_TABLE = "t_dtx_trans";
    private static final String CREATE_TABLE_SQL = MessageFormat.format("create table {0}(xid varchar(40) not null primary key,state smallint default 0,create_time datetime not null,modify_time datetime default null,operation_result Blob,op_code varchar(64) default null,step int not null default 1,return_type int,dynamic_type Blob)  ", "t_dtx_trans");
    private static final String QUERY_SQL = MessageFormat.format("select xid,state,op_code,create_time,operation_result,step from {0} where xid=? and step=?", "t_dtx_trans");
    private static final String QUERY_SQL_FOR_ID = MessageFormat.format("select xid,state,op_code,create_time,operation_result,step from {0} where xid=? ", "t_dtx_trans");
    private static final String INSERT_SQL = MessageFormat.format("insert into {0}(xid,create_time,op_code,step) values(?,?,?,?)", "t_dtx_trans");
    private static final String DELETE_SQL = MessageFormat.format("delete from {0} where xid=?", "t_dtx_trans");
    private static final String COUNT_SQL = MessageFormat.format("select count(xid) from {0} where xid=? and step=? ", "t_dtx_trans");
    private static final String UPDATE_SQL = MessageFormat.format("update {0} set state=1,operation_result=? where xid=? and step=? and state = 0", "t_dtx_trans");
    private static final String CREATE_PK_FLAG = "HAS_CREATE_PK_DTX_TRANS";

    @Override
    public String getTableName() {
        return XID_TABLE;
    }

    @Override
    public String buildCreateTableSQL() {
        return CREATE_TABLE_SQL;
    }

    @Override
    public String buildQuerySQL() {
        return QUERY_SQL;
    }

    @Override
    protected String buildQuerySQLForId() {
        return QUERY_SQL_FOR_ID;
    }

    @Override
    public String buildInsertSQL() {
        return INSERT_SQL;
    }

    @Override
    public String buildDeleteSQL() {
        return DELETE_SQL;
    }

    @Override
    public String buildCountSQL() {
        return COUNT_SQL;
    }

    @Override
    public String buildUpdateSQL() {
        return UPDATE_SQL;
    }

    @Override
    public XidInfo valueOf(ResultSet rs) throws SQLException {
        if (rs.next()) {
            XidInfo info = new XidInfo();
            info.setXid(rs.getString("xid"));
            info.setState(rs.getInt("state"));
            info.setOpCode(rs.getString("op_code"));
            info.setCreateTime(rs.getTimestamp("create_time"));
            try {
                info.setOperationResult(rs.getString("operation_result"));
            }
            catch (Exception e) {
                try {
                    info.setOperationResult(SerializerUtil.transBlob(rs.getBlob("operation_result")));
                }
                catch (Exception e1) {
                    logger.error("transBlob exception", (Throwable)e1);
                }
            }
            info.setStep(rs.getInt("step"));
            return info;
        }
        return null;
    }

    @Override
    public Object[] buildInsertParam(XidInfo info) {
        return new Object[]{info.getXid(), new Date(), info.getOpCode(), info.getStep()};
    }

    @Override
    public Object[] buildGetParam(String id) {
        return new Object[]{id};
    }

    @Override
    protected Object[] buildGetParam(XidInfo info) {
        return new Object[]{info.getXid(), info.getStep()};
    }

    @Override
    public Object[] buildCountParam(String id) {
        return new Object[]{id};
    }

    @Override
    public Object[] buildCountParam(XidInfo info) {
        return new Object[]{info.getXid(), info.getStep()};
    }

    @Override
    public Object[] updateParam(XidInfo info) {
        return new Object[]{info.getOperationResult(), info.getXid(), info.getStep()};
    }

    @Override
    public Object[] buildDeleteParam(String id) {
        return new Object[]{id};
    }

    @Override
    protected void checkIndex(String dbKey) {
        if (!DB.exitsIndex((DBRoute)DBRoute.of((String)dbKey), (String)XID_TABLE, (String)"idx_xid")) {
            DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)"create index idx_xid on t_dtx_trans(xid,step) ");
        }
        if (!DB.exitsIndex((DBRoute)DBRoute.of((String)dbKey), (String)XID_TABLE, (String)"idx_xid_time")) {
            DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)"create index idx_xid_time on t_dtx_trans(create_time) ");
        }
        this.initIndex();
    }

    @Override
    protected void checkTable(String dbKey) {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)XID_TABLE)) {
            this.createTable(dbKey);
        } else {
            try (TXHandle handle = TX.requiresNew((String)"CREATE_PK_DTX_TRANS");){
                Object info = DB.query((DBRoute)DBRoute.of((String)dbKey), (String)this.buildQuerySQLForId(), (Object[])this.buildGetParam(CREATE_PK_FLAG), rs -> this.valueOf(rs));
                if (info == null) {
                    String fixPkSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_CONSTRAINTS WHERE KSQL_CONS_TABNAME = 'T_DTX_TRANS' AND KSQL_CONS_NAME = 'PK_DTX_TRANS') EXEC P_ALTERPK 'PK_DTX_TRANS', 'T_DTX_TRANS', 'XID', '1'";
                    DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)this.buildInsertSQL(), (Object[])new Object[]{CREATE_PK_FLAG, new Date(System.currentTimeMillis() + 1471228928L), CREATE_PK_FLAG, 0});
                    DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)fixPkSql);
                }
            }
            catch (Exception e) {
                logger.error("syncDTXDao fix pk error", (Throwable)e);
            }
        }
        this.initTable(dbKey);
    }
}

