/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dtx.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dtx.dao.AbstractSyncDTXDao;
import kd.bos.dtx.model.RetryInfo;
import kd.bos.dtx.util.SerializerUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class SyncRetryDTXDao
extends AbstractSyncDTXDao<RetryInfo> {
    private static final Log logger = LogFactory.getLog(SyncRetryDTXDao.class);
    protected static final String XID_TABLE = "t_dtx_retrys";
    private static final String CREATE_TABLE_SQL = MessageFormat.format("create table {0}(rxid varchar(40) not null primary key,xid varchar(40) not null,create_time datetime not null,modify_time datetime default null,operation_result varchar(512),op_code varchar(64) default null,step int not null default 1 )  ", "t_dtx_retrys");
    private static final String QUERY_SQL = MessageFormat.format("select rxid, xid,create_time,operation_result,step from {0} where rxid=?", "t_dtx_retrys");
    private static final String INSERT_SQL = MessageFormat.format("insert into {0}(rxid,xid,op_code,create_time,step) values(?,?,?,?,?)", "t_dtx_retrys");
    private static final String DELETE_SQL = MessageFormat.format("delete from {0} where rxid=?", "t_dtx_retrys");
    private static final String COUNT_SQL = MessageFormat.format("select count(rxid) from {0} where xid=? ", "t_dtx_retrys");

    @Override
    public String getTableName() {
        return XID_TABLE;
    }

    @Override
    public String buildCreateTableSQL() {
        return CREATE_TABLE_SQL;
    }

    @Override
    public String buildQuerySQL() {
        return QUERY_SQL;
    }

    @Override
    protected String buildQuerySQLForId() {
        return QUERY_SQL;
    }

    @Override
    public String buildInsertSQL() {
        return INSERT_SQL;
    }

    @Override
    public String buildDeleteSQL() {
        return DELETE_SQL;
    }

    @Override
    public String buildCountSQL() {
        return COUNT_SQL;
    }

    @Override
    public String buildUpdateSQL() {
        return null;
    }

    @Override
    public int update(RetryInfo info, String dbKey) {
        return 0;
    }

    @Override
    public RetryInfo valueOf(ResultSet rs) throws SQLException {
        if (rs.next()) {
            RetryInfo info = new RetryInfo();
            info.setXid(rs.getString("xid"));
            info.setRxid(rs.getString("rxid"));
            info.setCreateTime(rs.getTimestamp("create_time"));
            try {
                info.setOperationResult(rs.getString("operation_result"));
            }
            catch (Exception e) {
                try {
                    info.setOperationResult(SerializerUtil.transBlob(rs.getBlob("operation_result")));
                }
                catch (Exception e1) {
                    logger.error("transBlob exception", (Throwable)e1);
                }
            }
            info.setStep(rs.getInt("step"));
            return info;
        }
        return null;
    }

    @Override
    public Object[] buildInsertParam(RetryInfo info) {
        return new Object[]{info.getRxid(), info.getXid(), info.getOpCode(), new Date(), info.getStep()};
    }

    @Override
    public Object[] buildGetParam(String id) {
        return new Object[]{id};
    }

    @Override
    protected Object[] buildGetParam(RetryInfo info) {
        return null;
    }

    @Override
    protected Object[] buildCountParam(RetryInfo info) {
        return new Object[]{info.getXid()};
    }

    @Override
    public Object[] buildCountParam(String id) {
        return new Object[]{id};
    }

    @Override
    public Object[] updateParam(RetryInfo info) {
        return null;
    }

    @Override
    public Object[] buildDeleteParam(String id) {
        return new Object[]{id};
    }

    @Override
    protected void checkIndex(String dbKey) {
        if (!DB.exitsIndex((DBRoute)DBRoute.of((String)dbKey), (String)XID_TABLE, (String)"idx_rxid")) {
            DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)"create index idx_rxid on t_dtx_retrys(xid) ");
        }
        if (!DB.exitsIndex((DBRoute)DBRoute.of((String)dbKey), (String)XID_TABLE, (String)"idx_rxid_time")) {
            DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)"create index idx_rxid_time on t_dtx_retrys(create_time) ");
        }
        this.initIndex();
    }

    @Override
    protected void checkTable(String dbKey) {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)XID_TABLE)) {
            this.createTable(dbKey);
        }
        this.initTable(dbKey);
    }
}

