/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dtx.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dtx.XidInfo;
import kd.bos.dtx.util.SerializerUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;

public class SyncDTXCleaner {
    private static final Log log = LogFactory.getLog((String)"SyncDTXCleaner");
    private static SyncDTXCleaner cleaner = new SyncDTXCleaner();
    private Set<String> dbs = new TreeSet<String>();
    private boolean started = false;
    private static int stime1 = 0;
    private static int stime2 = 0;
    private static int stime3 = 0;
    private RequestContext rc = null;
    private static final String TRANS_QUERYSQL = "select xid,state,operation_result from t_dtx_trans where create_time<=? and state=0";
    private static final String TRANS_PREPARED_DELETESQL = "delete from t_dtx_trans where create_time<? and state=0";
    private static final String TRANS_MQ_DELETESQL = "delete from t_dtx_trans where create_time<? and op_code='MQ'";
    private static final String RETRY_DELETESQL = "delete from t_dtx_retrys where create_time<? ";

    public static SyncDTXCleaner getCleaner() {
        return cleaner;
    }

    private SyncDTXCleaner() {
    }

    public void startScan() {
        this.start();
    }

    public void addMoniDB(String dbKey) {
        this.dbs.add(dbKey);
        if (this.rc == null) {
            this.rc = RequestContext.get();
        }
        if (!this.started) {
            this.startScan();
            this.started = true;
        }
    }

    private void start() {
        log.info("SyncDTXCleaner start work...");
        ScheduledExecutorService es = Executors.newSingleThreadScheduledExecutor();
        Consumer<String> xidconsumer = p -> this.cleanXid((String)p);
        Consumer<String> mqXidconsumer = p -> this.cleanMQXid((String)p);
        Consumer<String> retryconsumer = p -> this.cleanRetry((String)p);
        es.scheduleAtFixedRate(ThreadLifeCycleManager.wrapRunnable(() -> {
            for (String db : this.dbs) {
                xidconsumer.accept(db);
            }
        }), 1800L, 1800L, TimeUnit.SECONDS);
        es.scheduleAtFixedRate(ThreadLifeCycleManager.wrapRunnable(() -> {
            for (String db : this.dbs) {
                mqXidconsumer.accept(db);
            }
        }), 1800L, 1800L, TimeUnit.SECONDS);
        es.scheduleAtFixedRate(ThreadLifeCycleManager.wrapRunnable(() -> {
            for (String db : this.dbs) {
                retryconsumer.accept(db);
            }
        }), 300L, 300L, TimeUnit.SECONDS);
    }

    private void cleanXid(String dbKey) {
        RequestContext.set((RequestContext)this.rc);
        try {
            if (!DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)"t_dtx_trans")) {
                return;
            }
            Date now = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            calendar.add(11, -stime1);
            try (TXHandle h = TX.beginRequired();){
                String sql = TRANS_PREPARED_DELETESQL;
                DB.update((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{calendar.getTime()});
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
        }
        catch (Exception t) {
            log.error((Throwable)t);
        }
    }

    private void cleanMQXid(String dbKey) {
        RequestContext.set((RequestContext)this.rc);
        try {
            if (!DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)"t_dtx_trans")) {
                return;
            }
            Date now = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            calendar.add(11, -stime2);
            try (TXHandle h = TX.beginRequired();){
                String sql = TRANS_MQ_DELETESQL;
                DB.update((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{calendar.getTime()});
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
        }
        catch (Exception t) {
            log.error((Throwable)t);
        }
    }

    private void cleanRetry(String dbKey) {
        RequestContext.set((RequestContext)this.rc);
        try {
            if (!DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)"t_dtx_retrys")) {
                return;
            }
            Date now = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            calendar.add(11, -stime3);
            try (TXHandle h = TX.beginRequired();){
                String sql = RETRY_DELETESQL;
                DB.update((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{calendar.getTime()});
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
        }
        catch (Exception t) {
            log.error((Throwable)t);
        }
    }

    private List<XidInfo> queryXid(String dbKey) {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(6, -3);
        List data = (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)TRANS_QUERYSQL, (Object[])new Object[]{calendar.getTime()}, rs -> {
            ArrayList<XidInfo> list = new ArrayList<XidInfo>(8);
            while (rs.next()) {
                XidInfo info = new XidInfo();
                info.setXid(rs.getString("xid"));
                info.setState(rs.getInt("state"));
                info.setOpCode(rs.getString("op_code"));
                try {
                    info.setOperationResult(rs.getString("operation_result"));
                }
                catch (Exception e) {
                    try {
                        info.setOperationResult(SerializerUtil.transBlob(rs.getBlob("operation_result")));
                    }
                    catch (Exception e1) {
                        log.error("transBlob exception", (Throwable)e1);
                    }
                }
                list.add(info);
            }
            return list;
        });
        return data;
    }

    static {
        String time = System.getProperty("dtx.clean.scheduletime", "72,24,24");
        String[] timeArray = time.split(",");
        stime1 = Integer.parseInt(timeArray[0]);
        stime2 = Integer.parseInt(timeArray[1]);
        stime3 = Integer.parseInt(timeArray[2]);
    }
}

