/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dtx.impl;

import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.dtx.DTXService;
import kd.bos.dtx.XidInfo;
import kd.bos.dtx.dao.DTXDao;
import kd.bos.dtx.dao.SyncDTXDao;
import kd.bos.dtx.util.Configuration;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class SyncDTXService
implements DTXService {
    private static final Log log = LogFactory.getLog((String)"SyncDTXService");
    private static String XID_PREFIX = "dtxid_";
    private static final String MAGIC_STRING = " record[";
    private DTXDao<XidInfo> dao = new SyncDTXDao();
    private static ThreadLocal<DTXContext> current = new ThreadLocal();

    private String generateXid() {
        return XID_PREFIX + DB.genLongId((String)this.dao.getTableName());
    }

    private String generateXid(String xid) {
        return XID_PREFIX + xid;
    }

    @Override
    public void setXid(String xid) {
        this.newXid(xid, null, null);
    }

    @Override
    public String newXid() {
        return this.newXid(null, null, null);
    }

    @Override
    public String newXid(String routeKey) {
        return this.newXid(null, routeKey, null);
    }

    @Override
    public String newXid(String xid, String routeKey) {
        return this.newXid(xid, routeKey, null);
    }

    @Override
    public String newXid(String xid, String routeKey, String opcode) {
        log.debug("enable.xid:" + Configuration.isEnable() + " xid:" + xid);
        if (!Configuration.isEnable()) {
            return null;
        }
        String newxid = null;
        newxid = SyncDTXService.isNotEmpty(xid) ? this.generateXid(xid) : this.generateXid();
        RequestContext rc = RequestContext.get();
        if (rc != null) {
            rc.setXid(newxid);
            rc.setXidStep(1);
            log.debug("requestContext xid is:" + rc.getXid());
            if (SyncDTXService.isNotEmpty(routeKey)) {
                this.handleNotExistTable(routeKey);
                boolean result = this.dao.insert(new XidInfo(rc.getXid(), opcode), routeKey);
                if (!result) {
                    throw new KDException("insert a new xid into db:" + routeKey + " failed.");
                }
            }
        } else {
            throw new KDException("can not find a RequestContext when try to generate distributed transaction");
        }
        return newxid;
    }

    private void handleNotExistTable(String routeKey) {
        if (!this.existTable(routeKey)) {
            try {
                TX.beginNew();
                this.dao.createTable(routeKey);
            }
            catch (Exception ex) {
                log.error("create table " + this.dao.getTableName() + " failed,", (Throwable)ex);
            }
            finally {
                TX.end();
            }
        }
    }

    private boolean existTable(String routeKey) {
        return DB.exitsTable((DBRoute)DBRoute.of((String)routeKey), (String)this.dao.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XidInfo prepareXid(String routeKey) {
        if (!Configuration.isEnable()) {
            return null;
        }
        log.debug("prepareXid and routeKey is:" + routeKey);
        RequestContext rc = RequestContext.get();
        if (rc != null) {
            log.debug("requestContext xid is:" + rc.getXid());
            if (rc.getXid() != null) {
                XidInfo xidInfo = null;
                DTXContext context = current.get();
                if (context == null) {
                    context = new DTXContext();
                    context.state = 0;
                    context.xid = rc.getXid();
                    context.step = rc.getXidStep();
                    current.set(context);
                } else if (context.xid == null || !context.xid.equals(rc.getXid())) {
                    context = new DTXContext();
                    context.state = 0;
                    context.xid = rc.getXid();
                    context.step = rc.getXidStep();
                    current.set(context);
                } else {
                    DTXContext previous = context;
                    context = new DTXContext();
                    context.state = 0;
                    context.xid = rc.getXid();
                    if (context.state == 0) {
                        context.step = previous.step + 1;
                        context.parent = previous;
                    } else if (context.state == 1) {
                        context.step = previous.step + 1;
                        context.parent = previous.parent;
                    }
                    current.set(context);
                }
                if (!this.existTable(routeKey)) {
                    try {
                        TX.beginNew();
                        this.dao.createTable(routeKey);
                    }
                    catch (Exception ex) {
                        log.warn("create table " + this.dao.getTableName() + " failed,", (Throwable)ex);
                    }
                    finally {
                        TX.end();
                    }
                } else {
                    xidInfo = this.dao.get(new XidInfo(rc.getXid(), SyncDTXService.current.get().step), routeKey);
                }
                if (xidInfo != null) {
                    return xidInfo;
                }
                try {
                    TX.beginNew();
                    XidInfo xi = new XidInfo(rc.getXid(), SyncDTXService.current.get().step);
                    boolean result = this.dao.insert(xi, routeKey);
                    if (result) {
                        xi.setState(0);
                        xi.setOperationResult(null);
                        XidInfo xidInfo2 = xi;
                        return xidInfo2;
                    }
                    throw new KDException("insert a new xid into db:" + routeKey + " failed.");
                }
                finally {
                    TX.end();
                }
            }
            return null;
        }
        throw new KDException("can find a RequestContext when try to prepare distributed transaction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void confirmXid(String routeKey, String operationResult) {
        if (!Configuration.isEnable()) {
            return;
        }
        log.debug("confirmXid and routeKey is:" + routeKey);
        RequestContext rc = RequestContext.get();
        if (rc == null) throw new KDException("can find a RequestContext when try to confirm distributed transaction");
        if (rc.getXid() == null) return;
        if (!this.existTable(routeKey)) {
            throw new KDException("table " + this.dao.getTableName() + " doesn't exist in db:" + routeKey);
        }
        DTXContext context = current.get();
        if (context == null) {
            throw new KDException("can find a DTXContext when try to confirm distributed transaction");
        }
        DTXContext cur = context;
        while (context.state == 1) {
            context = context.parent;
            if (context != null) continue;
            throw new KDException("unkown exception happen, cannot find a prepare DTXContext when try to confirm distributed transaction");
        }
        try {
            int result = this.dao.update(new XidInfo(rc.getXid(), 1, operationResult, context.step), routeKey);
            if (result == 1) return;
            log.warn("confirm " + this.dao.getTableName() + MAGIC_STRING + rc.getXid() + "] failed");
            return;
        }
        finally {
            context.state = 1;
            if (context.parent == null) {
                current.set(null);
            }
            rc.setXidStep(cur.step + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteXid(String routeKey, String xid) {
        if (!Configuration.isEnable()) {
            return;
        }
        log.debug("deleteXid and routeKey is:" + routeKey);
        if (!this.existTable(routeKey)) {
            throw new KDException("table " + this.dao.getTableName() + " doesn't exist in db:" + routeKey);
        }
        try {
            TX.beginNew();
            int result = this.dao.delete(xid, routeKey);
            if (result <= 0) {
                int count = this.dao.count(xid, routeKey);
                if (count > 0) {
                    throw new KDException("delete " + this.dao.getTableName() + MAGIC_STRING + xid + "] failed in db:" + routeKey);
                }
                log.warn(this.dao.getTableName() + MAGIC_STRING + xid + "] has been delete before");
            } else {
                log.debug("delete " + this.dao.getTableName() + MAGIC_STRING + xid + "] success in db:" + routeKey);
            }
        }
        finally {
            TX.end();
        }
    }

    @Override
    public XidInfo getXid(String routeKey, String xid) {
        if (!Configuration.isEnable()) {
            return null;
        }
        RequestContext rc = RequestContext.get();
        XidInfo xidInfo = this.dao.get(new XidInfo(xid, rc.getXidStep()), routeKey);
        return xidInfo;
    }

    @Override
    public XidInfo getXid(String routeKey, String xid, int step) {
        if (!Configuration.isEnable()) {
            return null;
        }
        XidInfo xidInfo = this.dao.get(new XidInfo(xid, step), routeKey);
        return xidInfo;
    }

    public static boolean isEmpty(String string) {
        return SyncDTXService.isNull(string) || SyncDTXService.isBlank(string);
    }

    public static boolean isNotEmpty(String string) {
        return !SyncDTXService.isEmpty(string);
    }

    public static boolean isNull(String string) {
        return string == null;
    }

    public static boolean isNotNull(String string) {
        return !SyncDTXService.isNull(string);
    }

    public static boolean isBlank(String string) {
        return SyncDTXService.isNotNull(string) && string.trim().length() == 0;
    }

    public static DTXContext get() {
        return current.get();
    }

    public static void set(DTXContext rc) {
        current.set(rc);
    }

    public static class DTXContext {
        protected DTXContext parent;
        protected int step;
        protected String xid;
        protected int state;
    }
}

