/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dtx.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.nio.charset.Charset;
import kd.bos.dtx.serializer.ObjectSerializer;
import org.apache.commons.lang3.SerializationException;

public class JSONSerializer<T>
implements ObjectSerializer<T> {
    private static final String DEFAULT_CHARSET = "UTF-8";

    @Override
    public byte[] serialize(T t) {
        return JSON.toJSONString(t).getBytes(Charset.forName(DEFAULT_CHARSET));
    }

    @Override
    @Deprecated
    public T deserialize(byte[] bytes) {
        try {
            TypeReference type = new TypeReference<T>(){};
            Object obj = JSON.parseObject((String)new String(bytes, DEFAULT_CHARSET), (TypeReference)type, (Feature[])new Feature[0]);
            return (T)obj;
        }
        catch (Exception ex) {
            throw new SerializationException("JSON deserialize error,", (Throwable)ex);
        }
    }

    @Override
    public T deserialize(byte[] bytes, Class<T> cls) {
        try {
            return (T)JSON.parseObject((String)new String(bytes, DEFAULT_CHARSET), cls);
        }
        catch (Exception ex) {
            throw new SerializationException("JSON deserialize error,", (Throwable)ex);
        }
    }
}

