/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.broadcast;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.Broadcast;
import kd.bos.mq.broadcast.BroadcastItem;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BroadcastService {
    private static Log logger = LogFactory.getLog(BroadcastService.class);

    public static void start() {
        if (BroadcastService.broadcastDisable()) {
            return;
        }
        try {
            Broadcast._$getBroadcast().registerBroadcastConsumer();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static void boradcastMessage(String className, String methodName, Object[] params) {
        BroadcastService.broadcastMessage(className, methodName, params);
    }

    public static void broadcastMessage(String className, String methodName, Object[] params) {
        if (BroadcastService.broadcastDisable()) {
            return;
        }
        BroadcastItem item = new BroadcastItem();
        item.setClassName(className);
        item.setMethod(methodName);
        item.setParams(params);
        byte[] msgbt = BroadcastService.toByte(item);
        Broadcast._$getBroadcast().broadcastMessage(msgbt);
    }

    public static void broadcastMessageContainSelf(String className, String methodName, Object[] params) {
        if (BroadcastService.broadcastDisable()) {
            return;
        }
        BroadcastItem item = new BroadcastItem();
        item.setClassName(className);
        item.setMethod(methodName);
        item.setParams(params);
        item.setBroadcastContainSelf(true);
        byte[] msgbt = BroadcastService.toByte(item);
        Broadcast._$getBroadcast().broadcastMessage(msgbt);
    }

    public static void boradcastMessageWithApp(String appId, String className, String methodName, Object[] params) {
        BroadcastService.broadcastMessageWithApp(appId, className, methodName, params);
    }

    public static void broadcastMessageWithApp(String appId, String className, String methodName, Object[] params) {
        if (BroadcastService.broadcastDisable()) {
            return;
        }
        BroadcastItem item = new BroadcastItem();
        item.setClassName(className);
        item.setMethod(methodName);
        item.setParams(params);
        byte[] msgbt = BroadcastService.toByte(item);
        Broadcast._$getBroadcast().broadcastMessage(appId, msgbt);
    }

    public static void broadcastMessageContainSelfWithApp(String appId, String className, String methodName, Object[] params) {
        if (BroadcastService.broadcastDisable()) {
            return;
        }
        BroadcastItem item = new BroadcastItem();
        item.setClassName(className);
        item.setMethod(methodName);
        item.setParams(params);
        item.setBroadcastContainSelf(true);
        byte[] msgbt = BroadcastService.toByte(item);
        Broadcast._$getBroadcast().broadcastMessage(appId, msgbt);
    }

    private static byte[] toByte(Object o) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            byte[] bytes = baos.toByteArray();
            oos.close();
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean broadcastDisable() {
        return Boolean.getBoolean("boradcast.disable");
    }
}

