/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.broadcast;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.instance.Instance;
import kd.bos.mq.broadcast.BroadcastItem;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.thread.ThreadLifeCycleManager;

public class MessageReceive {
    private static MessageReceive messageReceiveInstance = new MessageReceive();
    private Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>();

    public static MessageReceive instance() {
        return messageReceiveInstance;
    }

    public void onMessage(byte[] messages) {
        try {
            ThreadLifeCycleManager.start();
            BroadcastItem item = (BroadcastItem)MessageReceive.fromByte(messages);
            this.dealMesssage(item);
        }
        finally {
            ThreadLifeCycleManager.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void dealMesssage(BroadcastItem message) {
        if (Instance.getInstanceId().equals(message.getInstanceid()) && !message.isBroadcastContainSelf()) {
            return;
        }
        try {
            Method m = null;
            String methodKey = message.getClassName() + message.getMethod();
            Class<?> c = Class.forName(message.getClassName());
            if (!this.methodCache.containsKey(methodKey)) {
                Class<MessageReceive> clazz = MessageReceive.class;
                // MONITORENTER : kd.bos.mq.broadcast.MessageReceive.class
                if (!this.methodCache.containsKey(methodKey)) {
                    Method[] methods;
                    for (Method method : methods = c.getDeclaredMethods()) {
                        if (!method.getName().equals(message.getMethod())) continue;
                        m = method;
                        this.methodCache.put(methodKey, m);
                        break;
                    }
                }
                // MONITOREXIT : clazz
            }
            this.methodCache.get(methodKey).invoke(c, message.getParams());
            return;
        }
        catch (Exception e) {
            ExceptionLogger.log("consume broadcast messgae error", e);
        }
    }

    private static Object fromByte(byte[] bytes) {
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

