/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.dlx;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.dlx.DLXStrategy;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.tenant.listener.TenantListenerManager;
import kd.bos.util.StringUtils;

public class DLXConfig {
    private static final Log log = LogFactory.getLog(DLXConfig.class);
    public static final String DLX_STORE_STRATEGY = "mq.dlx.store.strategy";
    public static final int QUEUE_MAX_LENGTH = 1000000;
    public static final String MQ_DLX_SERVER = "mq.dlx.server";
    private static Set<String> allAccount = new ConcurrentSkipListSet<String>();
    public static final boolean MQ_DLX_ENABLE = Boolean.getBoolean("mq.dlx.enable");
    public static final int SEND_ERROR_COUNT = Integer.parseInt(System.getProperty("mq.dlx.error.count", "3"));
    private static Map<String, String> mqTypeMap;

    public static boolean isSendDLX(RequestContext context) {
        if (MQ_DLX_ENABLE) {
            String accountId = context.getAccountId();
            return !StringUtils.isEmpty((String)accountId) && !allAccount.contains(accountId);
        }
        return false;
    }

    public static String getMQType(String region) {
        String type = mqTypeMap.get(region);
        if (type != null) {
            return type;
        }
        String serverKey = "mq.dlx.server." + region;
        String server = System.getProperty(serverKey);
        try {
            if (server != null) {
                Properties prop = new Properties();
                StringReader reader = new StringReader(server);
                prop.load(reader);
                type = Objects.requireNonNull(prop.getProperty("type"), "type can't be empty.");
            } else {
                type = mqTypeMap.get(MQ_DLX_SERVER);
                if (type != null) {
                    return type;
                }
                server = System.getProperty(MQ_DLX_SERVER);
                if (server == null) {
                    throw new KDException(BosErrorCode.mqServerConfiguration, new Object[]{"mq server not config for " + server});
                }
                Properties prop = new Properties();
                StringReader reader = new StringReader(server);
                prop.load(reader);
                type = Objects.requireNonNull(prop.getProperty("type"), "DLXConfig.getMQType() type can't be empty.");
                region = MQ_DLX_SERVER;
            }
        }
        catch (IOException e) {
            log.error("get mq type exception", (Throwable)e);
        }
        mqTypeMap.put(region, type);
        return type != null ? type.trim() : null;
    }

    public static String getDLXServerKey(String region) {
        String serverKey = "mq.dlx.server." + region;
        String server = System.getProperty(serverKey);
        if (server != null) {
            return serverKey;
        }
        return MQ_DLX_SERVER;
    }

    public static DLXStrategy getDLXStrategy() {
        String property = System.getProperty(DLX_STORE_STRATEGY, "default");
        return DLXStrategy.getStrategy(property);
    }

    static {
        try {
            List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
            for (Account account : accounts) {
                allAccount.add(account.getAccountId());
            }
            TenantListenerManager.addTenantListener((TenantListener)new TenantListener(){

                public void onTenantAccountsRemoved(TenantListenerInfo tenantListenerInfo) {
                    for (Account account : tenantListenerInfo.getAccountList()) {
                        allAccount.remove(account.getAccountId());
                    }
                }

                public void onTenantAccountsAdded(TenantListenerInfo tenantListenerInfo) {
                    for (Account account : tenantListenerInfo.getAccountList()) {
                        allAccount.add(account.getAccountId());
                    }
                }

                public void onTenantChanged(TenantListenerInfo tenantListenerInfo) {
                }
            });
        }
        catch (Exception e) {
            log.error("init all Accounts Exception");
        }
        mqTypeMap = new ConcurrentHashMap<String, String>();
    }
}

